/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-11-11 07:56:22 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3979 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1042923 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3309 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=654 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=405 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_digits_blocked_ip` (
  `ip` varchar(32) NOT NULL,
  `block` varchar(32) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `ID` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_digits_mobile_otp` (
  `countrycode` mediumint(8) NOT NULL,
  `mobileno` varchar(20) NOT NULL,
  `otp` varchar(32) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `ID` (`mobileno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_digits_requests_log` (
  `ip` varchar(32) NOT NULL,
  `requests` varchar(32) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `ID` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_announcement` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(11) NOT NULL,
  `status` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_dokan_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL,
  `seller_id` bigint(20) DEFAULT NULL,
  `order_total` float(11,4) DEFAULT NULL,
  `net_amount` float(11,4) DEFAULT NULL,
  `order_status` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `seller_id` (`seller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_dokan_refund` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `seller_id` bigint(20) NOT NULL,
  `refund_amount` float NOT NULL,
  `refund_reason` text DEFAULT NULL,
  `item_qtys` varchar(50) DEFAULT NULL,
  `item_totals` varchar(50) DEFAULT NULL,
  `item_tax_totals` varchar(50) DEFAULT NULL,
  `restock_items` varchar(10) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_dokan_vendor_balance` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `vendor_id` bigint(20) unsigned NOT NULL,
  `trn_id` bigint(20) unsigned NOT NULL,
  `trn_type` varchar(30) NOT NULL,
  `perticulars` text NOT NULL,
  `debit` float NOT NULL,
  `credit` float NOT NULL,
  `status` varchar(30) DEFAULT NULL,
  `trn_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `balance_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_dokan_withdraw` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `amount` float NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  `note` text NOT NULL,
  `ip` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_melipayamak_GFVerification` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `lead_id` mediumint(10) unsigned NOT NULL,
  `try_num` mediumint(10) unsigned NOT NULL,
  `sent_num` mediumint(10) unsigned NOT NULL,
  `mobile` varchar(12) NOT NULL,
  `code` varchar(250) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_melipayamak_groups` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `gdate` varchar(50) NOT NULL,
  `gname` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `gshow` smallint(1) NOT NULL,
  PRIMARY KEY (`gid`),
  KEY `gshow` (`gshow`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_melipayamak_members` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` varchar(50) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `lname` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `gender` smallint(1) NOT NULL,
  `sync` smallint(1) NOT NULL,
  `status` smallint(1) NOT NULL,
  `mobile` varchar(12) NOT NULL,
  `gid` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mobile` (`mobile`),
  KEY `gid` (`gid`),
  KEY `status` (`status`),
  KEY `sync` (`sync`),
  KEY `date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_melipayamak_messages` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` varchar(50) NOT NULL,
  `message` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `sender` varchar(50) NOT NULL,
  `recipient` text NOT NULL,
  `mode` smallint(1) NOT NULL,
  `flash` smallint(1) NOT NULL,
  `delivery` text NOT NULL,
  `is_voice` smallint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `sender` (`sender`),
  KEY `mode` (`mode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2481714 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9299 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3226 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_simple_auction_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(20) unsigned NOT NULL,
  `auction_id` bigint(20) unsigned DEFAULT NULL,
  `bid` decimal(32,4) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `proxy` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `path_hash` char(32) DEFAULT NULL,
  `resize` varchar(55) DEFAULT NULL,
  `lossy` varchar(55) DEFAULT NULL,
  `error` varchar(55) DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=196 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=400 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=196 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=58092 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=228 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`),
  KEY `billing_email` (`billing_email`),
  KEY `type_status` (`type`,`status`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_weforms_entries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` int(11) unsigned DEFAULT NULL,
  `user_device` varchar(50) DEFAULT NULL,
  `referer` varchar(255) DEFAULT NULL,
  `status` varchar(10) DEFAULT 'publish',
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_weforms_entrymeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `weforms_entry_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(250)),
  KEY `entry_id` (`weforms_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=38629 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yith_wcact_auction` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `auction_id` bigint(20) NOT NULL,
  `bid` varchar(255) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yith_wcwl` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `prod_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `position` int(11) DEFAULT 0,
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `on_sale` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30990 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_yith_wcwl_lists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text DEFAULT NULL,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT 0,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `session_id` varchar(255) DEFAULT NULL,
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  UNIQUE KEY `wishlist_token_2` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=InnoDB AUTO_INCREMENT=29750 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("3561", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-02-25 07:32:12", "2023-02-25 11:02:12", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677310332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677310332;}", "5", "1", "2023-02-25 07:32:23", "2023-02-25 11:02:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3600", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-04-05 20:36:13", "2023-04-06 01:06:13", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1680726973;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1680726973;}", "5", "1", "2023-04-05 20:37:12", "2023-04-06 01:07:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3643", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-14 09:08:36", "2023-05-14 13:38:36", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1684055316;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1684055316;}", "5", "1", "2023-05-14 09:08:37", "2023-05-14 13:38:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3669", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-06-12 13:24:13", "2023-06-12 17:54:13", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686576253;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686576253;}", "5", "1", "2023-06-12 13:24:14", "2023-06-12 17:54:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3951", "woocommerce_cleanup_draft_orders", "complete", "2025-06-19 20:50:17", "2025-06-20 00:20:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750366217;s:18:\"\0*\0first_timestamp\";i:1658587731;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750366217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-11-11 07:38:42", "2025-11-11 11:08:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3952", "woocommerce_cleanup_draft_orders", "pending", "2025-11-12 07:38:42", "2025-11-12 11:08:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762933122;s:18:\"\0*\0first_timestamp\";i:1658587731;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762933122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3953", "fetch_patterns", "complete", "2025-11-11 07:43:13", "2025-11-11 11:13:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762846993;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762846993;}", "6", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3954", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-11 07:43:17", "2025-11-11 11:13:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762846997;s:18:\"\0*\0first_timestamp\";i:1762846997;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762846997;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3955", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-11-11 07:43:17", "2025-11-11 11:13:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762846997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762846997;}", "5", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3956", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:17", "2025-11-11 11:13:17", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762846997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762846997;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3957", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:18", "2025-11-11 11:13:18", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762846998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762846998;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3958", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:19", "2025-11-11 11:13:19", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762846999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762846999;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3959", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:20", "2025-11-11 11:13:20", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762847000;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762847000;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3960", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:21", "2025-11-11 11:13:21", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762847001;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762847001;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3961", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:22", "2025-11-11 11:13:22", "{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762847002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762847002;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3962", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:23", "2025-11-11 11:13:23", "{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762847003;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762847003;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3963", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:24", "2025-11-11 11:13:24", "{\"update_callback\":\"wc_update_1020_add_old_refunded_order_items_to_product_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762847004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762847004;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3964", "woocommerce_run_update_callback", "complete", "2025-11-11 07:43:25", "2025-11-11 11:13:25", "{\"update_callback\":\"wc_update_1030_add_comments_date_type_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762847005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762847005;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3965", "woocommerce_update_db_to_current_version", "complete", "2025-11-11 07:43:26", "2025-11-11 11:13:26", "{\"version\":\"10.3.4\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762847006;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762847006;}", "2", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042918", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3966", "woocommerce_scheduled_sales", "pending", "2025-11-11 21:00:00", "2025-11-12 00:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762894800;s:18:\"\0*\0first_timestamp\";i:1762894800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762894800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3967", "woocommerce_cancel_unpaid_orders", "pending", "2025-11-11 08:43:33", "2025-11-11 12:13:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762850613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762850613;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3968", "woocommerce_cleanup_personal_data", "complete", "2025-11-11 07:43:43", "2025-11-11 11:13:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762847023;s:18:\"\0*\0first_timestamp\";i:1762847023;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762847023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-11-11 07:44:57", "2025-11-11 11:14:57", "1042921", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3969", "woocommerce_cleanup_logs", "pending", "2025-11-12 00:00:00", "2025-11-12 03:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762905600;s:18:\"\0*\0first_timestamp\";i:1762905600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762905600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3970", "woocommerce_cleanup_sessions", "pending", "2025-11-12 03:00:00", "2025-11-12 06:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762916400;s:18:\"\0*\0first_timestamp\";i:1762916400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762916400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3971", "woocommerce_geoip_updater", "pending", "2025-11-12 03:00:00", "2025-11-12 06:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762916400;s:18:\"\0*\0first_timestamp\";i:1762916400;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762916400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3972", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-11-12 00:00:00", "2025-11-12 03:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762905600;s:18:\"\0*\0first_timestamp\";i:1762905600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762905600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3973", "wc_admin_daily_wrapper", "complete", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762847013;s:18:\"\0*\0first_timestamp\";i:1762847013;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762847013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-11-11 07:43:33", "2025-11-11 11:13:33", "1042919", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3974", "generate_category_lookup_table_wrapper", "complete", "2025-11-11 07:43:43", "2025-11-11 11:13:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762847023;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762847023;}", "8", "1", "2025-11-11 07:44:57", "2025-11-11 11:14:57", "1042921", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3975", "woocommerce_refresh_order_count_cache", "pending", "2025-11-11 19:43:33", "2025-11-11 23:13:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762890213;s:18:\"\0*\0first_timestamp\";i:1762890213;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762890213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3976", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-11-12 07:43:33", "2025-11-12 11:13:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762933413;s:18:\"\0*\0first_timestamp\";i:1762846997;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762933413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3977", "wc_admin_daily_wrapper", "pending", "2025-11-12 07:43:33", "2025-11-12 11:13:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762933413;s:18:\"\0*\0first_timestamp\";i:1762847013;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762933413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3978", "woocommerce_cleanup_personal_data", "pending", "2025-11-12 07:44:57", "2025-11-12 11:14:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762933497;s:18:\"\0*\0first_timestamp\";i:1762847023;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762933497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("1037972", "2024-02-17 05:50:56");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "woocommerce");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "count");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("2076", "3561", "ایجاد فعالیت", "2023-02-25 07:32:12", "2023-02-25 11:02:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2077", "3561", "عملیات توسط WP Cron شروع شد", "2023-02-25 07:32:23", "2023-02-25 11:02:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2078", "3561", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-02-25 07:32:23", "2023-02-25 11:02:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2193", "3600", "ایجاد فعالیت", "2023-04-05 20:36:13", "2023-04-06 01:06:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2194", "3600", "عملیات توسط WP Cron شروع شد", "2023-04-05 20:37:12", "2023-04-06 01:07:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2195", "3600", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-04-05 20:37:13", "2023-04-06 01:07:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2322", "3643", "ایجاد فعالیت", "2023-05-14 09:08:36", "2023-05-14 13:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2323", "3643", "عملیات توسط WP Cron شروع شد", "2023-05-14 09:08:37", "2023-05-14 13:38:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2324", "3643", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-14 09:08:37", "2023-05-14 13:38:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2400", "3669", "ایجاد فعالیت", "2023-06-12 13:24:13", "2023-06-12 17:54:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2401", "3669", "عملیات توسط WP Cron شروع شد", "2023-06-12 13:24:14", "2023-06-12 17:54:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2402", "3669", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-06-12 13:24:14", "2023-06-12 17:54:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3245", "3951", "عملیات ایجاد شد", "2025-06-18 20:50:17", "2025-06-19 00:20:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3248", "3951", "عملیات با Async Request شروع شد", "2025-11-11 07:38:42", "2025-11-11 11:08:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3249", "3951", "عملیات با Async Request تکمیل شد", "2025-11-11 07:38:42", "2025-11-11 11:08:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3250", "3952", "عملیات ایجاد شد", "2025-11-11 07:38:42", "2025-11-11 11:08:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3251", "3953", "عملیات ایجاد شد", "2025-11-11 07:43:13", "2025-11-11 11:13:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("3252", "3954", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3253", "3955", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3254", "3956", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3255", "3957", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3256", "3958", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3257", "3959", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3258", "3960", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3259", "3961", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3260", "3962", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3261", "3963", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3262", "3964", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3263", "3965", "عملیات ایجاد شد", "2025-11-11 07:43:17", "2025-11-11 11:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3264", "3953", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3265", "3953", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3266", "3955", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3267", "3955", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3268", "3956", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3269", "3956", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3270", "3957", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3271", "3957", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3272", "3958", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3273", "3958", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3274", "3959", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3275", "3959", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3276", "3960", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3277", "3960", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3278", "3961", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3279", "3961", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3280", "3962", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3281", "3962", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3282", "3963", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3283", "3963", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3284", "3964", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3285", "3964", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3286", "3965", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3287", "3965", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3288", "3954", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3289", "3966", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3290", "3967", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3291", "3968", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3292", "3969", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3293", "3970", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3294", "3971", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3295", "3972", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3296", "3973", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3297", "3974", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3298", "3975", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3299", "3954", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3300", "3976", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3301", "3973", "عملیات با Async Request شروع شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3302", "3973", "عملیات با Async Request تکمیل شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3303", "3977", "عملیات ایجاد شد", "2025-11-11 07:43:33", "2025-11-11 11:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3304", "3968", "عملیات با Async Request شروع شد", "2025-11-11 07:44:57", "2025-11-11 11:14:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3305", "3968", "عملیات با Async Request تکمیل شد", "2025-11-11 07:44:57", "2025-11-11 11:14:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3306", "3978", "عملیات ایجاد شد", "2025-11-11 07:44:57", "2025-11-11 11:14:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3307", "3974", "عملیات با Async Request شروع شد", "2025-11-11 07:44:57", "2025-11-11 11:14:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3308", "3974", "عملیات با Async Request تکمیل شد", "2025-11-11 07:44:57", "2025-11-11 11:14:57");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("477", "259", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("478", "259", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("479", "287", "verified", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("65", "2262", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:24:50", "2017-12-28 10:24:50", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("66", "2262", "drfurion", "drfurion@gmail.com", "", "", "2017-12-28 10:25:26", "2017-12-28 10:25:26", "Order status changed from On hold to Completed.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("67", "2263", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:24:47", "2017-12-28 10:24:47", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("68", "2263", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:25:25", "2017-12-28 10:25:25", "Order status changed from On hold to Completed.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("69", "2264", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:24:48", "2017-12-28 10:24:48", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("70", "2264", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:25:26", "2017-12-28 10:25:26", "Order status changed from On hold to Completed.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("71", "2265", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:24:50", "2017-12-28 10:24:50", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("72", "2265", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:25:26", "2017-12-28 10:25:26", "Order status changed from On hold to Completed.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("73", "2266", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:28:26", "2017-12-28 10:28:26", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("74", "2266", "drfurion", "drfurion@gmail.com", "", "", "2017-12-28 10:29:05", "2017-12-28 10:29:05", "Order status changed from On hold to Completed.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("75", "2267", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:30:40", "2017-12-28 10:30:40", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("76", "2268", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:30:39", "2017-12-28 10:30:39", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("77", "2269", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-28 10:30:31", "2017-12-28 10:30:31", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("78", "2270", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-29 04:01:59", "2017-12-29 04:01:59", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("79", "2271", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-29 04:01:55", "2017-12-29 04:01:55", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("80", "2272", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-29 04:01:56", "2017-12-29 04:01:56", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("81", "2273", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-29 04:01:59", "2017-12-29 04:01:59", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("82", "2274", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-29 04:05:16", "2017-12-29 04:05:16", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("83", "2275", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-29 04:05:16", "2017-12-29 04:05:16", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("84", "2276", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-29 04:05:14", "2017-12-29 04:05:14", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("85", "2277", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2017-12-29 04:05:15", "2017-12-29 04:05:15", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("86", "2291", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:11:16", "2018-01-04 03:11:16", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("87", "2291", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:11:16", "2018-01-04 03:11:16", "Letter Printed Cushion Cover Cotton Throw Pillow (VS75560341230) stock reduced from 5 to 4.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("88", "2292", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:11:16", "2018-01-04 03:11:16", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("89", "2293", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:11:15", "2018-01-04 03:11:15", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("90", "2294", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:11:15", "2018-01-04 03:11:15", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("91", "2295", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:15:41", "2018-01-04 03:15:41", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("92", "2296", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:15:40", "2018-01-04 03:15:40", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("93", "2297", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:15:41", "2018-01-04 03:15:41", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("94", "2298", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:15:39", "2018-01-04 03:15:39", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("95", "2299", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:16:59", "2018-01-04 03:16:59", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("96", "2300", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:16:58", "2018-01-04 03:16:58", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("97", "2301", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-04 03:16:59", "2018-01-04 03:16:59", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("98", "2391", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-15 04:42:30", "2018-01-15 04:42:30", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("99", "2392", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-15 04:42:30", "2018-01-15 04:42:30", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("100", "2393", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-15 04:42:29", "2018-01-15 04:42:29", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("101", "2394", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-01-15 04:42:30", "2018-01-15 04:42:30", "Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("102", "2415", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-03-08 17:33:35", "2018-03-08 17:33:35", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("103", "2417", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-03-11 02:24:49", "2018-03-11 02:24:49", "Payment to be made upon delivery. Order status changed from Pending payment to Processing.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("104", "2419", "WooCommerce", "woocommerce@demo2.drfuri.com", "", "", "2018-03-16 07:10:40", "2018-03-16 07:10:40", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("219", "2798", "ووکامرس", "", "", "", "2019-08-16 04:36:09", "2019-08-16 00:06:09", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("220", "2798", "ووکامرس", "", "", "", "2019-08-16 04:36:15", "2019-08-16 00:06:15", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("221", "2798", "ووکامرس", "", "", "", "2019-08-16 06:03:58", "2019-08-16 01:33:58", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("222", "2415", "digitecadmi", "m.ghodrati93@gmail.com", "", "", "2019-08-16 15:41:26", "2019-08-16 11:11:26", "وضعیت سفارش از در انتظار بررسی به مسترد شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("259", "264", "digitecadmi", "m.ghodrati93@gmail.com", "", "172.98.93.198", "2019-10-22 16:48:43", "2019-10-22 13:18:43", "از خرید راضی هستم", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0", "review", "0", "1");
INSERT INTO `wp_comments` VALUES("287", "79", "عنوان", "farzane0998@yahoo.com", "https://co10.ir/blog/website/title.html/", "151.238.99.104", "2019-12-21 10:21:29", "2019-12-21 06:51:29", "سلام \r\nمن در زمینه تولید محتوی ، بازاریابی و تبلیغات اینترنتی فعالیت می کنم\r\nهمیشه و همیشه و همیشه \r\nیادتون باشه که یکی از عوامل مهمی که باعث میشه مطالب سایتتون زیاد بازدید بشه عنوان مطالبتونه\r\nاگه عنوان مطالبتون خوب و جذاب باشه قطعا روی لینک سایتتون بیشتر کلیک میکنن و درنتیجه اعتبار بیشتری پیش گوگل پیدا می کنین و طبعا گوگل هم شما رو به خیلیای دیگه معرفی میکنه\r\nولی فکر کردن در مورد ساختن یه عنوان خوب و موثر وقت زیادی رو از آدم میگیره و کار خیلی ساده ای نیست\r\nاما یه کتاب هست که فکر میکنم خیلی بدردتون بخوره توصیه میکنم حتما یه نگاهی بهش بندازین اینم لینکشه :\r\nhttps://co10.ir/blog/website/title.html/\r\nحتما یه نگاهی بهش بندازید ضرر نمیکنین", "0", "spam", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:7.0.1) Gecko/20100101 Firefox/7.0.1", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("317", "2903", "ووکامرس", "", "", "", "2020-04-08 13:37:06", "2020-04-08 09:07:06", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("318", "2903", "ووکامرس", "", "", "", "2020-04-08 13:37:21", "2020-04-08 09:07:21", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("319", "2903", "ووکامرس", "", "", "", "2020-04-08 14:39:46", "2020-04-08 10:09:46", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("320", "2934", "ووکامرس", "", "", "", "2020-05-14 11:46:07", "2020-05-14 07:16:07", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("321", "2934", "ووکامرس", "", "", "", "2020-05-14 14:18:15", "2020-05-14 09:48:15", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("322", "2954", "ووکامرس", "", "", "", "2020-06-08 13:56:58", "2020-06-08 09:26:58", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("323", "2954", "ووکامرس", "", "", "", "2020-06-08 13:57:07", "2020-06-08 09:27:07", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("324", "2954", "ووکامرس", "", "", "", "2020-06-08 15:19:19", "2020-06-08 10:49:19", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("325", "2967", "ووکامرس", "", "", "", "2020-07-15 17:18:54", "2020-07-15 12:48:54", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("326", "2967", "ووکامرس", "", "", "", "2020-07-15 17:19:09", "2020-07-15 12:49:09", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("327", "2967", "ووکامرس", "", "", "", "2020-07-15 17:19:10", "2020-07-15 12:49:10", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("328", "2967", "ووکامرس", "", "", "", "2020-07-15 17:19:10", "2020-07-15 12:49:10", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("329", "2967", "ووکامرس", "", "", "", "2020-07-15 17:19:11", "2020-07-15 12:49:11", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("330", "2967", "ووکامرس", "", "", "", "2020-07-15 19:16:34", "2020-07-15 14:46:34", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("331", "2973", "ووکامرس", "", "", "", "2020-08-08 20:37:45", "2020-08-08 16:07:45", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("332", "2973", "ووکامرس", "", "", "", "2020-08-08 20:37:57", "2020-08-08 16:07:57", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("333", "2973", "ووکامرس", "", "", "", "2020-08-08 21:47:07", "2020-08-08 17:17:07", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("334", "3000", "ووکامرس", "", "", "", "2020-11-27 01:50:41", "2020-11-26 22:20:41", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("335", "3000", "ووکامرس", "", "", "", "2020-11-27 03:44:13", "2020-11-27 00:14:13", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("336", "3016", "ووکامرس", "", "", "", "2020-12-05 11:20:25", "2020-12-05 07:50:25", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("337", "3016", "ووکامرس", "", "", "", "2020-12-05 13:01:34", "2020-12-05 09:31:34", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("380", "3047", "ووکامرس", "", "", "", "2021-03-04 10:38:52", "2021-03-04 07:08:52", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("381", "3047", "ووکامرس", "", "", "", "2021-03-04 10:39:06", "2021-03-04 07:09:06", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("382", "3047", "ووکامرس", "", "", "", "2021-03-04 10:39:17", "2021-03-04 07:09:17", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("383", "3047", "ووکامرس", "", "", "", "2021-03-04 11:43:48", "2021-03-04 08:13:48", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("384", "3072", "ووکامرس", "", "", "", "2021-05-09 21:07:05", "2021-05-09 16:37:05", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("385", "3072", "ووکامرس", "", "", "", "2021-05-09 21:07:12", "2021-05-09 16:37:12", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("386", "3072", "ووکامرس", "", "", "", "2021-05-09 21:09:14", "2021-05-09 16:39:14", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("387", "3072", "ووکامرس", "", "", "", "2021-05-09 21:19:34", "2021-05-09 16:49:34", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("388", "3072", "ووکامرس", "", "", "", "2021-05-09 21:24:49", "2021-05-09 16:54:49", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("389", "3072", "ووکامرس", "", "", "", "2021-05-09 22:11:39", "2021-05-09 17:41:39", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("390", "3082", "ووکامرس", "", "", "", "2021-06-30 01:49:18", "2021-06-29 21:19:18", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("391", "3082", "ووکامرس", "", "", "", "2021-06-30 01:49:43", "2021-06-29 21:19:43", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("392", "3082", "ووکامرس", "", "", "", "2021-06-30 01:50:19", "2021-06-29 21:20:19", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("393", "3082", "ووکامرس", "", "", "", "2021-06-30 03:33:43", "2021-06-29 23:03:43", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("394", "3091", "ووکامرس", "", "", "", "2021-07-26 19:03:00", "2021-07-26 14:33:00", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("395", "3096", "ووکامرس", "", "", "", "2021-08-14 23:34:59", "2021-08-14 19:04:59", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("396", "3097", "ووکامرس", "", "", "", "2021-08-16 12:16:25", "2021-08-16 07:46:25", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("397", "3097", "ووکامرس", "", "", "", "2021-08-16 12:16:32", "2021-08-16 07:46:32", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("398", "3097", "ووکامرس", "", "", "", "2021-08-16 13:59:30", "2021-08-16 09:29:30", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("399", "3118", "ووکامرس", "", "", "", "2021-09-02 15:33:12", "2021-09-02 11:03:12", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("400", "3151", "ووکامرس", "", "", "", "2022-03-11 17:44:39", "2022-03-11 14:14:39", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("401", "3153", "ووکامرس", "", "", "", "2022-05-08 11:08:37", "2022-05-08 06:38:37", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("402", "3154", "ووکامرس", "", "", "", "2022-05-08 11:08:37", "2022-05-08 06:38:37", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("403", "3164", "ووکامرس", "", "", "", "2022-09-29 10:58:55", "2022-09-29 07:28:55", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("404", "3164", "ووکامرس", "", "", "", "2022-09-29 15:38:52", "2022-09-29 12:08:52", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("48", "Martfury336Zhaket", "5168511b06c28cd96715_20251111075355", "21", "2025-11-11 07:56:22", "martfadmin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-11 07:53:55\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.1.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:48;s:4:\"Name\";s:17:\"Martfury336Zhaket\";s:4:\"Hash\";s:35:\"5168511b06c28cd96715_20251111075355\";s:8:\"NameHash\";s:53:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:63:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.7\";s:6:\"WPUser\";s:10:\"martfadmin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:101:\"/home/mimwpcom/public_html/theme/martfury/main;/home/mimwpcom/public_html/theme/martfury/soo-importer\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:65:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:70:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3423;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:29979;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-11 07:53:55\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.1.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:17:\"Martfury336Zhaket\";s:4:\"Hash\";s:35:\"5168511b06c28cd96715_20251111075355\";s:8:\"NameHash\";s:53:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:71:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:84:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:66:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:169:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/backups-dup-lite/tmp/Martfury336Zhaket_5168511b06c28cd96715_20251111075355_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:79:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-admin\";i:1;s:82:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-includes\";i:2;s:91:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:70:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall\";i:1;s:70:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall\";i:2;s:81:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content\";i:3;s:89:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/uploads\";i:4;s:89:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/plugins\";i:5;s:92:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/mu-plugins\";i:6;s:88:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:102:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://mimwp.com/theme/martfury/xinstall", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://mimwp.com/theme/martfury/xinstall", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "قالب وردپرس مارت فیوری | Martfury", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Martfury Wordpress Theme", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "mimwp2@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "Y-m-d", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:234:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:52:\"product-brand/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:47:\"product-brand/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:28:\"product-brand/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:40:\"product-brand/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:47:\"product-brand/(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&cpage=$matches[2]\";s:48:\"product-brand/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?product_brand=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"product-brand/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?product_brand=$matches[1]&wc-api=$matches[3]\";s:22:\"product-brand/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:49:\"vc_grid_item/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?vc_grid_item=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"vc_grid_item/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=2462&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:19:{i:0;s:35:\"classic-widgets/classic-widgets.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:23:\"elementor/elementor.php\";i:4;s:39:\"heartbeat-control/heartbeat-control.php\";i:5;s:27:\"js_composer/js_composer.php\";i:6;s:15:\"kirki/kirki.php\";i:7;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:8;s:35:\"martfury-addons/martfury-addons.php\";i:9;s:21:\"meta-box/meta-box.php\";i:10;s:43:\"persian-woocommerce/woocommerce-persian.php\";i:11;s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";i:12;s:23:\"revslider/revslider.php\";i:13;s:39:\"soo-demo-importer/soo-demo-importer.php\";i:14;s:65:\"variation-swatches-for-woocommerce-pro/variation-swatches-pro.php\";i:15;s:39:\"woocommerce-deals/woocommerce-deals.php\";i:16;s:27:\"woocommerce/woocommerce.php\";i:17;s:21:\"wp-reset/wp-reset.php\";i:18;s:23:\"wp-smushit/wp-smush.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:121:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/themes/martfury/inc/backend/plugins.php\";i:2;s:107:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/themes/martfury/style.css\";i:3;s:91:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/themes/martfury/functions.php\";i:4;s:87:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/themes/martfury/style.css\";i:5;s:85:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/themes/martfury/rtl.css\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "martfury", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "martfury", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "60421", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:3;a:4:{s:5:\"title\";s:13:\"دسته ها\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:3:{i:0;b:0;s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:21:\"wp-reset/wp-reset.php\";a:2:{i:0;s:8:\"WP_Reset\";i:1;s:9:\"uninstall\";}}", "yes");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "322", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "2462", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "", "yes");
INSERT INTO `wp_options` VALUES("93", "initial_db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("94", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:182:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:34:\"vc_access_rules_post_types/product\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:10:\"edit_badge\";b:1;s:10:\"read_badge\";b:1;s:12:\"delete_badge\";b:1;s:11:\"edit_badges\";b:1;s:18:\"edit_others_badges\";b:1;s:14:\"publish_badges\";b:1;s:19:\"read_private_badges\";b:1;s:13:\"delete_badges\";b:1;s:21:\"delete_private_badges\";b:1;s:23:\"delete_published_badges\";b:1;s:20:\"delete_others_badges\";b:1;s:19:\"edit_private_badges\";b:1;s:21:\"edit_published_badges\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:44:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:15:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:4:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:156:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:10:\"edit_badge\";b:1;s:10:\"read_badge\";b:1;s:12:\"delete_badge\";b:1;s:11:\"edit_badges\";b:1;s:18:\"edit_others_badges\";b:1;s:14:\"publish_badges\";b:1;s:19:\"read_private_badges\";b:1;s:13:\"delete_badges\";b:1;s:21:\"delete_private_badges\";b:1;s:23:\"delete_published_badges\";b:1;s:20:\"delete_others_badges\";b:1;s:19:\"edit_private_badges\";b:1;s:21:\"edit_published_badges\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"seller\";a:2:{s:4:\"name\";s:6:\"Vendor\";s:12:\"capabilities\";a:75:{s:4:\"read\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:12:\"delete_posts\";b:1;s:17:\"manage_categories\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:16:\"edit_shop_orders\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("95", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("96", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_search", "a:2:{i:3;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-posts", "a:2:{i:3;a:3:{s:5:\"title\";s:32:\"جدیدترین نوشته ها\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "sidebars_widgets", "a:19:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"blog-sidebar\";a:14:{i:0;s:23:\"mf_product_categories-1\";i:1;s:30:\"martfury_layered_nav_filters-1\";i:2;s:19:\"mf_product_brands-1\";i:3;s:26:\"woocommerce_price_filter-1\";i:4;s:24:\"martfury_rating_filter-1\";i:5;s:23:\"mf_product_categories-3\";i:6;s:30:\"martfury_layered_nav_filters-3\";i:7;s:19:\"mf_product_brands-3\";i:8;s:26:\"woocommerce_price_filter-3\";i:9;s:24:\"martfury_rating_filter-3\";i:10;s:23:\"martfury_layered_nav-10\";i:11;s:23:\"martfury_layered_nav-11\";i:12;s:23:\"martfury_layered_nav-12\";i:13;s:23:\"martfury_layered_nav-13\";}s:11:\"topbar-left\";a:1:{i:0;s:13:\"custom_html-1\";}s:12:\"topbar-right\";a:0:{}s:13:\"topbar-mobile\";a:0:{}s:10:\"header-bar\";a:4:{i:0;s:13:\"custom_html-2\";i:1;s:13:\"custom_html-3\";i:2;s:13:\"custom_html-4\";i:3;s:13:\"custom_html-5\";}s:12:\"post-sidebar\";a:5:{i:0;s:8:\"search-3\";i:1;s:12:\"categories-3\";i:2;s:14:\"recent-posts-3\";i:3;s:11:\"tag_cloud-2\";i:4;s:10:\"calendar-2\";}s:12:\"page-sidebar\";a:0:{}s:15:\"catalog-sidebar\";a:8:{i:0;s:23:\"mf_product_categories-2\";i:1;s:30:\"martfury_layered_nav_filters-2\";i:2;s:19:\"mf_product_brands-2\";i:3;s:26:\"woocommerce_price_filter-2\";i:4;s:24:\"martfury_rating_filter-2\";i:5;s:22:\"martfury_layered_nav-7\";i:6;s:22:\"martfury_layered_nav-8\";i:7;s:22:\"martfury_layered_nav-9\";}s:15:\"product-sidebar\";a:4:{i:0;s:13:\"custom_html-6\";i:1;s:13:\"custom_html-7\";i:2;s:13:\"custom_html-8\";i:3;s:25:\"mf_woocommerce_products-1\";}s:12:\"footer-links\";a:6:{i:0;s:10:\"nav_menu-1\";i:1;s:10:\"nav_menu-2\";i:2;s:10:\"nav_menu-3\";i:3;s:10:\"nav_menu-4\";i:4;s:10:\"nav_menu-5\";i:5;s:10:\"nav_menu-6\";}s:16:\"footer-sidebar-1\";a:2:{i:0;s:13:\"custom_html-9\";i:1;s:21:\"social-links-widget-1\";}s:16:\"footer-sidebar-2\";a:1:{i:0;s:10:\"nav_menu-7\";}s:16:\"footer-sidebar-3\";a:1:{i:0;s:10:\"nav_menu-8\";}s:16:\"footer-sidebar-4\";a:1:{i:0;s:10:\"nav_menu-9\";}s:16:\"footer-sidebar-5\";a:0:{}s:16:\"footer-sidebar-6\";a:0:{}s:26:\"consumer-electrics-sidebar\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("103", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_calendar", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_tag_cloud", "a:2:{i:2;a:3:{s:5:\"title\";s:28:\"برچسب های محبوب\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_nav_menu", "a:10:{i:1;a:2:{s:5:\"title\";s:22:\"لوازم خانگی:\";s:8:\"nav_menu\";i:188;}i:2;a:2:{s:5:\"title\";s:22:\"لوازم اداری:\";s:8:\"nav_menu\";i:189;}i:3;a:2:{s:5:\"title\";s:29:\"خانه و آشپزخانه:\";s:8:\"nav_menu\";i:190;}i:4;a:2:{s:5:\"title\";s:39:\"کامپیوتر و الکترونیک:\";s:8:\"nav_menu\";i:191;}i:5;a:2:{s:5:\"title\";s:27:\"زیبایی و سلامت:\";s:8:\"nav_menu\";i:192;}i:6;a:2:{s:5:\"title\";s:29:\"ساعت و زیورآلات:\";s:8:\"nav_menu\";i:193;}i:7;a:2:{s:5:\"title\";s:25:\"خدمات مشتریان\";s:8:\"nav_menu\";i:184;}i:8;a:2:{s:5:\"title\";s:13:\"شرکت ما\";s:8:\"nav_menu\";i:185;}i:9;a:2:{s:5:\"title\";s:24:\"برگه های دیگر\";s:8:\"nav_menu\";i:186;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_custom_html", "a:10:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:83:\" به قالب وردپرس فروشگاهی مارت فیوری خوش آمدید.\";}i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:96:\" <a href=\"http://mimwp.com/theme/martfury/xinstall/become-a-vendor/\">فروشنده شوید</a>\";}i:3;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:95:\" <a href=\"http://mimwp.com/theme/martfury/xinstall/order-tracking/\">رهگیری سفارش</a>\";}i:4;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:438:\"<div class=\"mf-currency-widget\">				\r\n	<div class=\"widget-currency\">\r\n			<span class=\"current\">ریال</span><ul><li class=\"actived\"><a href=\"#\" class=\"woocs_flag_view_item woocs_flag_view_item_current\" data-currency=\"IRR\">ریال</a></li>\r\n	<li><a href=\"#\" class=\"woocs_flag_view_item\" data-currency=\"EUR\">یورو</a></li>\r\n	<li><a href=\"#\" class=\"woocs_flag_view_item\" data-currency=\"USD\">دلار</a></li>\r\n		</ul>		</div>\r\n		</div>\";}i:5;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:807:\"<div id=\"lang_sel\">\r\n					<ul>\r\n						<li>\r\n							<a href=\"#\" class=\"lang_sel_sel icl-en\">\r\n								<img class=\"iclflag\" src=\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/08/fa.png\" alt=\"fa\" title=\"فارسی\">\r\n								فارسی\r\n							</a>\r\n						 	<ul>\r\n								<li class=\"icl-fr\">\r\n									<a href=\"#\">\r\n										<img class=\"iclflag\" src=\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/08/en.png\" alt=\"en\" title=\"English\">\r\n										English\r\n									</a>\r\n								</li>\r\n								<li class=\"icl-de\">\r\n									<a href=\"#\">\r\n										<img class=\"iclflag\" src=\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/08/de.png\" alt=\"de\" title=\"German\">\r\n										German\r\n									</a>\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\";}i:6;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:336:\"<ul class=\"mf-shipping-info\">\r\n	<li><i class=\"icon-network\"></i>ارسال به تمام نقاط</li>\r\n		<li><i class=\"icon-3d-rotate\"></i>7 روز ضمانت بازگشت</li>\r\n		<li><i class=\"icon-receipt\"></i>پشتیبانی 7 روز هفته</li>\r\n		<li><i class=\"icon-credit-card\"></i>شیوه پرداخت متنوع</li>\r\n</ul>\";}i:7;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:235:\"<i style=\"font-size: 18px\" class=\"icon-store\"></i><span style=\"color: #000; padding-left: 10px\"> فروشنده شوید!</span><a href=\"http://mimwp.com/theme/martfury/xinstall/my-account/\">همین حالا ثبت نام کنید</a>\";}i:8;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:193:\"<a href=\"http://mimwp.com/theme/martfury/xinstall/shop/apple-iphone-retina-6s-plus-64gb/\"><img src=\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2020/03/w1.png\" alt=\"mobile\"></a>\";}i:9;a:2:{s:5:\"title\";s:22:\"ارتباط با ما\";s:7:\"content\";s:239:\"همه روز پشتیبان شما هستیم\r\n<h3 style=\"margin: 10px 0;font-weight: 600\" class=\"primary-color\">\r\n	1800 97 97 69\r\n</h3>\r\nتهران، خیابان شریعتی، کوچه نسترن، پلاک 84\r\n<br>\r\ncontact@zhaket.com\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "cron", "a:37:{i:1708504784;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1708504944;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1708505795;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1708507033;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1708507190;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708508006;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1708513987;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708522276;a:1:{s:28:\"zhaket_guard_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708526712;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1708529606;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1708529689;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708532289;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708538034;a:1:{s:17:\"nikan_dokan_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708541795;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708545076;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1708560000;a:1:{s:22:\"wdev_logger_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708568100;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708581190;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708589975;a:1:{s:34:\"yith_wcwl_delete_expired_wishlists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1708677551;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1708979460;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1709101984;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1710186552;a:1:{s:25:\"smush_check_for_conflicts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1710186769;a:1:{s:30:\"generate_category_lookup_table\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1712569946;a:1:{s:40:\"woocommerce_marketplace_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1718886490;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"10ca0e036f0af712149a4089ab74aabb\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3217;}}}}i:1724834322;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"42eab1ee12dca1640c930206c71b847d\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3218;}}}}i:1733066847;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b717e08bf1d5e2268919359df4f5b412\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3219;}}}}i:1735904922;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735921707;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"ce67f34537eaec42a4c537fd155b1b12\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3220;}}}}i:1745914485;a:1:{s:19:\"wp_smush_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745921836;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"cd17c6b85a7d73c521727e0919101984\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3222;}}}}i:1745921895;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"a10d0160f9446b50ba89dde20a56ea61\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3223;}}}}i:1762854295;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"a31088ea7b213e63ae15a7a135e45620\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3224;}}}}i:1762854752;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1e3d2e9bfc63c3b3483e1b3af69bfb79\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3225;}}}}i:1763375400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("114", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1535816007;s:4:\"data\";a:18:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"blog-sidebar\";a:19:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";i:6;s:11:\"tag_cloud-1\";i:7;s:10:\"calendar-1\";i:8;s:23:\"mf_product_categories-1\";i:9;s:30:\"martfury_layered_nav_filters-1\";i:10;s:19:\"mf_product_brands-1\";i:11;s:26:\"woocommerce_price_filter-1\";i:12;s:24:\"martfury_rating_filter-1\";i:13;s:22:\"martfury_layered_nav-1\";i:14;s:22:\"martfury_layered_nav-2\";i:15;s:22:\"martfury_layered_nav-3\";i:16;s:22:\"martfury_layered_nav-4\";i:17;s:22:\"martfury_layered_nav-5\";i:18;s:22:\"martfury_layered_nav-6\";}s:11:\"topbar-left\";a:1:{i:0;s:13:\"custom_html-1\";}s:12:\"topbar-right\";a:0:{}s:13:\"topbar-mobile\";a:0:{}s:10:\"header-bar\";a:4:{i:0;s:13:\"custom_html-2\";i:1;s:13:\"custom_html-3\";i:2;s:13:\"custom_html-4\";i:3;s:13:\"custom_html-5\";}s:12:\"post-sidebar\";a:5:{i:0;s:8:\"search-3\";i:1;s:12:\"categories-3\";i:2;s:14:\"recent-posts-3\";i:3;s:11:\"tag_cloud-2\";i:4;s:10:\"calendar-2\";}s:12:\"page-sidebar\";a:0:{}s:15:\"catalog-sidebar\";a:8:{i:0;s:23:\"mf_product_categories-2\";i:1;s:30:\"martfury_layered_nav_filters-2\";i:2;s:19:\"mf_product_brands-2\";i:3;s:26:\"woocommerce_price_filter-2\";i:4;s:24:\"martfury_rating_filter-2\";i:5;s:22:\"martfury_layered_nav-7\";i:6;s:22:\"martfury_layered_nav-8\";i:7;s:22:\"martfury_layered_nav-9\";}s:15:\"product-sidebar\";a:4:{i:0;s:13:\"custom_html-6\";i:1;s:13:\"custom_html-7\";i:2;s:13:\"custom_html-8\";i:3;s:25:\"mf_woocommerce_products-1\";}s:12:\"footer-links\";a:6:{i:0;s:10:\"nav_menu-1\";i:1;s:10:\"nav_menu-2\";i:2;s:10:\"nav_menu-3\";i:3;s:10:\"nav_menu-4\";i:4;s:10:\"nav_menu-5\";i:5;s:10:\"nav_menu-6\";}s:16:\"footer-sidebar-1\";a:2:{i:0;s:13:\"custom_html-9\";i:1;s:21:\"social-links-widget-1\";}s:16:\"footer-sidebar-2\";a:1:{i:0;s:10:\"nav_menu-7\";}s:16:\"footer-sidebar-3\";a:1:{i:0;s:10:\"nav_menu-8\";}s:16:\"footer-sidebar-4\";a:1:{i:0;s:10:\"nav_menu-9\";}s:16:\"footer-sidebar-5\";a:0:{}s:16:\"footer-sidebar-6\";a:0:{}s:26:\"consumer-electrics-sidebar\";a:9:{i:0;s:23:\"mf_product_categories-3\";i:1;s:30:\"martfury_layered_nav_filters-3\";i:2;s:19:\"mf_product_brands-3\";i:3;s:26:\"woocommerce_price_filter-3\";i:4;s:24:\"martfury_rating_filter-3\";i:5;s:23:\"martfury_layered_nav-10\";i:6;s:23:\"martfury_layered_nav-11\";i:7;s:23:\"martfury_layered_nav-12\";i:8;s:23:\"martfury_layered_nav-13\";}}}}", "no");
INSERT INTO `wp_options` VALUES("117", "current_theme", "Martfury", "yes");
INSERT INTO `wp_options` VALUES("118", "theme_mods_martfury", "a:123:{s:18:\"custom_css_post_id\";i:2720;i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:182;s:15:\"shop_department\";i:183;}s:17:\"catalog_banners_1\";a:0:{}s:27:\"catalog_products_carousel_1\";a:0:{}s:27:\"catalog_products_carousel_2\";a:0:{}s:17:\"catalog_banners_3\";a:0:{}s:27:\"catalog_products_carousel_3\";a:0:{}s:23:\"page_header_blog_slider\";a:0:{}s:16:\"footer_info_list\";a:0:{}s:21:\"footer_payment_images\";a:4:{i:0;a:3:{s:5:\"image\";s:76:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2017/12/p6-3.jpg\";s:3:\"alt\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:1;a:3:{s:5:\"image\";s:76:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2017/12/p5-3.jpg\";s:3:\"alt\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:2;a:3:{s:5:\"image\";s:76:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2017/12/p3-3.jpg\";s:3:\"alt\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:3;a:3:{s:5:\"image\";s:76:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2017/12/p4-3.jpg\";s:3:\"alt\";s:0:\"\";s:4:\"link\";s:0:\"\";}}s:32:\"footer_recently_viewed_link_text\";s:19:\"مشاهده همه\";s:31:\"footer_recently_viewed_link_url\";s:60:\"http://mimwp.com/theme/martfury/xinstall/your-recent-viewed/\";s:24:\"department_open_homepage\";s:4:\"open\";s:27:\"custom_product_cat_sidebars\";a:0:{}s:16:\"footer_copyright\";s:101:\"© تمامی حقوق برای مارت فیوری محفوظ است.خرید از سایت ژاکت\";s:19:\"footer_payment_text\";s:44:\"درگاه های پرداخت ایمن ما\";s:8:\"lazyload\";b:1;s:11:\"back_to_top\";b:1;s:17:\"footer_newsletter\";b:1;s:22:\"footer_newsletter_text\";s:125:\"<h3>خبرنامه</h3>\nاز جشنواره ها و تخفیف های ما سریع تر از دیگران مطلع شوید.\";s:22:\"footer_newsletter_form\";s:21:\"[mc4wp_form id=\"436\"]\";s:21:\"product_upsells_title\";s:121:\"خریدارنی که این محصول را خریده اند از محصولات زیر نیز خرید کرده اند\";s:15:\"instagram_token\";s:51:\"4864338144.ba4c844.2a0a78824f95463f81249d95ac872404\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1625329682;s:4:\"data\";a:19:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"blog-sidebar\";a:5:{i:0;s:23:\"mf_product_categories-1\";i:1;s:30:\"martfury_layered_nav_filters-1\";i:2;s:19:\"mf_product_brands-1\";i:3;s:26:\"woocommerce_price_filter-1\";i:4;s:24:\"martfury_rating_filter-1\";}s:11:\"topbar-left\";a:1:{i:0;s:13:\"custom_html-1\";}s:12:\"topbar-right\";a:0:{}s:13:\"topbar-mobile\";a:0:{}s:10:\"header-bar\";a:4:{i:0;s:13:\"custom_html-2\";i:1;s:13:\"custom_html-3\";i:2;s:13:\"custom_html-4\";i:3;s:13:\"custom_html-5\";}s:12:\"post-sidebar\";a:5:{i:0;s:8:\"search-3\";i:1;s:12:\"categories-3\";i:2;s:14:\"recent-posts-3\";i:3;s:11:\"tag_cloud-2\";i:4;s:10:\"calendar-2\";}s:12:\"page-sidebar\";a:0:{}s:15:\"catalog-sidebar\";a:8:{i:0;s:23:\"mf_product_categories-2\";i:1;s:30:\"martfury_layered_nav_filters-2\";i:2;s:19:\"mf_product_brands-2\";i:3;s:26:\"woocommerce_price_filter-2\";i:4;s:24:\"martfury_rating_filter-2\";i:5;s:22:\"martfury_layered_nav-7\";i:6;s:22:\"martfury_layered_nav-8\";i:7;s:22:\"martfury_layered_nav-9\";}s:15:\"product-sidebar\";a:4:{i:0;s:13:\"custom_html-6\";i:1;s:13:\"custom_html-7\";i:2;s:13:\"custom_html-8\";i:3;s:25:\"mf_woocommerce_products-1\";}s:12:\"footer-links\";a:6:{i:0;s:10:\"nav_menu-1\";i:1;s:10:\"nav_menu-2\";i:2;s:10:\"nav_menu-3\";i:3;s:10:\"nav_menu-4\";i:4;s:10:\"nav_menu-5\";i:5;s:10:\"nav_menu-6\";}s:16:\"footer-sidebar-1\";a:2:{i:0;s:13:\"custom_html-9\";i:1;s:21:\"social-links-widget-1\";}s:16:\"footer-sidebar-2\";a:1:{i:0;s:10:\"nav_menu-7\";}s:16:\"footer-sidebar-3\";a:1:{i:0;s:10:\"nav_menu-8\";}s:16:\"footer-sidebar-4\";a:1:{i:0;s:10:\"nav_menu-9\";}s:16:\"footer-sidebar-5\";a:0:{}s:16:\"footer-sidebar-6\";a:0:{}s:26:\"consumer-electrics-sidebar\";a:9:{i:0;s:23:\"mf_product_categories-3\";i:1;s:30:\"martfury_layered_nav_filters-3\";i:2;s:19:\"mf_product_brands-3\";i:3;s:26:\"woocommerce_price_filter-3\";i:4;s:24:\"martfury_rating_filter-3\";i:5;s:23:\"martfury_layered_nav-10\";i:6;s:23:\"martfury_layered_nav-11\";i:7;s:23:\"martfury_layered_nav-12\";i:8;s:23:\"martfury_layered_nav-13\";}s:30:\"computers-technologies-sidebar\";a:0:{}}}s:13:\"header_layout\";s:1:\"3\";s:31:\"header_recently_viewed_link_url\";s:60:\"http://mimwp.com/theme/martfury/xinstall/your-recent-viewed/\";s:22:\"footer_recently_viewed\";b:0;s:4:\"logo\";s:84:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2018/09/logo_light-1.png\";s:9:\"preloader\";b:0;s:17:\"show_post_socials\";b:1;s:16:\"newsletter_popup\";b:0;s:19:\"newsletter_bg_image\";s:0:\"\";s:18:\"newsletter_content\";s:190:\"<h3>25% <strong class=\"primary-color\">تخفیف </strong>ویژه!</h3>\n<p>برای آگاهی از جشنواره ها \nو تخفیف ها در خبرنامه ما مشترک شوید.</p>\";s:15:\"newsletter_form\";s:21:\"[mc4wp_form id=\"436\"]\";s:13:\"sticky_header\";b:1;s:32:\"header_recently_viewed_link_text\";s:83:\"نمایش تمامی محصولاتی که اخیرا مشاهده کرده اید\";s:19:\"coming_soon_socials\";a:4:{i:0;a:1:{s:8:\"link_url\";s:22:\"https://instagram.com/\";}i:1;a:1:{s:8:\"link_url\";s:21:\"https://facebook.com/\";}i:2;a:1:{s:8:\"link_url\";s:20:\"https://twitter.com/\";}i:3;a:1:{s:8:\"link_url\";s:20:\"https://youtube.com/\";}}s:16:\"header_hot_words\";a:0:{}s:28:\"header_recently_viewed_title\";s:61:\"محصولاتی که اخیرا مشاهده کرده اید\";s:8:\"hot_text\";s:6:\"داغ\";s:15:\"outofstock_text\";s:14:\"ناموجود\";s:8:\"new_text\";s:8:\"جدید\";s:21:\"login_register_layout\";s:7:\"columns\";s:18:\"font_families_typo\";a:0:{}s:9:\"body_typo\";a:10:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:7:\"regular\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:3:\"1.6\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:5:\"color\";s:4:\"#666\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:18:\"footer_widget_typo\";a:8:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:3:\"700\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:9:\"font-size\";s:4:\"16px\";s:5:\"color\";s:4:\"#000\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:18:\"catalog_sidebar_10\";s:15:\"content-sidebar\";s:20:\"product_instagram_by\";s:4:\"user\";s:14:\"instagram_user\";s:1:\"@\";s:15:\"homepage_mobile\";s:3:\"522\";s:25:\"custom_header_skin_mobile\";b:0;s:29:\"custom_header_homepage_mobile\";b:0;s:22:\"topbar_bg_color_mobile\";s:7:\"#81d742\";s:24:\"topbar_text_color_mobile\";s:7:\"#c9a5a5\";s:22:\"header_bg_color_mobile\";s:7:\"#f88a8a\";s:24:\"header_text_color_mobile\";s:7:\"#dd3333\";s:29:\"search_button_bg_color_mobile\";s:7:\"#8224e3\";s:31:\"search_button_text_color_mobile\";s:7:\"#eeee22\";s:14:\"submenu_mobile\";s:4:\"icon\";s:13:\"heading1_typo\";a:11:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:3:\"700\";s:9:\"font-size\";s:4:\"36px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:3:\"0px\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:5:\"color\";s:4:\"#000\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:13:\"heading2_typo\";a:11:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:3:\"700\";s:9:\"font-size\";s:4:\"30px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:3:\"0px\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:5:\"color\";s:4:\"#000\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:13:\"heading3_typo\";a:11:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:3:\"700\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:3:\"0px\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:5:\"color\";s:4:\"#000\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:13:\"heading4_typo\";a:11:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:3:\"700\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:3:\"0px\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:5:\"color\";s:4:\"#000\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:13:\"heading5_typo\";a:11:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:3:\"700\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:3:\"0px\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:5:\"color\";s:4:\"#000\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:13:\"heading6_typo\";a:11:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:3:\"700\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:3:\"0px\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:5:\"color\";s:4:\"#000\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:9:\"menu_typo\";a:8:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:9:\"font-size\";s:4:\"14px\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:7:\"variant\";s:7:\"regular\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:14:\"mega_menu_typo\";a:9:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:7:\"regular\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:9:\"font-size\";s:4:\"14px\";s:5:\"color\";s:4:\"#000\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:13:\"sub_menu_typo\";a:9:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:7:\"regular\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:9:\"font-size\";s:4:\"14px\";s:5:\"color\";s:4:\"#000\";s:14:\"text-transform\";s:4:\"none\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:11:\"footer_typo\";a:8:{s:11:\"font-family\";s:8:\"iransans\";s:7:\"variant\";s:7:\"regular\";s:7:\"subsets\";a:1:{i:0;s:9:\"latin-ext\";}s:9:\"font-size\";s:4:\"14px\";s:5:\"color\";s:4:\"#666\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:19:\"product_page_layout\";s:1:\"1\";s:11:\"page_layout\";s:12:\"full-content\";s:17:\"product_fbt_title\";s:47:\"معمولا با هم خریده می شوند\";s:28:\"shop_department_border_color\";s:0:\"\";s:17:\"menu_bar_bg_color\";s:7:\"#c1c1c1\";s:19:\"menu_bar_text_color\";s:7:\"#2d2d2d\";s:20:\"menu_bar_hover_color\";s:7:\"#ea4242\";s:21:\"menu_bar_active_color\";s:7:\"#d41f1f\";s:21:\"menu_bar_border_color\";s:7:\"#81d742\";s:18:\"custom_header_skin\";b:0;s:20:\"sticky_header_mobile\";b:1;s:22:\"catalog_featured_icons\";a:4:{i:0;s:4:\"cart\";i:1;s:5:\"qview\";i:2;s:8:\"wishlist\";i:3;s:7:\"compare\";}s:29:\"catalog_featured_icons_mobile\";b:0;s:20:\"added_to_cart_notice\";b:1;s:21:\"cart_notice_auto_hide\";s:1:\"3\";s:25:\"wishlist_notice_auto_hide\";s:1:\"3\";s:24:\"added_to_wishlist_notice\";b:1;s:11:\"shop_layout\";s:2:\"10\";s:18:\"menu_extras_mobile\";a:3:{i:0;s:6:\"search\";i:1;s:4:\"cart\";i:2;s:7:\"account\";}s:17:\"product_instagram\";b:0;s:20:\"product_social_icons\";a:6:{i:0;s:7:\"twitter\";i:1;s:8:\"facebook\";i:2;s:6:\"google\";i:3;s:9:\"pinterest\";i:4;s:8:\"linkedin\";i:5;s:8:\"whatsapp\";}s:15:\"header_bg_color\";s:7:\"#81d742\";s:17:\"header_text_color\";s:7:\"#1e73be\";s:18:\"header_hover_color\";s:7:\"#dd3333\";s:22:\"search_button_bg_color\";s:7:\"#8224e3\";s:24:\"search_button_text_color\";s:7:\"#81d742\";s:26:\"sticky_product_info_mobile\";b:0;s:24:\"inner_page_header_layout\";s:2:\"v2\";s:32:\"product_add_to_cart_fixed_mobile\";b:1;s:11:\"menu_extras\";a:6:{i:0;s:6:\"search\";i:1;s:7:\"compare\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";i:5;s:10:\"department\";}s:15:\"product_buy_now\";b:0;s:9:\"promotion\";b:0;s:18:\"promotion_bg_color\";s:0:\"\";s:17:\"promotion_content\";s:0:\"\";s:21:\"promotion_button_text\";s:0:\"\";s:21:\"enable_mobile_version\";b:1;s:25:\"navigation_cart_behaviour\";s:5:\"panel\";s:19:\"catalog_ajax_filter\";b:1;s:18:\"promotion_bg_image\";s:0:\"\";s:23:\"promotion_bg_horizontal\";s:6:\"center\";s:21:\"promotion_bg_vertical\";s:3:\"top\";s:20:\"promotion_bg_repeats\";s:8:\"repeat-y\";s:24:\"promotion_bg_attachments\";s:5:\"fixed\";s:17:\"promotion_bg_size\";s:7:\"contain\";s:15:\"promotion_style\";s:1:\"1\";s:21:\"promotion_button_link\";s:0:\"\";s:20:\"product_buy_now_link\";s:46:\"http://mimwp.com/theme/martfury/xinstall/cart/\";s:27:\"products_cat_level_1_layout\";s:2:\"10\";s:15:\"product_related\";b:1;s:18:\"sticky_header_logo\";b:0;s:25:\"catalog_featured_banner_2\";b:1;s:18:\"product_loop_hover\";s:1:\"2\";s:13:\"quantity_ajax\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("120", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.3\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";d:1535828607;s:7:\"version\";s:5:\"5.0.3\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("123", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("124", "rs_tables_created", "1", "yes");
INSERT INTO `wp_options` VALUES("125", "revslider_table_version", "1.0.12", "yes");
INSERT INTO `wp_options` VALUES("126", "revslider-global-settings", "{\"version\":\"6.2.0\",\"permission\":\"admin\",\"include\":false,\"includeids\":\"\",\"script\":{\"footer\":false,\"defer\":false,\"full\":false},\"fonturl\":\"\",\"size\":{\"desktop\":1240,\"notebook\":1024,\"tablet\":768,\"mobile\":480}}", "yes");
INSERT INTO `wp_options` VALUES("129", "woocommerce_store_address", "", "yes");
INSERT INTO `wp_options` VALUES("130", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("131", "woocommerce_store_city", "", "yes");
INSERT INTO `wp_options` VALUES("132", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("133", "woocommerce_store_postcode", "", "yes");
INSERT INTO `wp_options` VALUES("134", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("135", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("136", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("137", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("138", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("139", "woocommerce_default_customer_address", "geolocation", "yes");
INSERT INTO `wp_options` VALUES("140", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("141", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("142", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("143", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("144", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("145", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("146", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("147", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("148", "woocommerce_shop_page_id", "2437", "yes");
INSERT INTO `wp_options` VALUES("149", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("150", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("151", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("152", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("153", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("154", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("155", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("156", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("157", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("158", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("159", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("160", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("161", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("162", "woocommerce_stock_email_recipient", "m.ghodrati93@gmail.com", "no");
INSERT INTO `wp_options` VALUES("163", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("164", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("165", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("166", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("167", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("168", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("169", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("170", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("171", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("172", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("173", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("175", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("176", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("177", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("178", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("179", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("180", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("181", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("182", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("183", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("184", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("185", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("186", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("187", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("188", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("189", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("190", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("191", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما فقط برای پردازش سفارش استفاده خواهد شد.[privacy_policy].", "yes");
INSERT INTO `wp_options` VALUES("192", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما فقط برای پردازش سفارش استفاده خواهد شد. [privacy_policy].", "yes");
INSERT INTO `wp_options` VALUES("193", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("194", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("195", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("196", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("197", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("198", "woocommerce_email_from_name", "قالب وردپرس مارت فیوری | Martfury Wordpress Theme", "no");
INSERT INTO `wp_options` VALUES("199", "woocommerce_email_from_address", "m.ghodrati93@gmail.com", "no");
INSERT INTO `wp_options` VALUES("200", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("201", "woocommerce_email_footer_text", "{site_title}", "no");
INSERT INTO `wp_options` VALUES("202", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("203", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("204", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("205", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("206", "woocommerce_cart_page_id", "2655", "yes");
INSERT INTO `wp_options` VALUES("207", "woocommerce_checkout_page_id", "6", "yes");
INSERT INTO `wp_options` VALUES("208", "woocommerce_myaccount_page_id", "7", "yes");
INSERT INTO `wp_options` VALUES("209", "woocommerce_terms_page_id", "451", "yes");
INSERT INTO `wp_options` VALUES("210", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("211", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("212", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("213", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("214", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("215", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("216", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("217", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("218", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("219", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("220", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("222", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("224", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("225", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("226", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("227", "woocommerce_thumbnail_image_width", "480", "yes");
INSERT INTO `wp_options` VALUES("228", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("229", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("231", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("236", "yit_recently_activated", "a:3:{i:0;s:43:\"yith-woocommerce-badges-management/init.php\";i:1;s:42:\"yith-woocommerce-checkout-manager/init.php\";i:2;s:37:\"yith-woocommerce-ajax-search/init.php\";}", "yes");
INSERT INTO `wp_options` VALUES("238", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("239", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("240", "revslider_server_refresh", "1761693440", "yes");
INSERT INTO `wp_options` VALUES("241", "revslider-update-check-short", "1762846720", "yes");
INSERT INTO `wp_options` VALUES("242", "revslider-templates-check", "1762846721", "yes");
INSERT INTO `wp_options` VALUES("246", "revslider-library-check", "1762846721", "yes");
INSERT INTO `wp_options` VALUES("247", "rs-library", "a:3:{s:4:\"hash\";s:32:\"324e6ba47fb68dfb7f1bd5b0b203bdc5\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:120;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:121;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:122;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:123;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:124;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:125;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:126;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:127;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:128;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:129;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:130;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:131;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:132;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:133;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:134;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:135;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:136;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:137;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:138;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:139;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:140;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:141;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:142;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:143;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:144;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:145;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9826;s:4:\"orig\";i:377551;}}i:146;a:13:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13862;s:4:\"orig\";i:454028;}}i:147;a:13:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18636;s:4:\"orig\";i:785357;}}i:148;a:13:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17409;s:4:\"orig\";i:996686;}}i:149;a:13:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12053;s:4:\"orig\";i:916937;}}i:150;a:13:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3887;s:4:\"orig\";i:154603;}}i:151;a:13:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16305;s:4:\"orig\";i:483681;}}i:152;a:13:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12105;s:4:\"orig\";i:314746;}}i:153;a:13:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18137;s:4:\"orig\";i:371805;}}i:154;a:13:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11586;s:4:\"orig\";i:354781;}}i:155;a:13:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9848;s:4:\"orig\";i:195359;}}i:156;a:13:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10089;s:4:\"orig\";i:218538;}}i:157;a:13:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16403;s:4:\"orig\";i:547096;}}i:158;a:13:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19188;s:4:\"orig\";i:371592;}}i:159;a:13:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15157;s:4:\"orig\";i:658386;}}i:160;a:13:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24833;s:4:\"orig\";i:942816;}}i:161;a:13:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:345362;}}i:162;a:13:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15665;s:4:\"orig\";i:407640;}}i:163;a:13:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19443;s:4:\"orig\";i:844506;}}i:164;a:13:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15564;s:4:\"orig\";i:573777;}}i:165;a:13:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13337;s:4:\"orig\";i:762091;}}i:166;a:13:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16746;s:4:\"orig\";i:365391;}}i:167;a:13:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12699;s:4:\"orig\";i:427166;}}i:168;a:13:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4748;s:4:\"orig\";i:238506;}}i:169;a:13:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19043;s:4:\"orig\";i:595277;}}i:170;a:13:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11863;s:4:\"orig\";i:228649;}}i:171;a:13:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10878;s:4:\"orig\";i:313238;}}i:172;a:13:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7596;s:4:\"orig\";i:193734;}}i:173;a:13:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9305;s:4:\"orig\";i:223763;}}i:174;a:13:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23289;s:4:\"orig\";i:699269;}}i:175;a:13:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16638;s:4:\"orig\";i:415507;}}i:176;a:13:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11706;s:4:\"orig\";i:310875;}}i:177;a:13:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18880;s:4:\"orig\";i:531273;}}i:178;a:13:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20175;s:4:\"orig\";i:554813;}}i:179;a:13:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6818;s:4:\"orig\";i:122809;}}i:180;a:13:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8776;s:4:\"orig\";i:190452;}}i:181;a:13:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52127;s:4:\"orig\";i:352596;}}i:182;a:13:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8878;s:4:\"orig\";i:183427;}}i:183;a:13:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:368977;}}i:184;a:13:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15080;s:4:\"orig\";i:707157;}}i:185;a:13:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5473;s:4:\"orig\";i:288675;}}i:186;a:13:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19262;s:4:\"orig\";i:513524;}}i:187;a:13:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9810;s:4:\"orig\";i:317981;}}i:188;a:13:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15773;s:4:\"orig\";i:519696;}}i:189;a:13:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32647;s:4:\"orig\";i:350074;}}i:190;a:13:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14643;s:4:\"orig\";i:314424;}}i:191;a:13:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19823;s:4:\"orig\";i:511473;}}i:192;a:13:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37262;s:4:\"orig\";i:1590451;}}i:193;a:13:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13647;s:4:\"orig\";i:408622;}}i:194;a:13:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10075;s:4:\"orig\";i:216586;}}i:195;a:13:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10969;s:4:\"orig\";i:405945;}}i:196;a:13:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9975;s:4:\"orig\";i:257177;}}i:197;a:13:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9598;s:4:\"orig\";i:300066;}}i:198;a:13:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7588;s:4:\"orig\";i:184359;}}i:199;a:13:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9507;s:4:\"orig\";i:290246;}}i:200;a:13:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14875;s:4:\"orig\";i:324145;}}i:201;a:13:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18138;s:4:\"orig\";i:736181;}}i:202;a:13:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10664;s:4:\"orig\";i:411404;}}i:203;a:13:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11609;s:4:\"orig\";i:273103;}}i:204;a:13:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16837;s:4:\"orig\";i:456937;}}i:205;a:13:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13774;s:4:\"orig\";i:385875;}}i:206;a:13:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12285;s:4:\"orig\";i:546492;}}i:207;a:13:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12631;s:4:\"orig\";i:540206;}}i:208;a:13:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9964;s:4:\"orig\";i:309994;}}i:209;a:13:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13683;s:4:\"orig\";i:369417;}}i:210;a:13:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15941;s:4:\"orig\";i:475914;}}i:211;a:13:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17854;s:4:\"orig\";i:371480;}}i:212;a:13:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17441;s:4:\"orig\";i:507045;}}i:213;a:13:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32396;s:4:\"orig\";i:750503;}}i:214;a:13:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25355;s:4:\"orig\";i:517171;}}i:215;a:13:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30467;s:4:\"orig\";i:1076108;}}i:216;a:13:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17629;s:4:\"orig\";i:804567;}}i:217;a:13:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12952;s:4:\"orig\";i:489898;}}i:218;a:13:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11065;s:4:\"orig\";i:384178;}}i:219;a:13:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6262;s:4:\"orig\";i:198960;}}i:220;a:13:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16353;s:4:\"orig\";i:245636;}}i:221;a:13:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6048;s:4:\"orig\";i:133907;}}i:222;a:13:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15187;s:4:\"orig\";i:450326;}}i:223;a:13:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17977;s:4:\"orig\";i:582673;}}i:224;a:13:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20171;s:4:\"orig\";i:617346;}}i:225;a:13:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14937;s:4:\"orig\";i:227355;}}i:226;a:13:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9789;s:4:\"orig\";i:321713;}}i:227;a:13:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18374;s:4:\"orig\";i:642218;}}i:228;a:13:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17332;s:4:\"orig\";i:791283;}}i:229;a:13:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28854;s:4:\"orig\";i:1228379;}}i:230;a:13:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7529;s:4:\"orig\";i:263779;}}i:231;a:13:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18101;s:4:\"orig\";i:617407;}}i:232;a:13:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18049;s:4:\"orig\";i:757700;}}i:233;a:13:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18133;s:4:\"orig\";i:633849;}}i:234;a:13:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24430;s:4:\"orig\";i:954378;}}i:235;a:13:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16738;s:4:\"orig\";i:664032;}}i:236;a:13:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17594;s:4:\"orig\";i:503413;}}i:237;a:13:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15558;s:4:\"orig\";i:508616;}}i:238;a:13:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14665;s:4:\"orig\";i:429256;}}i:239;a:13:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20433;s:4:\"orig\";i:1162968;}}i:240;a:13:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10872;s:4:\"orig\";i:289488;}}i:241;a:13:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17988;s:4:\"orig\";i:602577;}}i:242;a:13:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9794;s:4:\"orig\";i:352053;}}i:243;a:13:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:370551;}}i:244;a:13:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10397;s:4:\"orig\";i:280660;}}i:245;a:13:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26832;s:4:\"orig\";i:677097;}}i:246;a:13:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13591;s:4:\"orig\";i:846550;}}i:247;a:13:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12138;s:4:\"orig\";i:511326;}}i:248;a:13:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14005;s:4:\"orig\";i:392648;}}i:249;a:13:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11612;s:4:\"orig\";i:688650;}}i:250;a:13:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28096;s:4:\"orig\";i:766943;}}i:251;a:13:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17419;s:4:\"orig\";i:759716;}}i:252;a:13:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10910;s:4:\"orig\";i:191059;}}i:253;a:13:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24825;s:4:\"orig\";i:706226;}}i:254;a:13:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11091;s:4:\"orig\";i:300143;}}i:255;a:13:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15004;s:4:\"orig\";i:475888;}}i:256;a:13:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13155;s:4:\"orig\";i:683645;}}i:257;a:13:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15305;s:4:\"orig\";i:655207;}}i:258;a:13:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17740;s:4:\"orig\";i:745183;}}i:259;a:13:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17442;s:4:\"orig\";i:641873;}}i:260;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:261;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:262;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:263;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:264;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:265;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:266;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:267;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:268;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:269;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:270;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:271;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:272;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:273;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:274;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:275;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:276;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:277;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:278;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:279;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:280;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:281;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:282;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:283;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:284;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:285;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:286;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:287;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:288;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:289;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:290;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:291;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:292;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:293;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:294;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:295;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:296;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:297;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:298;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:299;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:300;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:301;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:302;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:303;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:304;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:305;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:306;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:307;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:308;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:309;a:14:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25803;s:11:\"video_thumb\";i:2753823;s:5:\"cover\";i:127867;s:4:\"orig\";i:5991847;}}i:310;a:14:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19154;s:11:\"video_thumb\";i:4783500;s:5:\"cover\";i:97843;s:4:\"orig\";i:12408832;}}i:311;a:14:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28284;s:11:\"video_thumb\";i:2150510;s:5:\"cover\";i:124176;s:4:\"orig\";i:7726114;}}i:312;a:14:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23354;s:11:\"video_thumb\";i:3635377;s:5:\"cover\";i:106283;s:4:\"orig\";i:12688465;}}i:313;a:14:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29858;s:11:\"video_thumb\";i:9614915;s:5:\"cover\";i:153660;s:4:\"orig\";i:13424151;}}i:314;a:14:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19155;s:11:\"video_thumb\";i:2361089;s:5:\"cover\";i:103588;s:4:\"orig\";i:14717688;}}i:315;a:14:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:11719;s:11:\"video_thumb\";i:4841259;s:5:\"cover\";i:40309;s:4:\"orig\";i:11715637;}}i:316;a:14:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:56469;s:11:\"video_thumb\";i:5107558;s:5:\"cover\";i:273635;s:4:\"orig\";i:13833056;}}i:317;a:14:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:30439;s:11:\"video_thumb\";i:3864288;s:5:\"cover\";i:133345;s:4:\"orig\";i:13159814;}}i:318;a:14:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31267;s:11:\"video_thumb\";i:2732735;s:5:\"cover\";i:173636;s:4:\"orig\";i:5536475;}}i:319;a:14:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29090;s:11:\"video_thumb\";i:4861363;s:5:\"cover\";i:188894;s:4:\"orig\";i:13731609;}}i:320;a:14:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31123;s:11:\"video_thumb\";i:1386258;s:5:\"cover\";i:219740;s:4:\"orig\";i:6479275;}}i:321;a:14:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21091;s:11:\"video_thumb\";i:11134706;s:5:\"cover\";i:115059;s:4:\"orig\";i:12313637;}}i:322;a:14:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19624;s:11:\"video_thumb\";i:3913179;s:5:\"cover\";i:118864;s:4:\"orig\";i:14700830;}}i:323;a:14:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:45123;s:11:\"video_thumb\";i:2547876;s:5:\"cover\";i:268587;s:4:\"orig\";i:8823724;}}i:324;a:14:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:33867;s:11:\"video_thumb\";i:5972511;s:5:\"cover\";i:172632;s:4:\"orig\";i:13869858;}}i:325;a:14:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16185;s:11:\"video_thumb\";i:4097952;s:5:\"cover\";i:160912;s:4:\"orig\";i:12307362;}}i:326;a:14:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9324;s:11:\"video_thumb\";i:1843046;s:5:\"cover\";i:94919;s:4:\"orig\";i:4938526;}}i:327;a:14:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:13455;s:11:\"video_thumb\";i:5101194;s:5:\"cover\";i:66493;s:4:\"orig\";i:11852447;}}i:328;a:14:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20003;s:11:\"video_thumb\";i:1696754;s:5:\"cover\";i:103202;s:4:\"orig\";i:12515577;}}i:329;a:14:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19377;s:11:\"video_thumb\";i:3861934;s:5:\"cover\";i:101592;s:4:\"orig\";i:13370749;}}i:330;a:14:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31120;s:11:\"video_thumb\";i:2732488;s:5:\"cover\";i:190596;s:4:\"orig\";i:13625169;}}i:331;a:14:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17475;s:11:\"video_thumb\";i:1248121;s:5:\"cover\";i:203284;s:4:\"orig\";i:4921567;}}i:332;a:14:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26132;s:11:\"video_thumb\";i:5777142;s:5:\"cover\";i:138198;s:4:\"orig\";i:12817212;}}i:333;a:14:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40668;s:11:\"video_thumb\";i:3711074;s:5:\"cover\";i:243587;s:4:\"orig\";i:12354374;}}i:334;a:14:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:41275;s:11:\"video_thumb\";i:2631988;s:5:\"cover\";i:330226;s:4:\"orig\";i:8304831;}}i:335;a:14:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:54209;s:11:\"video_thumb\";i:4596191;s:5:\"cover\";i:335804;s:4:\"orig\";i:13306988;}}i:336;a:14:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:75484;s:11:\"video_thumb\";i:3134686;s:5:\"cover\";i:461854;s:4:\"orig\";i:20337064;}}i:337;a:14:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25915;s:11:\"video_thumb\";i:2352326;s:5:\"cover\";i:136931;s:4:\"orig\";i:12104254;}}i:338;a:14:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40965;s:11:\"video_thumb\";i:8637814;s:5:\"cover\";i:195812;s:4:\"orig\";i:13878956;}}i:339;a:14:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19037;s:11:\"video_thumb\";i:3065043;s:5:\"cover\";i:65493;s:4:\"orig\";i:12935967;}}i:340;a:14:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:24344;s:11:\"video_thumb\";i:1911296;s:5:\"cover\";i:192540;s:4:\"orig\";i:4631422;}}i:341;a:14:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23517;s:11:\"video_thumb\";i:4899641;s:5:\"cover\";i:86737;s:4:\"orig\";i:12281833;}}i:342;a:14:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31844;s:11:\"video_thumb\";i:4412295;s:5:\"cover\";i:154844;s:4:\"orig\";i:10753079;}}i:343;a:14:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14905;s:11:\"video_thumb\";i:3394055;s:5:\"cover\";i:73276;s:4:\"orig\";i:11722124;}}i:344;a:14:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:48591;s:11:\"video_thumb\";i:5268295;s:5:\"cover\";i:211021;s:4:\"orig\";i:11990742;}}i:345;a:14:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27863;s:11:\"video_thumb\";i:2674570;s:5:\"cover\";i:119321;s:4:\"orig\";i:11602755;}}i:346;a:14:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27505;s:11:\"video_thumb\";i:3025283;s:5:\"cover\";i:144357;s:4:\"orig\";i:13176990;}}i:347;a:14:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22543;s:11:\"video_thumb\";i:1327376;s:5:\"cover\";i:111224;s:4:\"orig\";i:4727340;}}i:348;a:14:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:34936;s:11:\"video_thumb\";i:3198076;s:5:\"cover\";i:160493;s:4:\"orig\";i:12804022;}}i:349;a:14:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28883;s:11:\"video_thumb\";i:4750283;s:5:\"cover\";i:153687;s:4:\"orig\";i:13054569;}}i:350;a:14:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:53693;s:11:\"video_thumb\";i:9780815;s:5:\"cover\";i:341419;s:4:\"orig\";i:13738077;}}i:351;a:14:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9494;s:11:\"video_thumb\";i:942533;s:5:\"cover\";i:52833;s:4:\"orig\";i:6629299;}}i:352;a:14:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22781;s:11:\"video_thumb\";i:2415073;s:5:\"cover\";i:126450;s:4:\"orig\";i:11684367;}}i:353;a:14:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22296;s:11:\"video_thumb\";i:1465206;s:5:\"cover\";i:73047;s:4:\"orig\";i:4008355;}}i:354;a:14:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19851;s:11:\"video_thumb\";i:3023599;s:5:\"cover\";i:25426;s:4:\"orig\";i:12847145;}}i:355;a:14:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:18002;s:11:\"video_thumb\";i:1791449;s:5:\"cover\";i:101725;s:4:\"orig\";i:13746552;}}i:356;a:14:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:8176;s:11:\"video_thumb\";i:4255586;s:5:\"cover\";i:75455;s:4:\"orig\";i:10948491;}}i:357;a:14:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:46567;s:11:\"video_thumb\";i:3789289;s:5:\"cover\";i:25425;s:4:\"orig\";i:15943336;}}i:358;a:14:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26927;s:11:\"video_thumb\";i:2605391;s:5:\"cover\";i:149830;s:4:\"orig\";i:13232415;}}i:359;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:360;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:361;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:362;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:363;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:364;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:365;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:366;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:367;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:368;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}i:369;a:14:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11778;s:5:\"video\";i:126230;}}i:370;a:14:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9342;s:5:\"video\";i:258890;}}i:371;a:14:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22925;s:5:\"video\";i:337622;}}i:372;a:14:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13590;s:5:\"video\";i:143116;}}i:373;a:14:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12603;s:5:\"video\";i:267056;}}i:374;a:14:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11225;s:5:\"video\";i:104722;}}i:375;a:14:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16221;s:5:\"video\";i:183244;}}i:376;a:14:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15072;s:5:\"video\";i:90577;}}i:377;a:14:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11741;s:5:\"video\";i:96061;}}i:378;a:14:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15979;s:5:\"video\";i:136040;}}i:379;a:14:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13637;s:5:\"video\";i:98053;}}i:380;a:14:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14892;s:5:\"video\";i:125449;}}i:381;a:14:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16568;s:5:\"video\";i:127133;}}i:382;a:14:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19099;s:5:\"video\";i:202784;}}i:383;a:14:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21756;s:5:\"video\";i:295899;}}i:384;a:14:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20783;s:5:\"video\";i:279347;}}i:385;a:14:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17862;s:5:\"video\";i:111140;}}i:386;a:14:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10799;s:5:\"video\";i:49269;}}i:387;a:14:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14442;s:5:\"video\";i:143950;}}i:388;a:14:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16819;s:5:\"video\";i:142842;}}i:389;a:14:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12575;s:5:\"video\";i:106541;}}i:390;a:14:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12931;s:5:\"video\";i:84922;}}i:391;a:14:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18105;s:5:\"video\";i:184683;}}i:392;a:14:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13440;s:5:\"video\";i:104866;}}i:393;a:14:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17477;s:5:\"video\";i:147765;}}i:394;a:14:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36069;s:5:\"video\";i:104559;}}i:395;a:14:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20095;s:5:\"video\";i:60429;}}i:396;a:14:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:38056;s:5:\"video\";i:45726;}}i:397;a:14:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:54736;s:5:\"video\";i:26685;}}i:398;a:14:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34717;s:5:\"video\";i:16283;}}i:399;a:14:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25700;s:5:\"video\";i:38602;}}i:400;a:14:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:55897;s:5:\"video\";i:21279;}}i:401;a:14:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39579;s:5:\"video\";i:22677;}}i:402;a:14:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41903;s:5:\"video\";i:65515;}}i:403;a:14:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25902;s:5:\"video\";i:15295;}}i:404;a:14:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40029;s:5:\"video\";i:28970;}}i:405;a:14:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21834;s:5:\"video\";i:21250;}}i:406;a:14:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36633;s:5:\"video\";i:51973;}}i:407;a:14:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22669;s:5:\"video\";i:46598;}}i:408;a:14:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52537;s:5:\"video\";i:29580;}}i:409;a:14:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34343;s:5:\"video\";i:18413;}}i:410;a:14:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20519;s:5:\"video\";i:25391;}}i:411;a:14:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16265;s:5:\"video\";i:75634;}}i:412;a:14:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41495;s:5:\"video\";i:49692;}}i:413;a:14:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40417;s:5:\"video\";i:80078;}}i:414;a:14:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34150;s:5:\"video\";i:23500;}}i:415;a:14:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15426;s:5:\"video\";i:21651;}}i:416;a:14:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:33524;s:5:\"video\";i:46449;}}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "off");
INSERT INTO `wp_options` VALUES("248", "revslider_update_version", "6.6.0", "yes");
INSERT INTO `wp_options` VALUES("249", "yith_wcwl_frontend_css_colors", "s:1159:\"a:10:{s:15:\"add_to_wishlist\";a:3:{s:10:\"background\";s:7:\"#333333\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#333333\";}s:21:\"add_to_wishlist_hover\";a:3:{s:10:\"background\";s:7:\"#4F4F4F\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#4F4F4F\";}s:11:\"add_to_cart\";a:3:{s:10:\"background\";s:7:\"#333333\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#333333\";}s:17:\"add_to_cart_hover\";a:3:{s:10:\"background\";s:7:\"#4F4F4F\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#4F4F4F\";}s:14:\"button_style_1\";a:3:{s:10:\"background\";s:7:\"#333333\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#333333\";}s:20:\"button_style_1_hover\";a:3:{s:10:\"background\";s:7:\"#4F4F4F\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#4F4F4F\";}s:14:\"button_style_2\";a:3:{s:10:\"background\";s:7:\"#FFFFFF\";s:5:\"color\";s:7:\"#858484\";s:12:\"border_color\";s:7:\"#c6c6c6\";}s:20:\"button_style_2_hover\";a:3:{s:10:\"background\";s:7:\"#4F4F4F\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#4F4F4F\";}s:14:\"wishlist_table\";a:3:{s:10:\"background\";s:7:\"#FFFFFF\";s:5:\"color\";s:7:\"#6d6c6c\";s:12:\"border_color\";s:7:\"#FFFFFF\";}s:7:\"headers\";a:1:{s:10:\"background\";s:7:\"#F4F4F4\";}}\";", "yes");
INSERT INTO `wp_options` VALUES("251", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("252", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("253", "widget_woocommerce_price_filter", "a:4:{i:1;a:1:{s:5:\"title\";s:19:\"فیلتر قیمت\";}i:2;a:1:{s:5:\"title\";s:22:\"بر اساس قیمت\";}i:3;a:1:{s:5:\"title\";s:22:\"بر اساس قیمت\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("254", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("255", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("256", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("257", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("258", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("259", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("260", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("261", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("262", "widget_yith-woocompare-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("263", "widget_social-links-widget", "a:2:{i:1;a:14:{s:5:\"title\";s:0:\"\";s:12:\"facebook_url\";s:1:\"#\";s:11:\"twitter_url\";s:1:\"#\";s:14:\"googleplus_url\";s:1:\"#\";s:11:\"youtube_url\";s:1:\"#\";s:10:\"tumblr_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:13:\"pinterest_url\";s:0:\"\";s:10:\"flickr_url\";s:0:\"\";s:13:\"instagram_url\";s:1:\"#\";s:12:\"dribbble_url\";s:0:\"\";s:9:\"skype_url\";s:0:\"\";s:7:\"rss_url\";s:0:\"\";s:12:\"telegram_url\";s:1:\"#\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("264", "widget_tl_account_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("265", "widget_mf_product_categories", "a:4:{i:1;a:6:{s:5:\"title\";s:13:\"دسته ها\";s:7:\"orderby\";s:5:\"order\";s:5:\"count\";i:0;s:29:\"show_children_categories_only\";i:1;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}i:2;a:6:{s:5:\"title\";s:13:\"دسته ها\";s:7:\"orderby\";s:5:\"order\";s:5:\"count\";i:0;s:29:\"show_children_categories_only\";i:1;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}i:3;a:6:{s:5:\"title\";s:13:\"دسته ها\";s:7:\"orderby\";s:5:\"order\";s:5:\"count\";i:0;s:29:\"show_children_categories_only\";i:1;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("266", "widget_martfury_layered_nav", "a:8:{i:7;a:6:{s:5:\"title\";s:20:\"بر اساس رنگ\";s:9:\"attribute\";s:5:\"color\";s:10:\"query_type\";s:3:\"and\";s:6:\"search\";i:0;s:6:\"height\";s:5:\"130px\";s:14:\"attribute_type\";s:7:\"default\";}i:8;a:6:{s:5:\"title\";s:22:\"بر اساس سایز\";s:9:\"attribute\";s:4:\"size\";s:14:\"attribute_type\";s:7:\"default\";s:10:\"query_type\";s:3:\"and\";s:6:\"search\";i:0;s:6:\"height\";s:5:\"130px\";}i:9;a:6:{s:5:\"title\";s:35:\"بر اساس مقدار حافظه\";s:9:\"attribute\";s:3:\"ram\";s:14:\"attribute_type\";s:4:\"list\";s:10:\"query_type\";s:3:\"and\";s:6:\"search\";i:1;s:6:\"height\";s:5:\"130px\";}i:10;a:6:{s:5:\"title\";s:20:\"بر اساس رنگ\";s:9:\"attribute\";s:5:\"color\";s:14:\"attribute_type\";s:7:\"default\";s:10:\"query_type\";s:3:\"and\";s:6:\"search\";i:0;s:6:\"height\";s:5:\"130px\";}i:11;a:6:{s:5:\"title\";s:28:\"بر اساس رزولوشن\";s:9:\"attribute\";s:10:\"resolution\";s:14:\"attribute_type\";s:7:\"default\";s:10:\"query_type\";s:3:\"and\";s:6:\"search\";i:0;s:6:\"height\";s:5:\"130px\";}i:12;a:6:{s:5:\"title\";s:31:\"بر اساس نوع اتصال\";s:9:\"attribute\";s:8:\"wireless\";s:14:\"attribute_type\";s:7:\"default\";s:10:\"query_type\";s:3:\"and\";s:6:\"search\";i:0;s:6:\"height\";s:5:\"130px\";}i:13;a:6:{s:5:\"title\";s:20:\"بر اساس نوع\";s:9:\"attribute\";s:11:\"sound-stype\";s:14:\"attribute_type\";s:7:\"default\";s:10:\"query_type\";s:3:\"and\";s:6:\"search\";i:0;s:6:\"height\";s:5:\"130px\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("267", "widget_mf_product_brands", "a:4:{i:1;a:3:{s:5:\"title\";s:19:\"فیلتر برند\";s:7:\"orderby\";s:4:\"name\";s:6:\"height\";s:3:\"130\";}i:2;a:3:{s:5:\"title\";s:22:\"بر اساس برند\";s:7:\"orderby\";s:4:\"name\";s:6:\"height\";s:3:\"130\";}i:3;a:3:{s:5:\"title\";s:22:\"بر اساس برند\";s:7:\"orderby\";s:4:\"name\";s:6:\"height\";s:3:\"130\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("268", "widget_martfury_rating_filter", "a:4:{i:1;a:1:{s:5:\"title\";s:21:\"فیلتر بررسی\";}i:2;a:1:{s:5:\"title\";s:24:\"بر اساس بررسی\";}i:3;a:1:{s:5:\"title\";s:34:\"بر اساس نقد و بررسی\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("269", "widget_martfury_layered_nav_filters", "a:4:{i:1;a:1:{s:5:\"title\";s:14:\"فیلترها\";}i:2;a:1:{s:5:\"title\";s:25:\"فیلتر محصولات\";}i:3;a:1:{s:5:\"title\";s:25:\"فیلتر محصولات\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("270", "widget_mf_woocommerce_products", "a:2:{i:1;a:8:{s:5:\"title\";s:35:\"محصول دیگر این برند\";s:6:\"number\";i:6;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:8:\"taxonomy\";s:5:\"brand\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("271", "widget_martfury_currency_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("272", "widget_martfury_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("274", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("275", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("276", "vc_version", "8.7.1", "yes");
INSERT INTO `wp_options` VALUES("278", "woocommerce_maybe_regenerate_images_hash", "937d52ab591114d5e663a87b7a7ef6ab", "yes");
INSERT INTO `wp_options` VALUES("288", "yith_wcwl_wishlist_title", "لیست علاقه مندی های من", "yes");
INSERT INTO `wp_options` VALUES("297", "mc4wp_version", "4.10.8", "yes");
INSERT INTO `wp_options` VALUES("298", "yith_woocompare_is_button", "button", "yes");
INSERT INTO `wp_options` VALUES("299", "yith_woocompare_button_text", "مقایسه", "yes");
INSERT INTO `wp_options` VALUES("300", "yith_woocompare_compare_button_in_product_page", "yes", "yes");
INSERT INTO `wp_options` VALUES("301", "yith_woocompare_compare_button_in_products_list", "no", "yes");
INSERT INTO `wp_options` VALUES("302", "yith_woocompare_auto_open", "yes", "yes");
INSERT INTO `wp_options` VALUES("303", "yith_woocompare_table_text", "مقایسه‌ی محصولات", "yes");
INSERT INTO `wp_options` VALUES("304", "yith_woocompare_fields_attrs", "a:18:{i:0;s:5:\"price\";i:1;s:11:\"description\";i:2;s:3:\"sku\";i:3;s:5:\"stock\";i:4;s:6:\"weight\";i:5;s:10:\"dimensions\";i:6;s:8:\"pa_color\";i:7;s:13:\"pa_hard-drive\";i:8;s:18:\"pa_processor-model\";i:9;s:6:\"pa_ram\";i:10;s:13:\"pa_resolution\";i:11;s:14:\"pa_screen-size\";i:12;s:7:\"pa_size\";i:13;s:14:\"pa_sound-stype\";i:14;s:11:\"pa_wireless\";i:15;s:5:\"image\";i:16;s:5:\"title\";i:17;s:11:\"add-to-cart\";}", "yes");
INSERT INTO `wp_options` VALUES("305", "yith_woocompare_price_end", "yes", "yes");
INSERT INTO `wp_options` VALUES("306", "yith_woocompare_add_to_cart_end", "no", "yes");
INSERT INTO `wp_options` VALUES("307", "yith_woocompare_image_size", "a:3:{s:5:\"width\";s:3:\"220\";s:6:\"height\";s:3:\"154\";s:4:\"crop\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("308", "yit_plugin_fw_panel_wc_default_options_set", "a:7:{s:21:\"yith_woocompare_panel\";b:1;s:15:\"yith_wcwl_panel\";b:1;s:32:\"yith_wcact_panel_product_auction\";b:1;s:26:\"yith_wc_catalog_mode_panel\";b:1;s:15:\"yith_wcbm_panel\";b:1;s:11:\"ywccp_panel\";b:1;s:15:\"yith_wcas_panel\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("309", "yith_wcwl_general_videobox", "a:7:{s:11:\"plugin_name\";s:49:\"افزونه علاقه‌مندی ووکامرس\";s:18:\"title_first_column\";s:56:\"امکانات پیشرفته را مشاهده کنید\";s:24:\"description_first_column\";s:141:\"ارتقاء دهید به نسخه پولی افزونه علاقه‌مندی تا ازهمه ویژگی‌ها بهره‌مند شوید!\";s:5:\"video\";a:3:{s:8:\"video_id\";s:9:\"118797844\";s:15:\"video_image_url\";s:116:\"http://mimwp.com/theme/martfury/xinstall/wp-content/plugins/yith-woocommerce-wishlist//assets/images/video-thumb.jpg\";s:17:\"video_description\";s:0:\"\";}s:19:\"title_second_column\";s:77:\"در اختیار داشتن ویژگی‌های پولی و پشتیبانی\";s:25:\"description_second_column\";s:337:\"با خرید نسخه حرفه ای این افزونه میتوانید از امکانات پیشرفته این محصول بهره ببرید، همچنین به مدت 1 سال آپدیت های این افزونه را بطور رایگان دریافت کنید و از پشتیبانی 24 ساعته ما استفاده کنید\";s:6:\"button\";a:2:{s:4:\"href\";s:78:\"http://yithemes.com/themes/plugins/yith-woocommerce-wishlist/?refer_id=1030585\";s:5:\"title\";s:28:\"Get Support and Pro Features\";}}", "yes");
INSERT INTO `wp_options` VALUES("310", "yith_wcwl_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("311", "yith_wcwl_wishlist_page_id", "406", "yes");
INSERT INTO `wp_options` VALUES("312", "yith_wcwl_redirect_cart", "no", "yes");
INSERT INTO `wp_options` VALUES("313", "yith_wcwl_remove_after_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("314", "yith_wcwl_add_to_wishlist_text", "افزودن به علاقه مندی ها", "yes");
INSERT INTO `wp_options` VALUES("315", "yith_wcwl_browse_wishlist_text", "مشاهده لیست علاقه مندی ها", "yes");
INSERT INTO `wp_options` VALUES("316", "yith_wcwl_already_in_wishlist_text", "محصول از قبل به علاقه مندی ها اضافه شده!", "yes");
INSERT INTO `wp_options` VALUES("317", "yith_wcwl_product_added_text", "اضافه شد!", "yes");
INSERT INTO `wp_options` VALUES("318", "yith_wcwl_add_to_cart_text", "افزودن به سبد", "yes");
INSERT INTO `wp_options` VALUES("319", "yith_wcwl_price_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("320", "yith_wcwl_add_to_cart_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("321", "yith_wcwl_stock_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("322", "yith_wcwl_show_dateadded", "no", "yes");
INSERT INTO `wp_options` VALUES("323", "yith_wcwl_repeat_remove_button", "yes", "yes");
INSERT INTO `wp_options` VALUES("324", "yith_wcwl_share_fb", "yes", "yes");
INSERT INTO `wp_options` VALUES("325", "yith_wcwl_share_twitter", "yes", "yes");
INSERT INTO `wp_options` VALUES("326", "yith_wcwl_share_pinterest", "yes", "yes");
INSERT INTO `wp_options` VALUES("327", "yith_wcwl_share_googleplus", "yes", "yes");
INSERT INTO `wp_options` VALUES("328", "yith_wcwl_share_email", "yes", "yes");
INSERT INTO `wp_options` VALUES("329", "yith_wcwl_socials_title", "لیست علاقه مندی های من", "yes");
INSERT INTO `wp_options` VALUES("330", "yith_wcwl_socials_text", "", "yes");
INSERT INTO `wp_options` VALUES("331", "yith_wcwl_socials_image_url", "", "yes");
INSERT INTO `wp_options` VALUES("332", "yith_wfbt_enable_integration", "no", "yes");
INSERT INTO `wp_options` VALUES("333", "yith_wcwl_use_button", "no", "yes");
INSERT INTO `wp_options` VALUES("334", "yith_wcwl_custom_css", "", "yes");
INSERT INTO `wp_options` VALUES("335", "yith_wcwl_frontend_css", "yes", "yes");
INSERT INTO `wp_options` VALUES("336", "yith_wcwl_rounded_corners", "yes", "yes");
INSERT INTO `wp_options` VALUES("337", "yith_wcwl_add_to_wishlist_icon", "none", "yes");
INSERT INTO `wp_options` VALUES("338", "yith_wcwl_add_to_cart_icon", "fa-shopping-cart", "yes");
INSERT INTO `wp_options` VALUES("339", "yith_woocompare_fields", "a:20:{s:12:\"product_info\";b:0;s:5:\"price\";b:1;s:6:\"rating\";b:0;s:11:\"description\";b:1;s:3:\"sku\";b:1;s:5:\"stock\";b:1;s:6:\"weight\";b:1;s:10:\"dimensions\";b:1;s:8:\"pa_color\";b:1;s:13:\"pa_hard-drive\";b:1;s:18:\"pa_processor-model\";b:1;s:6:\"pa_ram\";b:1;s:13:\"pa_resolution\";b:1;s:14:\"pa_screen-size\";b:1;s:7:\"pa_size\";b:1;s:14:\"pa_sound-stype\";b:1;s:11:\"pa_wireless\";b:1;s:5:\"image\";b:1;s:5:\"title\";b:1;s:11:\"add-to-cart\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("350", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("375", "pa_color_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("376", "pa_resolution_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("377", "pa_sound-stype_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("378", "pa_wireless_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("379", "pa_screen-size_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("380", "pa_ram_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("381", "pa_processor-model_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("382", "pa_hard-drive_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("383", "pa_size_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("385", "nav_menus_created_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("386", "shop_catalog_image_size", "a:3:{s:5:\"width\";i:480;s:6:\"height\";i:480;s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("387", "shop_single_image_size", "a:3:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("388", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";i:70;s:6:\"height\";i:70;s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("434", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("484", "yith_wcwl_button_position", "add-to-cart", "yes");
INSERT INTO `wp_options` VALUES("485", "product_brand_permalinks", "a:1:{s:18:\"product_brand_base\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("605", "revslider-valid-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("622", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("623", "revslider-latest-version", "6.7.38", "yes");
INSERT INTO `wp_options` VALUES("624", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("625", "revslider-notices", "a:5:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-b.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:324:\"<style type=\"text/css\">#rs_ads_1 .rs_close_advert { display: none; } #rs_ads_1 { box-shadow: none !important; }</style>\n<iframe id=\"sr-notice-ad-iframe-wrapper\" \n        src=\"//updates.themepunch-ext-b.tools//banners/ads/ads.php\"\n        style=\"text-align: center; height:360px;width: 100%;\"\n        scrolling=\"no\"\n</iframe>\";s:4:\"code\";s:10:\"TPAD1_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:2:\"id\";s:8:\"rs_ads_1\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("626", "revslider-dashboard", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("627", "revslider-addons", "O:8:\"stdClass\":35:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.1.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-08-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"481\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:6:\"1.0.10\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"493\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:6:\"6.4.10\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2023-11-16\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"507\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"499\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2023-10-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"500\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"498\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.8\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("934", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("5274", "woocommerce_placeholder_image", "2732", "yes");
INSERT INTO `wp_options` VALUES("18011", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:16:\"mimwp2@gmail.com\";s:7:\"version\";s:5:\"6.4.3\";s:9:\"timestamp\";i:1706687503;}", "no");
INSERT INTO `wp_options` VALUES("18070", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18071", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18072", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18125", "melipayamak_update_period", "6", "yes");
INSERT INTO `wp_options` VALUES("18126", "melipayamak_page", "10", "yes");
INSERT INTO `wp_options` VALUES("18127", "melipayamak_iborder", "#e0dfdf", "yes");
INSERT INTO `wp_options` VALUES("18128", "melipayamak_ihborder", "#83b2d8", "yes");
INSERT INTO `wp_options` VALUES("18129", "melipayamak_sbg", "#579bd3", "yes");
INSERT INTO `wp_options` VALUES("18130", "melipayamak_shbg", "#4887bc", "yes");
INSERT INTO `wp_options` VALUES("18131", "melipayamak_sborder", "#4887bc", "yes");
INSERT INTO `wp_options` VALUES("18132", "melipayamak_shborder", "#4887bc", "yes");
INSERT INTO `wp_options` VALUES("18133", "melipayamak_fontc", "#818181", "yes");
INSERT INTO `wp_options` VALUES("18134", "melipayamak_cfontc", "#6b9ecc", "yes");
INSERT INTO `wp_options` VALUES("18135", "melipayamak_fonts", "17", "yes");
INSERT INTO `wp_options` VALUES("18136", "melipayamak_fontm", "Yekan", "yes");
INSERT INTO `wp_options` VALUES("18137", "melipayamak_form", "#f5f5f5", "yes");
INSERT INTO `wp_options` VALUES("18138", "melipayamak_border", "2", "yes");
INSERT INTO `wp_options` VALUES("18139", "melipayamak_radius", "3", "yes");
INSERT INTO `wp_options` VALUES("18140", "melipayamak_ilbg", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("18141", "melipayamak_ilhbg", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("18142", "melipayamak_ibg", "none", "yes");
INSERT INTO `wp_options` VALUES("18143", "melipayamak_ihbg", "none", "yes");
INSERT INTO `wp_options` VALUES("18144", "melipayamak_last_version", "2.2", "yes");
INSERT INTO `wp_options` VALUES("18183", "dokan_pages", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("18184", "dokan_pages_created", "1", "yes");
INSERT INTO `wp_options` VALUES("18185", "dokan_theme_version", "2.9.8", "yes");
INSERT INTO `wp_options` VALUES("18188", "widget_dokan-best-selling-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18189", "widget_dokan-category-menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18190", "widget_dokan-store-contact-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18191", "widget_dokan-store-location", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18192", "widget_dokan-store-menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18193", "widget_dokan-top-rated", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18194", "widget_dokan-store-open-close-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18195", "dokan_seller_data_2", "a:2:{i:0;s:20:\"dokan-count-orders-2\";i:1;s:15:\"dokan-earning-2\";}", "yes");
INSERT INTO `wp_options` VALUES("18199", "dokan-lite_allow_tracking", "yes", "yes");
INSERT INTO `wp_options` VALUES("18200", "dokan-lite_tracking_notice", "hide", "yes");
INSERT INTO `wp_options` VALUES("18201", "dokan-lite_tracking_last_send", "1549894294", "yes");
INSERT INTO `wp_options` VALUES("18202", "dokan_general", "a:3:{s:16:\"custom_store_url\";s:5:\"store\";s:17:\"tax_fee_recipient\";s:6:\"seller\";s:22:\"shipping_fee_recipient\";s:6:\"seller\";}", "yes");
INSERT INTO `wp_options` VALUES("18205", "dokan_selling", "a:4:{s:25:\"new_seller_enable_selling\";s:2:\"on\";s:15:\"commission_type\";s:10:\"percentage\";s:16:\"admin_percentage\";d:20;s:19:\"order_status_change\";s:3:\"off\";}", "yes");
INSERT INTO `wp_options` VALUES("18210", "dokan_withdraw", "a:3:{s:16:\"withdraw_methods\";a:3:{s:6:\"paypal\";s:6:\"paypal\";s:4:\"bank\";s:4:\"bank\";s:6:\"skrill\";s:6:\"skrill\";}s:14:\"withdraw_limit\";i:0;s:21:\"withdraw_order_status\";a:1:{s:12:\"wc-completed\";s:12:\"wc-completed\";}}", "yes");
INSERT INTO `wp_options` VALUES("18213", "wcct_installed", "1549895197", "yes");
INSERT INTO `wp_options` VALUES("18214", "wcct_version", "2.0", "yes");
INSERT INTO `wp_options` VALUES("18215", "weforms_settings", "a:3:{s:13:\"email_gateway\";s:9:\"wordpress\";s:6:\"credit\";b:0;s:9:\"recaptcha\";a:2:{s:3:\"key\";s:0:\"\";s:6:\"secret\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("18216", "weforms_installed", "1549895201", "yes");
INSERT INTO `wp_options` VALUES("18221", "weforms_version", "1.3.6", "yes");
INSERT INTO `wp_options` VALUES("18223", "widget_weforms_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18229", "weforms_integration", "a:3:{s:25:\"allow_vendor_contact_form\";s:2:\"on\";s:28:\"vendor_contact_section_label\";s:22:\"تماس با مدیر\";s:19:\"vendor_contact_form\";i:2705;}", "yes");
INSERT INTO `wp_options` VALUES("18230", "dokan_pointer_toplevel_page_dokan", "1", "yes");
INSERT INTO `wp_options` VALUES("18235", "woocommerce-conversion-tracking_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("18236", "woocommerce-conversion-tracking_tracking_notice", "hide", "yes");
INSERT INTO `wp_options` VALUES("18503", "weforms_dismiss_xnotice_cf7", "yes", "yes");
INSERT INTO `wp_options` VALUES("19109", "dokan_base", "http://www.terikokerdabad.ir", "yes");
INSERT INTO `wp_options` VALUES("19110", "condi_dokan", "http://www.terikokerdabad.ir", "yes");
INSERT INTO `wp_options` VALUES("19115", "DokanNikanadvir_nikan_private_options", "a:6:{s:23:\"DokanNikanadvir_rtl_api\";s:88:\"wae5jg/0G8LpaJuGJGhtqKYAp7Emsi8rKkgymIjuK1/MonMECNxNkIwqftYw3Wljz1GPic0Snj8RCBMQHmAM8g==\";s:26:\"DokanNikanadvir_rtl_domain\";s:64:\"ykjQZl+97Inr8t/fL1j9eIg4i1Ws+FpU59pB23dPlfGZE1Dm1A7jgY1W5meoYhTn\";s:27:\"DokanNikanadvir_rtl_orderid\";s:44:\"zPyXD6feWVe0uxSEYaP860Fu26osXKnR7OZDgm44zXc=\";s:28:\"DokanNikanadvir_rtl_username\";s:44:\"iOUkMjOshNKlyGpimcohVxU9DcsPvXawdklio6ZtDxU=\";s:29:\"DokanNikanadvir_rtl_secretkey\";s:88:\"HZbHZKjmJdlKJFtCGh3n/Z8ITfyQoMcX7hCnkNGLeUS1jM0D2+E6KTePRZn8adBpDCUoddn/VUCEx77GJl1pNA==\";s:26:\"DokanNikanadvir_rtl_status\";s:64:\"Ztj0zg5O+dtka7CiwG4fWVOsEfQp9nwhjGWcjX9LLZMB21iaCNka37DvJAsYKVrU\";}", "yes");
INSERT INTO `wp_options` VALUES("19116", "widget_dokan-best-seller-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19117", "widget_dokan-feature-seller-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19135", "dokan_whats_new_versions", "a:1:{i:0;s:5:\"2.9.3\";}", "yes");
INSERT INTO `wp_options` VALUES("19273", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("19338", "melipayamak_groups", "a:2:{i:0;i:1550013452;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("21091", "woocommerce_demo_store_notice", "این یک وبسایت دمو است و با هدف تست ساخته شده است، هیچ‌یک از محصولات موجود در سایت برای فروش نبوده و امکان خرید از این وبسایت وجود ندارد.", "yes");
INSERT INTO `wp_options` VALUES("21092", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `wp_options` VALUES("21093", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `wp_options` VALUES("21094", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `wp_options` VALUES("21095", "woocommerce_thumbnail_cropping", "1:1", "yes");
INSERT INTO `wp_options` VALUES("21096", "woocommerce_thumbnail_cropping_custom_width", "4", "yes");
INSERT INTO `wp_options` VALUES("21097", "woocommerce_thumbnail_cropping_custom_height", "3", "yes");
INSERT INTO `wp_options` VALUES("21098", "woocommerce_checkout_company_field", "optional", "yes");
INSERT INTO `wp_options` VALUES("21099", "woocommerce_checkout_address_2_field", "optional", "yes");
INSERT INTO `wp_options` VALUES("21100", "woocommerce_checkout_phone_field", "required", "yes");
INSERT INTO `wp_options` VALUES("21101", "woocommerce_checkout_terms_and_conditions_checkbox_text", "من [terms] سایت را خوانده ام و آن را می پذیرم.", "yes");
INSERT INTO `wp_options` VALUES("27735", "kirki_telemetry_no_consent", "1", "yes");
INSERT INTO `wp_options` VALUES("59722", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("59723", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("59724", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("59728", "woocommerce_marketplace_suggestions", "a:2:{s:11:\"suggestions\";a:28:{i:0;a:4:{s:4:\"slug\";s:28:\"product-edit-meta-tab-header\";s:7:\"context\";s:28:\"product-edit-meta-tab-header\";s:5:\"title\";s:22:\"Recommended extensions\";s:13:\"allow-dismiss\";b:0;}i:1;a:6:{s:4:\"slug\";s:39:\"product-edit-meta-tab-footer-browse-all\";s:7:\"context\";s:28:\"product-edit-meta-tab-footer\";s:9:\"link-text\";s:21:\"Browse all extensions\";s:3:\"url\";s:64:\"https://woocommerce.com/product-category/woocommerce-extensions/\";s:8:\"promoted\";s:31:\"category-woocommerce-extensions\";s:13:\"allow-dismiss\";b:0;}i:2;a:9:{s:4:\"slug\";s:46:\"product-edit-mailchimp-woocommerce-memberships\";s:7:\"product\";s:33:\"woocommerce-memberships-mailchimp\";s:14:\"show-if-active\";a:1:{i:0;s:23:\"woocommerce-memberships\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:116:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/mailchimp-for-memberships.svg\";s:5:\"title\";s:25:\"Mailchimp for Memberships\";s:4:\"copy\";s:79:\"Completely automate your email lists by syncing membership changes to Mailchimp\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:67:\"https://woocommerce.com/products/mailchimp-woocommerce-memberships/\";}i:3;a:9:{s:4:\"slug\";s:19:\"product-edit-addons\";s:7:\"product\";s:26:\"woocommerce-product-addons\";s:14:\"show-if-active\";a:2:{i:0;s:25:\"woocommerce-subscriptions\";i:1;s:20:\"woocommerce-bookings\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/product-add-ons.svg\";s:5:\"title\";s:15:\"Product Add-Ons\";s:4:\"copy\";s:93:\"Offer add-ons like gift wrapping, special messages or other special options for your products\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:49:\"https://woocommerce.com/products/product-add-ons/\";}i:4;a:9:{s:4:\"slug\";s:46:\"product-edit-woocommerce-subscriptions-gifting\";s:7:\"product\";s:33:\"woocommerce-subscriptions-gifting\";s:14:\"show-if-active\";a:1:{i:0;s:25:\"woocommerce-subscriptions\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:116:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/gifting-for-subscriptions.svg\";s:5:\"title\";s:25:\"Gifting for Subscriptions\";s:4:\"copy\";s:70:\"Let customers buy subscriptions for others - they\'re the ultimate gift\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:67:\"https://woocommerce.com/products/woocommerce-subscriptions-gifting/\";}i:5;a:9:{s:4:\"slug\";s:42:\"product-edit-teams-woocommerce-memberships\";s:7:\"product\";s:33:\"woocommerce-memberships-for-teams\";s:14:\"show-if-active\";a:1:{i:0;s:23:\"woocommerce-memberships\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:112:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/teams-for-memberships.svg\";s:5:\"title\";s:21:\"Teams for Memberships\";s:4:\"copy\";s:123:\"Adds B2B functionality to WooCommerce Memberships, allowing sites to sell team, group, corporate, or family member accounts\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:63:\"https://woocommerce.com/products/teams-woocommerce-memberships/\";}i:6;a:8:{s:4:\"slug\";s:29:\"product-edit-variation-images\";s:7:\"product\";s:39:\"woocommerce-additional-variation-images\";s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:118:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/additional-variation-images.svg\";s:5:\"title\";s:27:\"Additional Variation Images\";s:4:\"copy\";s:72:\"Showcase your products in the best light with a image for each variation\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:73:\"https://woocommerce.com/products/woocommerce-additional-variation-images/\";}i:7;a:9:{s:4:\"slug\";s:47:\"product-edit-woocommerce-subscription-downloads\";s:7:\"product\";s:34:\"woocommerce-subscription-downloads\";s:14:\"show-if-active\";a:1:{i:0;s:25:\"woocommerce-subscriptions\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/subscription-downloads.svg\";s:5:\"title\";s:22:\"Subscription Downloads\";s:4:\"copy\";s:57:\"Give customers special downloads with their subscriptions\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:68:\"https://woocommerce.com/products/woocommerce-subscription-downloads/\";}i:8;a:8:{s:4:\"slug\";s:31:\"product-edit-min-max-quantities\";s:7:\"product\";s:30:\"woocommerce-min-max-quantities\";s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/min-max-quantities.svg\";s:5:\"title\";s:18:\"Min/Max Quantities\";s:4:\"copy\";s:81:\"Specify minimum and maximum allowed product quantities for orders to be completed\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:52:\"https://woocommerce.com/products/min-max-quantities/\";}i:9;a:8:{s:4:\"slug\";s:28:\"product-edit-name-your-price\";s:7:\"product\";s:27:\"woocommerce-name-your-price\";s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/name-your-price.svg\";s:5:\"title\";s:15:\"Name Your Price\";s:4:\"copy\";s:70:\"Let customers pay what they want - useful for donations, tips and more\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:49:\"https://woocommerce.com/products/name-your-price/\";}i:10;a:8:{s:4:\"slug\";s:42:\"product-edit-woocommerce-one-page-checkout\";s:7:\"product\";s:29:\"woocommerce-one-page-checkout\";s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/one-page-checkout.svg\";s:5:\"title\";s:17:\"One Page Checkout\";s:4:\"copy\";s:92:\"Don\'t make customers click around - let them choose products, checkout & pay all on one page\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:63:\"https://woocommerce.com/products/woocommerce-one-page-checkout/\";}i:11;a:9:{s:4:\"slug\";s:24:\"product-edit-automatewoo\";s:7:\"product\";s:11:\"automatewoo\";s:14:\"show-if-active\";a:1:{i:0;s:25:\"woocommerce-subscriptions\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/subscriptions.svg\";s:5:\"title\";s:23:\"Automate your marketing\";s:4:\"copy\";s:89:\"Win customers and keep them coming back with a nearly endless range of powerful workflows\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:45:\"https://woocommerce.com/products/automatewoo/\";}i:12;a:4:{s:4:\"slug\";s:19:\"orders-empty-header\";s:7:\"context\";s:24:\"orders-list-empty-header\";s:5:\"title\";s:20:\"Tools for your store\";s:13:\"allow-dismiss\";b:0;}i:13;a:6:{s:4:\"slug\";s:30:\"orders-empty-footer-browse-all\";s:7:\"context\";s:24:\"orders-list-empty-footer\";s:9:\"link-text\";s:21:\"Browse all extensions\";s:3:\"url\";s:64:\"https://woocommerce.com/product-category/woocommerce-extensions/\";s:8:\"promoted\";s:31:\"category-woocommerce-extensions\";s:13:\"allow-dismiss\";b:0;}i:14;a:8:{s:4:\"slug\";s:19:\"orders-empty-wc-pay\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:20:\"woocommerce-payments\";s:4:\"icon\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/woocommerce-payments.svg\";s:5:\"title\";s:20:\"WooCommerce Payments\";s:4:\"copy\";s:125:\"Securely accept payments and manage transactions directly from your WooCommerce dashboard – no setup costs or monthly fees.\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:54:\"https://woocommerce.com/products/woocommerce-payments/\";}i:15;a:8:{s:4:\"slug\";s:19:\"orders-empty-zapier\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:18:\"woocommerce-zapier\";s:4:\"icon\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/zapier.svg\";s:5:\"title\";s:6:\"Zapier\";s:4:\"copy\";s:88:\"Save time and increase productivity by connecting your store to more than 1000+ services\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:52:\"https://woocommerce.com/products/woocommerce-zapier/\";}i:16;a:8:{s:4:\"slug\";s:30:\"orders-empty-shipment-tracking\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:29:\"woocommerce-shipment-tracking\";s:4:\"icon\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/shipment-tracking.svg\";s:5:\"title\";s:17:\"Shipment Tracking\";s:4:\"copy\";s:86:\"Let customers know when their orders will arrive by adding shipment tracking to emails\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:51:\"https://woocommerce.com/products/shipment-tracking/\";}i:17;a:8:{s:4:\"slug\";s:32:\"orders-empty-table-rate-shipping\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:31:\"woocommerce-table-rate-shipping\";s:4:\"icon\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/table-rate-shipping.svg\";s:5:\"title\";s:19:\"Table Rate Shipping\";s:4:\"copy\";s:122:\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:53:\"https://woocommerce.com/products/table-rate-shipping/\";}i:18;a:8:{s:4:\"slug\";s:40:\"orders-empty-shipping-carrier-extensions\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:4:\"icon\";s:118:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/shipping-carrier-extensions.svg\";s:5:\"title\";s:27:\"Shipping Carrier Extensions\";s:4:\"copy\";s:116:\"Show live rates from FedEx, UPS, USPS and more directly on your store - never under or overcharge for shipping again\";s:11:\"button-text\";s:13:\"Find Carriers\";s:8:\"promoted\";s:26:\"category-shipping-carriers\";s:3:\"url\";s:99:\"https://woocommerce.com/product-category/woocommerce-extensions/shipping-methods/shipping-carriers/\";}i:19;a:8:{s:4:\"slug\";s:32:\"orders-empty-google-product-feed\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:25:\"woocommerce-product-feeds\";s:4:\"icon\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/google-product-feed.svg\";s:5:\"title\";s:19:\"Google Product Feed\";s:4:\"copy\";s:76:\"Increase sales by letting customers find you when they\'re shopping on Google\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:53:\"https://woocommerce.com/products/google-product-feed/\";}i:20;a:4:{s:4:\"slug\";s:35:\"products-empty-header-product-types\";s:7:\"context\";s:26:\"products-list-empty-header\";s:5:\"title\";s:23:\"Other types of products\";s:13:\"allow-dismiss\";b:0;}i:21;a:6:{s:4:\"slug\";s:32:\"products-empty-footer-browse-all\";s:7:\"context\";s:26:\"products-list-empty-footer\";s:9:\"link-text\";s:21:\"Browse all extensions\";s:3:\"url\";s:64:\"https://woocommerce.com/product-category/woocommerce-extensions/\";s:8:\"promoted\";s:31:\"category-woocommerce-extensions\";s:13:\"allow-dismiss\";b:0;}i:22;a:8:{s:4:\"slug\";s:30:\"products-empty-product-vendors\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:27:\"woocommerce-product-vendors\";s:4:\"icon\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/product-vendors.svg\";s:5:\"title\";s:15:\"Product Vendors\";s:4:\"copy\";s:47:\"Turn your store into a multi-vendor marketplace\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:49:\"https://woocommerce.com/products/product-vendors/\";}i:23;a:8:{s:4:\"slug\";s:26:\"products-empty-memberships\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:23:\"woocommerce-memberships\";s:4:\"icon\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/memberships.svg\";s:5:\"title\";s:11:\"Memberships\";s:4:\"copy\";s:76:\"Give members access to restricted content or products, for a fee or for free\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:57:\"https://woocommerce.com/products/woocommerce-memberships/\";}i:24;a:9:{s:4:\"slug\";s:35:\"products-empty-woocommerce-deposits\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:20:\"woocommerce-deposits\";s:14:\"show-if-active\";a:1:{i:0;s:20:\"woocommerce-bookings\";}s:4:\"icon\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/deposits.svg\";s:5:\"title\";s:8:\"Deposits\";s:4:\"copy\";s:75:\"Make it easier for customers to pay by offering a deposit or a payment plan\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:54:\"https://woocommerce.com/products/woocommerce-deposits/\";}i:25;a:8:{s:4:\"slug\";s:40:\"products-empty-woocommerce-subscriptions\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:25:\"woocommerce-subscriptions\";s:4:\"icon\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/subscriptions.svg\";s:5:\"title\";s:13:\"Subscriptions\";s:4:\"copy\";s:97:\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:59:\"https://woocommerce.com/products/woocommerce-subscriptions/\";}i:26;a:8:{s:4:\"slug\";s:35:\"products-empty-woocommerce-bookings\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:20:\"woocommerce-bookings\";s:4:\"icon\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/bookings.svg\";s:5:\"title\";s:8:\"Bookings\";s:4:\"copy\";s:99:\"Allow customers to book appointments, make reservations or rent equipment without leaving your site\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:54:\"https://woocommerce.com/products/woocommerce-bookings/\";}i:27;a:8:{s:4:\"slug\";s:30:\"products-empty-product-bundles\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:27:\"woocommerce-product-bundles\";s:4:\"icon\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/product-bundles.svg\";s:5:\"title\";s:15:\"Product Bundles\";s:4:\"copy\";s:49:\"Offer customizable bundles and assembled products\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:49:\"https://woocommerce.com/products/product-bundles/\";}}s:7:\"updated\";i:1661679249;}", "no");
INSERT INTO `wp_options` VALUES("75343", "recovery_keys", "a:1:{s:22:\"cXgdWzPD0ss2V6rvO5dqRx\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BI6tdV.Kuryav1fFJE72cai9fh/iZt1\";s:10:\"created_at\";i:1733057438;}}", "off");
INSERT INTO `wp_options` VALUES("111753", "kirki_font_local_filenames", "a:6:{s:69:\"https://fonts.gstatic.com/s/worksans/v4/QGYsz_wNahGAdqQ43Rh_cqDv.woff\";a:3:{s:4:\"file\";s:110:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/uploads/2019/06/QGYsz_wNahGAdqQ43Rh_cqDv-12.woff\";s:3:\"url\";s:100:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/06/QGYsz_wNahGAdqQ43Rh_cqDv-12.woff\";s:4:\"type\";s:0:\"\";}s:73:\"https://fonts.gstatic.com/s/worksans/v4/QGYpz_wNahGAdqQ43Rh3o4T8lthL.woff\";a:3:{s:4:\"file\";s:114:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/uploads/2019/06/QGYpz_wNahGAdqQ43Rh3o4T8lthL-12.woff\";s:3:\"url\";s:104:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/06/QGYpz_wNahGAdqQ43Rh3o4T8lthL-12.woff\";s:4:\"type\";s:0:\"\";}s:73:\"https://fonts.gstatic.com/s/worksans/v4/QGYpz_wNahGAdqQ43Rh3x4X8lthL.woff\";a:3:{s:4:\"file\";s:114:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/uploads/2019/06/QGYpz_wNahGAdqQ43Rh3x4X8lthL-12.woff\";s:3:\"url\";s:104:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/06/QGYpz_wNahGAdqQ43Rh3x4X8lthL-12.woff\";s:4:\"type\";s:0:\"\";}s:69:\"https://fonts.gstatic.com/s/worksans/v5/QGYsz_wNahGAdqQ43Rh_cqDv.woff\";a:3:{s:4:\"file\";s:107:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/uploads/2019/07/QGYsz_wNahGAdqQ43Rh_cqDv.woff\";s:3:\"url\";s:97:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/07/QGYsz_wNahGAdqQ43Rh_cqDv.woff\";s:4:\"type\";s:0:\"\";}s:73:\"https://fonts.gstatic.com/s/worksans/v5/QGYpz_wNahGAdqQ43Rh3o4T8lthL.woff\";a:3:{s:4:\"file\";s:111:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/uploads/2019/07/QGYpz_wNahGAdqQ43Rh3o4T8lthL.woff\";s:3:\"url\";s:101:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/07/QGYpz_wNahGAdqQ43Rh3o4T8lthL.woff\";s:4:\"type\";s:0:\"\";}s:73:\"https://fonts.gstatic.com/s/worksans/v5/QGYpz_wNahGAdqQ43Rh3x4X8lthL.woff\";a:3:{s:4:\"file\";s:111:\"/home/mimwpcom/public_html/theme/martfury/xinstall/wp-content/uploads/2019/07/QGYpz_wNahGAdqQ43Rh3x4X8lthL.woff\";s:3:\"url\";s:101:\"http://mimwp.com/theme/martfury/xinstall/wp-content/uploads/2019/07/QGYpz_wNahGAdqQ43Rh3x4X8lthL.woff\";s:4:\"type\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("135614", "rs-templates", "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", "off");
INSERT INTO `wp_options` VALUES("135615", "rs-templates-new", "", "off");
INSERT INTO `wp_options` VALUES("141240", "yith_system_info", "a:2:{s:11:\"system_info\";a:13:{s:14:\"min_wp_version\";a:1:{s:5:\"value\";s:5:\"5.3.1\";}s:14:\"min_wc_version\";a:1:{s:5:\"value\";s:5:\"3.8.1\";}s:15:\"wp_memory_limit\";a:1:{s:5:\"value\";i:1073741824;}s:15:\"min_php_version\";a:1:{s:5:\"value\";s:6:\"7.2.23\";}s:15:\"min_tls_version\";a:1:{s:5:\"value\";s:0:\"\";}s:15:\"imagick_version\";a:1:{s:5:\"value\";s:3:\"n/a\";}s:15:\"wp_cron_enabled\";a:1:{s:5:\"value\";b:1;}s:16:\"mbstring_enabled\";a:1:{s:5:\"value\";b:1;}s:17:\"simplexml_enabled\";a:1:{s:5:\"value\";b:1;}s:10:\"gd_enabled\";a:1:{s:5:\"value\";b:1;}s:13:\"iconv_enabled\";a:1:{s:5:\"value\";b:1;}s:15:\"opcache_enabled\";a:1:{s:5:\"value\";b:0;}s:17:\"url_fopen_enabled\";a:1:{s:5:\"value\";s:1:\"1\";}}s:6:\"errors\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("141528", "revslider-templates-hash", "42da1d3fd549004a80ff524485ae9caa", "yes");
INSERT INTO `wp_options` VALUES("143356", "revslider-update-hash", "05d7de709aa1730e6401d70b1515238d", "yes");
INSERT INTO `wp_options` VALUES("151858", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("154148", "revslider-library-hash", "324e6ba47fb68dfb7f1bd5b0b203bdc5", "yes");
INSERT INTO `wp_options` VALUES("157548", "revslider_update_revision_current", "6.4.10", "yes");
INSERT INTO `wp_options` VALUES("157657", "fvm-last-cache-update", "1565604523", "yes");
INSERT INTO `wp_options` VALUES("157658", "fastvelocity_min_fvm_fix_editor", "1", "yes");
INSERT INTO `wp_options` VALUES("157659", "fastvelocity_min_remove_print_mediatypes", "1", "yes");
INSERT INTO `wp_options` VALUES("157660", "fastvelocity_fvm_clean_header_one", "1", "yes");
INSERT INTO `wp_options` VALUES("157661", "fastvelocity_min_skip_google_fonts", "1", "yes");
INSERT INTO `wp_options` VALUES("157662", "fastvelocity_min_force_inline_css_footer", "1", "yes");
INSERT INTO `wp_options` VALUES("157663", "fastvelocity_min_skip_cssorder", "1", "yes");
INSERT INTO `wp_options` VALUES("157664", "fastvelocity_gfonts_method", "1", "yes");
INSERT INTO `wp_options` VALUES("157665", "fastvelocity_fontawesome_method", "1", "yes");
INSERT INTO `wp_options` VALUES("157666", "fastvelocity_min_disable_css_inline_merge", "1", "yes");
INSERT INTO `wp_options` VALUES("157667", "fastvelocity_min_blacklist", "/html5shiv.js\n/html5shiv-printshiv.min.js\n/excanvas.js\n/avada-ie9.js\n/respond.js\n/respond.min.js\n/selectivizr.js\n/Avada/assets/css/ie.css\n/html5.js\n/IE9.js\n/fusion-ie9.js\n/vc_lte_ie9.min.css\n/old-ie.css\n/ie.css\n/vc-ie8.min.css\n/mailchimp-for-wp/assets/js/third-party/placeholders.min.js\n/assets/js/plugins/wp-enqueue/min/webfontloader.js\n/a.optnmstr.com/app/js/api.min.js\n/pixelyoursite/js/public.js\n/assets/js/wcdrip-drip.js", "yes");
INSERT INTO `wp_options` VALUES("157668", "fastvelocity_min_ignorelist", "/Avada/assets/js/main.min.js\n/woocommerce-product-search/js/product-search.js\n/includes/builder/scripts/frontend-builder-scripts.js\n/assets/js/jquery.themepunch.tools.min.js\n/js/TweenMax.min.js\n/jupiter/assets/js/min/full-scripts\n/wp-content/themes/Divi/core/admin/js/react-dom.production.min.js\n/LayerSlider/static/layerslider/js/greensock.js\n/themes/kalium/assets/js/main.min.js\n/elementor/assets/js/common.min.js\n/elementor/assets/js/frontend.min.js\n/elementor-pro/assets/js/frontend.min.js\n/Divi/core/admin/js/react-dom.production.min.js\n/kalium/assets/js/main.min.js", "yes");
INSERT INTO `wp_options` VALUES("157669", "fastvelocity_plugin_version", "2.7.3", "yes");
INSERT INTO `wp_options` VALUES("157670", "fastvelocity_preserve_settings_on_uninstall", "1", "yes");
INSERT INTO `wp_options` VALUES("157676", "fastvelocity_min_enable_purgemenu", "", "yes");
INSERT INTO `wp_options` VALUES("157677", "fastvelocity_min_default_protocol", "dynamic", "yes");
INSERT INTO `wp_options` VALUES("157678", "fastvelocity_min_disable_js_merge", "", "yes");
INSERT INTO `wp_options` VALUES("157679", "fastvelocity_min_disable_css_merge", "", "yes");
INSERT INTO `wp_options` VALUES("157680", "fastvelocity_min_disable_js_minification", "", "yes");
INSERT INTO `wp_options` VALUES("157681", "fastvelocity_min_disable_css_minification", "", "yes");
INSERT INTO `wp_options` VALUES("157682", "fastvelocity_min_skip_html_minification", "", "yes");
INSERT INTO `wp_options` VALUES("157683", "fastvelocity_min_strip_htmlcomments", "", "yes");
INSERT INTO `wp_options` VALUES("157684", "fastvelocity_min_skip_fontawesome_fonts", "", "yes");
INSERT INTO `wp_options` VALUES("157685", "fastvelocity_min_skip_emoji_removal", "", "yes");
INSERT INTO `wp_options` VALUES("157686", "fastvelocity_min_enable_defer_js", "", "yes");
INSERT INTO `wp_options` VALUES("157687", "fastvelocity_min_exclude_defer_jquery", "", "yes");
INSERT INTO `wp_options` VALUES("157688", "fastvelocity_min_force_inline_css", "", "yes");
INSERT INTO `wp_options` VALUES("157689", "fastvelocity_min_remove_googlefonts", "1", "yes");
INSERT INTO `wp_options` VALUES("157690", "fastvelocity_min_defer_for_pagespeed", "", "yes");
INSERT INTO `wp_options` VALUES("157691", "fastvelocity_min_defer_for_pagespeed_optimize", "", "yes");
INSERT INTO `wp_options` VALUES("157692", "fastvelocity_min_exclude_defer_login", "", "yes");
INSERT INTO `wp_options` VALUES("157693", "fastvelocity_min_skip_defer_lists", "", "yes");
INSERT INTO `wp_options` VALUES("157694", "fastvelocity_min_fvm_cdn_url", "", "yes");
INSERT INTO `wp_options` VALUES("157695", "fastvelocity_min_fvm_cdn_force", "", "yes");
INSERT INTO `wp_options` VALUES("157696", "fastvelocity_min_change_cache_base_url", "", "yes");
INSERT INTO `wp_options` VALUES("157697", "fastvelocity_min_change_cache_path", "", "yes");
INSERT INTO `wp_options` VALUES("157716", "wpsupercache_start", "1564406340", "yes");
INSERT INTO `wp_options` VALUES("157717", "wpsupercache_count", "0", "yes");
INSERT INTO `wp_options` VALUES("157720", "supercache_stats", "a:3:{s:9:\"generated\";i:1565604384;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:6:\"cached\";i:0;s:5:\"fsize\";i:0;s:11:\"cached_list\";a:0:{}s:12:\"expired_list\";a:0:{}}s:7:\"wpcache\";a:5:{s:7:\"expired\";i:0;s:6:\"cached\";i:0;s:5:\"fsize\";i:0;s:11:\"cached_list\";a:0:{}s:12:\"expired_list\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("157721", "wpsupercache_gc_time", "1564905858", "yes");
INSERT INTO `wp_options` VALUES("157729", "heartbeat_control_settings", "a:3:{s:10:\"rules_dash\";a:1:{i:0;a:2:{s:26:\"heartbeat_control_behavior\";s:5:\"allow\";s:27:\"heartbeat_control_frequency\";s:2:\"15\";}}s:11:\"rules_front\";a:1:{i:0;a:2:{s:26:\"heartbeat_control_behavior\";s:5:\"allow\";s:27:\"heartbeat_control_frequency\";s:2:\"15\";}}s:12:\"rules_editor\";a:1:{i:0;a:2:{s:26:\"heartbeat_control_behavior\";s:5:\"allow\";s:27:\"heartbeat_control_frequency\";s:2:\"15\";}}}", "yes");
INSERT INTO `wp_options` VALUES("157730", "heartbeat_control_version", "2.0.1", "yes");
INSERT INTO `wp_options` VALUES("157796", "wp-smush-settings", "a:20:{s:4:\"auto\";b:1;s:5:\"lossy\";b:0;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:0;s:6:\"backup\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:1;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("157797", "wdev-frash", "a:3:{s:7:\"plugins\";a:1:{s:23:\"wp-smushit/wp-smush.php\";i:1564408908;}s:5:\"queue\";a:0:{}s:4:\"done\";a:2:{i:0;a:6:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:5:\"email\";s:7:\"show_at\";i:1564408908;s:5:\"state\";s:6:\"ignore\";s:4:\"hash\";s:32:\"fc50097023d0d34c5a66f6cddcf77694\";s:10:\"handled_at\";i:1577000291;}i:1;a:6:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:4:\"rate\";s:7:\"show_at\";i:1577086685;s:5:\"state\";s:6:\"ignore\";s:4:\"hash\";s:32:\"fc50097023d0d34c5a66f6cddcf77694\";s:10:\"handled_at\";i:1611689638;}}}", "no");
INSERT INTO `wp_options` VALUES("157798", "wp-smush-install-type", "existing", "no");
INSERT INTO `wp_options` VALUES("157799", "wp-smush-version", "3.22.1", "off");
INSERT INTO `wp_options` VALUES("157803", "smush_global_stats", "a:9:{s:11:\"size_before\";i:26777194;s:10:\"size_after\";i:24858992;s:7:\"percent\";d:7.20000000000000017763568394002504646778106689453125;s:5:\"human\";s:7:\"1٫8 MB\";s:5:\"bytes\";i:1918202;s:12:\"total_images\";i:1671;s:12:\"resize_count\";i:0;s:14:\"resize_savings\";i:0;s:18:\"conversion_savings\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("157804", "dir_smush_stats", "a:2:{s:9:\"dir_smush\";a:2:{s:5:\"total\";s:1:\"0\";s:9:\"optimised\";i:0;}s:14:\"combined_stats\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("157806", "skip-smush-setup", "1", "yes");
INSERT INTO `wp_options` VALUES("164217", "wpsc_feed_list", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("164591", "smush-in-progress-2774", "1", "yes");
INSERT INTO `wp_options` VALUES("164608", "smush-in-progress-2772", "1", "yes");
INSERT INTO `wp_options` VALUES("164617", "smush-in-progress-2771", "1", "yes");
INSERT INTO `wp_options` VALUES("164626", "smush-in-progress-2770", "1", "yes");
INSERT INTO `wp_options` VALUES("164635", "smush-in-progress-2732", "1", "yes");
INSERT INTO `wp_options` VALUES("164645", "smush-in-progress-2674", "1", "yes");
INSERT INTO `wp_options` VALUES("164654", "smush-in-progress-2673", "1", "yes");
INSERT INTO `wp_options` VALUES("164664", "smush-in-progress-2672", "1", "yes");
INSERT INTO `wp_options` VALUES("164672", "smush-in-progress-2671", "1", "yes");
INSERT INTO `wp_options` VALUES("164684", "smush-in-progress-2669", "1", "yes");
INSERT INTO `wp_options` VALUES("164698", "smush-in-progress-2654", "1", "yes");
INSERT INTO `wp_options` VALUES("164708", "smush-in-progress-2653", "1", "yes");
INSERT INTO `wp_options` VALUES("164717", "smush-in-progress-2652", "1", "yes");
INSERT INTO `wp_options` VALUES("164728", "smush-in-progress-2651", "1", "yes");
INSERT INTO `wp_options` VALUES("164741", "smush-in-progress-2650", "1", "yes");
INSERT INTO `wp_options` VALUES("164751", "smush-in-progress-2649", "1", "yes");
INSERT INTO `wp_options` VALUES("164760", "smush-in-progress-2648", "1", "yes");
INSERT INTO `wp_options` VALUES("164772", "smush-in-progress-2647", "1", "yes");
INSERT INTO `wp_options` VALUES("164783", "smush-in-progress-2646", "1", "yes");
INSERT INTO `wp_options` VALUES("164793", "smush-in-progress-2645", "1", "yes");
INSERT INTO `wp_options` VALUES("164802", "smush-in-progress-2644", "1", "yes");
INSERT INTO `wp_options` VALUES("164812", "smush-in-progress-2643", "1", "yes");
INSERT INTO `wp_options` VALUES("164821", "smush-in-progress-2642", "1", "yes");
INSERT INTO `wp_options` VALUES("164829", "smush-in-progress-2641", "1", "yes");
INSERT INTO `wp_options` VALUES("164841", "smush-in-progress-2640", "1", "yes");
INSERT INTO `wp_options` VALUES("164852", "smush-in-progress-2639", "1", "yes");
INSERT INTO `wp_options` VALUES("164861", "smush-in-progress-2638", "1", "yes");
INSERT INTO `wp_options` VALUES("164870", "smush-in-progress-2637", "1", "yes");
INSERT INTO `wp_options` VALUES("164879", "smush-in-progress-2636", "1", "yes");
INSERT INTO `wp_options` VALUES("164889", "smush-in-progress-2635", "1", "yes");
INSERT INTO `wp_options` VALUES("164898", "smush-in-progress-2634", "1", "yes");
INSERT INTO `wp_options` VALUES("164908", "smush-in-progress-2633", "1", "yes");
INSERT INTO `wp_options` VALUES("164917", "smush-in-progress-2632", "1", "yes");
INSERT INTO `wp_options` VALUES("164927", "smush-in-progress-2631", "1", "yes");
INSERT INTO `wp_options` VALUES("164936", "smush-in-progress-2630", "1", "yes");
INSERT INTO `wp_options` VALUES("164945", "smush-in-progress-2629", "1", "yes");
INSERT INTO `wp_options` VALUES("164954", "smush-in-progress-2628", "1", "yes");
INSERT INTO `wp_options` VALUES("164963", "smush-in-progress-2627", "1", "yes");
INSERT INTO `wp_options` VALUES("164972", "smush-in-progress-2626", "1", "yes");
INSERT INTO `wp_options` VALUES("164981", "smush-in-progress-2625", "1", "yes");
INSERT INTO `wp_options` VALUES("164990", "smush-in-progress-2624", "1", "yes");
INSERT INTO `wp_options` VALUES("165000", "smush-in-progress-2623", "1", "yes");
INSERT INTO `wp_options` VALUES("165009", "smush-in-progress-2622", "1", "yes");
INSERT INTO `wp_options` VALUES("165017", "smush-in-progress-2621", "1", "yes");
INSERT INTO `wp_options` VALUES("165026", "smush-in-progress-2620", "1", "yes");
INSERT INTO `wp_options` VALUES("165034", "smush-in-progress-2619", "1", "yes");
INSERT INTO `wp_options` VALUES("165043", "smush-in-progress-2618", "1", "yes");
INSERT INTO `wp_options` VALUES("165051", "smush-in-progress-2617", "1", "yes");
INSERT INTO `wp_options` VALUES("165060", "smush-in-progress-2616", "1", "yes");
INSERT INTO `wp_options` VALUES("165068", "smush-in-progress-2615", "1", "yes");
INSERT INTO `wp_options` VALUES("165078", "smush-in-progress-2614", "1", "yes");
INSERT INTO `wp_options` VALUES("165087", "smush-in-progress-2613", "1", "yes");
INSERT INTO `wp_options` VALUES("165095", "smush-in-progress-2612", "1", "yes");
INSERT INTO `wp_options` VALUES("165104", "smush-in-progress-2611", "1", "yes");
INSERT INTO `wp_options` VALUES("165114", "smush-in-progress-2598", "1", "yes");
INSERT INTO `wp_options` VALUES("165122", "smush-in-progress-2597", "1", "yes");
INSERT INTO `wp_options` VALUES("165132", "smush-in-progress-2596", "1", "yes");
INSERT INTO `wp_options` VALUES("165141", "smush-in-progress-2595", "1", "yes");
INSERT INTO `wp_options` VALUES("165150", "smush-in-progress-2594", "1", "yes");
INSERT INTO `wp_options` VALUES("165159", "smush-in-progress-2593", "1", "yes");
INSERT INTO `wp_options` VALUES("165175", "smush-in-progress-2589", "1", "yes");
INSERT INTO `wp_options` VALUES("165190", "smush-in-progress-2586", "1", "yes");
INSERT INTO `wp_options` VALUES("165202", "smush-in-progress-2583", "1", "yes");
INSERT INTO `wp_options` VALUES("165212", "smush-in-progress-2582", "1", "yes");
INSERT INTO `wp_options` VALUES("165221", "smush-in-progress-2571", "1", "yes");
INSERT INTO `wp_options` VALUES("165233", "smush-in-progress-2478", "1", "yes");
INSERT INTO `wp_options` VALUES("165242", "smush-in-progress-2477", "1", "yes");
INSERT INTO `wp_options` VALUES("165251", "smush-in-progress-2476", "1", "yes");
INSERT INTO `wp_options` VALUES("165264", "smush-in-progress-2475", "1", "yes");
INSERT INTO `wp_options` VALUES("165274", "smush-in-progress-2474", "1", "yes");
INSERT INTO `wp_options` VALUES("165283", "smush-in-progress-2473", "1", "yes");
INSERT INTO `wp_options` VALUES("165295", "smush-in-progress-2435", "1", "yes");
INSERT INTO `wp_options` VALUES("165386", "smush-in-progress-2308", "1", "yes");
INSERT INTO `wp_options` VALUES("165395", "smush-in-progress-2307", "1", "yes");
INSERT INTO `wp_options` VALUES("165424", "smush-in-progress-2203", "1", "yes");
INSERT INTO `wp_options` VALUES("165436", "smush-in-progress-2185", "1", "yes");
INSERT INTO `wp_options` VALUES("165452", "smush-in-progress-2169", "1", "yes");
INSERT INTO `wp_options` VALUES("165462", "smush-in-progress-2145", "1", "yes");
INSERT INTO `wp_options` VALUES("165471", "smush-in-progress-2144", "1", "yes");
INSERT INTO `wp_options` VALUES("165481", "smush-in-progress-2143", "1", "yes");
INSERT INTO `wp_options` VALUES("165490", "smush-in-progress-1998", "1", "yes");
INSERT INTO `wp_options` VALUES("165500", "smush-in-progress-1996", "1", "yes");
INSERT INTO `wp_options` VALUES("165509", "smush-in-progress-1995", "1", "yes");
INSERT INTO `wp_options` VALUES("165518", "smush-in-progress-1994", "1", "yes");
INSERT INTO `wp_options` VALUES("165527", "smush-in-progress-1993", "1", "yes");
INSERT INTO `wp_options` VALUES("165536", "smush-in-progress-1972", "1", "yes");
INSERT INTO `wp_options` VALUES("165544", "smush-in-progress-1964", "1", "yes");
INSERT INTO `wp_options` VALUES("165552", "smush-in-progress-1949", "1", "yes");
INSERT INTO `wp_options` VALUES("165561", "smush-in-progress-1946", "1", "yes");
INSERT INTO `wp_options` VALUES("165571", "smush-in-progress-1942", "1", "yes");
INSERT INTO `wp_options` VALUES("165580", "smush-in-progress-1921", "1", "yes");
INSERT INTO `wp_options` VALUES("165590", "smush-in-progress-1919", "1", "yes");
INSERT INTO `wp_options` VALUES("165599", "smush-in-progress-1917", "1", "yes");
INSERT INTO `wp_options` VALUES("165609", "smush-in-progress-1916", "1", "yes");
INSERT INTO `wp_options` VALUES("165618", "smush-in-progress-1887", "1", "yes");
INSERT INTO `wp_options` VALUES("165627", "smush-in-progress-1886", "1", "yes");
INSERT INTO `wp_options` VALUES("165640", "smush-in-progress-1885", "1", "yes");
INSERT INTO `wp_options` VALUES("165656", "smush-in-progress-530", "1", "yes");
INSERT INTO `wp_options` VALUES("165664", "smush-in-progress-529", "1", "yes");
INSERT INTO `wp_options` VALUES("165673", "smush-in-progress-528", "1", "yes");
INSERT INTO `wp_options` VALUES("165683", "smush-in-progress-527", "1", "yes");
INSERT INTO `wp_options` VALUES("165692", "smush-in-progress-524", "1", "yes");
INSERT INTO `wp_options` VALUES("165701", "smush-in-progress-523", "1", "yes");
INSERT INTO `wp_options` VALUES("165709", "smush-in-progress-512", "1", "yes");
INSERT INTO `wp_options` VALUES("165742", "smush-in-progress-396", "1", "yes");
INSERT INTO `wp_options` VALUES("165754", "smush-in-progress-394", "1", "yes");
INSERT INTO `wp_options` VALUES("165763", "smush-in-progress-387", "1", "yes");
INSERT INTO `wp_options` VALUES("165772", "smush-in-progress-386", "1", "yes");
INSERT INTO `wp_options` VALUES("165781", "smush-in-progress-383", "1", "yes");
INSERT INTO `wp_options` VALUES("165793", "smush-in-progress-380", "1", "yes");
INSERT INTO `wp_options` VALUES("165808", "smush-in-progress-370", "1", "yes");
INSERT INTO `wp_options` VALUES("165862", "smush-in-progress-338", "1", "yes");
INSERT INTO `wp_options` VALUES("165877", "smush-in-progress-335", "1", "yes");
INSERT INTO `wp_options` VALUES("165886", "smush-in-progress-334", "1", "yes");
INSERT INTO `wp_options` VALUES("165908", "smush-in-progress-319", "1", "yes");
INSERT INTO `wp_options` VALUES("165916", "smush-in-progress-318", "1", "yes");
INSERT INTO `wp_options` VALUES("165924", "smush-in-progress-315", "1", "yes");
INSERT INTO `wp_options` VALUES("165933", "smush-in-progress-314", "1", "yes");
INSERT INTO `wp_options` VALUES("165942", "smush-in-progress-311", "1", "yes");
INSERT INTO `wp_options` VALUES("165951", "smush-in-progress-310", "1", "yes");
INSERT INTO `wp_options` VALUES("165961", "smush-in-progress-308", "1", "yes");
INSERT INTO `wp_options` VALUES("165971", "smush-in-progress-307", "1", "yes");
INSERT INTO `wp_options` VALUES("165980", "smush-in-progress-304", "1", "yes");
INSERT INTO `wp_options` VALUES("165989", "smush-in-progress-303", "1", "yes");
INSERT INTO `wp_options` VALUES("273388", "mc4wp", "a:6:{s:19:\"grecaptcha_site_key\";s:0:\"\";s:21:\"grecaptcha_secret_key\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1571058547;}", "yes");
INSERT INTO `wp_options` VALUES("282174", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("318933", "admin_email_lifespan", "1778398882", "yes");
INSERT INTO `wp_options` VALUES("365334", "yith_wcwl_color_add_to_wishlist", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("365335", "yith_wcwl_color_add_to_cart", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#4F4F4F\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#4F4F4F\";}", "yes");
INSERT INTO `wp_options` VALUES("365336", "yith_wcwl_color_button_style_1", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#4F4F4F\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#4F4F4F\";}", "yes");
INSERT INTO `wp_options` VALUES("365337", "yith_wcwl_color_button_style_2", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#4F4F4F\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#4F4F4F\";}", "yes");
INSERT INTO `wp_options` VALUES("365338", "yith_wcwl_color_wishlist_table", "a:3:{s:10:\"background\";s:7:\"#FFFFFF\";s:4:\"text\";s:7:\"#6d6c6c\";s:6:\"border\";s:7:\"#FFFFFF\";}", "yes");
INSERT INTO `wp_options` VALUES("365339", "yith_wcwl_add_to_wishlist_style", "link", "yes");
INSERT INTO `wp_options` VALUES("365340", "yith_wcwl_add_to_cart_style", "button_default", "yes");
INSERT INTO `wp_options` VALUES("365341", "yith_wcwl_ask_an_estimate_style", "link", "yes");
INSERT INTO `wp_options` VALUES("365342", "yith_wcwl_rounded_corners_radius", "16", "yes");
INSERT INTO `wp_options` VALUES("365343", "yith_wcwl_add_to_cart_rounded_corners_radius", "16", "yes");
INSERT INTO `wp_options` VALUES("365344", "yith_wcwl_ask_an_estimate_rounded_corners_radius", "16", "yes");
INSERT INTO `wp_options` VALUES("365345", "yith_wcwl_version", "3.0.3", "yes");
INSERT INTO `wp_options` VALUES("365346", "yith_wcwl_db_version", "3.0.0", "yes");
INSERT INTO `wp_options` VALUES("365349", "yith_plugin_fw_promo_2019_bis", "1", "yes");
INSERT INTO `wp_options` VALUES("365352", "persian_woocommerce_dismissed_notices", "a:5:{i:0;b:0;i:1;s:14:\"checkout-tools\";i:2;s:3:\"pws\";i:3;s:15:\"tapin-dashboard\";i:4;s:12:\"persian-date\";}", "yes");
INSERT INTO `wp_options` VALUES("365590", "elementor_version", "3.33.0", "yes");
INSERT INTO `wp_options` VALUES("365593", "element_pack_active_modules", "", "yes");
INSERT INTO `wp_options` VALUES("365594", "element_pack_third_party_widget", "", "yes");
INSERT INTO `wp_options` VALUES("365595", "element_pack_elementor_extend", "", "yes");
INSERT INTO `wp_options` VALUES("365596", "element_pack_api_settings", "", "yes");
INSERT INTO `wp_options` VALUES("365604", "_elementor_installed_time", "1576583366", "yes");
INSERT INTO `wp_options` VALUES("365606", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:21:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:26:\"minimum_hello_plus_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:21:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:26:\"minimum_hello_plus_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:21:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:26:\"minimum_hello_plus_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:21:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:26:\"minimum_hello_plus_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("365607", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("419253", "element_pack_license_key", "", "yes");
INSERT INTO `wp_options` VALUES("470110", "ultnofo_item", "a:2:{s:17:\"nofollow_comments\";i:1;s:17:\"nofollow_blogroll\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("485767", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"1Lma2LNBjgs65xByhgdfSRhCKYeyCWg6\";}", "yes");
INSERT INTO `wp_options` VALUES("508726", "recovery_mode_email_last_sent", "1733057438", "yes");
INSERT INTO `wp_options` VALUES("508827", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("508832", "_transient_product_query-transient-version", "1707912644", "yes");
INSERT INTO `wp_options` VALUES("508848", "_transient_as_comment_count", "O:8:\"stdClass\":7:{s:9:\"moderated\";s:1:\"1\";s:8:\"approved\";s:1:\"1\";s:4:\"spam\";s:1:\"1\";s:14:\"total_comments\";i:3;s:3:\"all\";i:3;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("508859", "_site_transient_timeout_yith_promo_message", "3168502508", "no");
INSERT INTO `wp_options` VALUES("508860", "_site_transient_yith_promo_message", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Default border color: #acc327 -->\n<!-- Default background color: #ecf7ed -->\n\n<promotions>\n    <expiry_date>2019-12-10</expiry_date>\n    <promo>\n        <promo_id>yithblackfriday2019</promo_id>\n        <title><![CDATA[<strong>YITH Black Friday</strong>]]></title>\n        <description><![CDATA[\n            Don\'t miss our <strong>30% discount</strong> on all our products! No coupon needed in cart. Valid from <strong>28th November</strong> to <strong>2nd December</strong>.\n        ]]></description>\n        <link>\n            <label>Get your deals now!</label>\n            <url><![CDATA[https://yithemes.com]]></url>\n        </link>\n        <style>\n            <image_bg_color>#272121</image_bg_color>\n            <border_color>#272121</border_color>\n            <background_color>#ffffff</background_color>\n        </style>\n        <start_date>2019-11-27 23:59:59</start_date>\n        <end_date>2019-12-03 08:00:00</end_date>\n    </promo>\n</promotions>", "no");
INSERT INTO `wp_options` VALUES("508874", "wpmudev_recommended_plugins_registered", "a:1:{s:23:\"wp-smushit/wp-smush.php\";a:1:{s:13:\"registered_at\";i:1584202435;}}", "no");
INSERT INTO `wp_options` VALUES("508879", "action_scheduler_hybrid_store_demarkation", "2868", "yes");
INSERT INTO `wp_options` VALUES("508880", "schema-ActionScheduler_StoreSchema", "8.0.1762846997", "yes");
INSERT INTO `wp_options` VALUES("508881", "schema-ActionScheduler_LoggerSchema", "3.0.1636291495", "yes");
INSERT INTO `wp_options` VALUES("508882", "woocommerce_onboarding_opt_in", "no", "yes");
INSERT INTO `wp_options` VALUES("508885", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("508887", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("508893", "woocommerce_admin_last_orders_milestone", "1", "yes");
INSERT INTO `wp_options` VALUES("508901", "_transient_product-transient-version", "1681719366", "yes");
INSERT INTO `wp_options` VALUES("508919", "woocommerce_admin_install_timestamp", "1591015399", "yes");
INSERT INTO `wp_options` VALUES("508922", "action_scheduler_lock_async-request-runner", "6912ec0ca07d35.63518616|1762847816", "yes");
INSERT INTO `wp_options` VALUES("509156", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-b.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-b.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("509210", "rs-templates-counter", "27", "off");
INSERT INTO `wp_options` VALUES("510021", "_transient_shipping-transient-version", "1585483389", "yes");
INSERT INTO `wp_options` VALUES("510872", "_transient_woocommerce_reports-transient-version", "1757428557", "yes");
INSERT INTO `wp_options` VALUES("510882", "_transient_orders-transient-version", "1664453332", "yes");
INSERT INTO `wp_options` VALUES("511176", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":5,\"critical\":1}", "yes");
INSERT INTO `wp_options` VALUES("513332", "PW_Options", "a:9:{s:14:\"allowed_states\";s:3:\"all\";s:18:\"enable_iran_cities\";s:3:\"yes\";s:15:\"flip_state_city\";s:3:\"yes\";s:15:\"fix_load_states\";s:2:\"no\";s:27:\"fix_postcode_persian_number\";s:2:\"no\";s:19:\"postcode_validation\";s:2:\"no\";s:24:\"fix_phone_persian_number\";s:2:\"no\";s:16:\"phone_validation\";s:2:\"no\";s:27:\"remove_extra_field_physical\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("514749", "woocommerce_sales_record_date", "2021-08-14", "yes");
INSERT INTO `wp_options` VALUES("514750", "woocommerce_sales_record_amount", "5317", "yes");
INSERT INTO `wp_options` VALUES("529286", "yith_wcwl_variation_show", "no", "yes");
INSERT INTO `wp_options` VALUES("529287", "yith_wcwl_show_remove", "yes", "yes");
INSERT INTO `wp_options` VALUES("529288", "yith_wcwl_enable_share", "yes", "yes");
INSERT INTO `wp_options` VALUES("529289", "yith_wcwl_share_whatsapp", "yes", "yes");
INSERT INTO `wp_options` VALUES("529290", "yith_wcwl_share_url", "no", "yes");
INSERT INTO `wp_options` VALUES("529291", "yith_wcwl_add_to_cart_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("529292", "yith_wcwl_color_headers_background", "#F4F4F4", "yes");
INSERT INTO `wp_options` VALUES("529293", "yith_wcwl_color_share_button", "a:2:{s:5:\"color\";s:7:\"#FFFFFF\";s:11:\"color_hover\";s:7:\"#FFFFFF\";}", "yes");
INSERT INTO `wp_options` VALUES("529294", "yith_wcwl_fb_button_icon", "fa-facebook", "yes");
INSERT INTO `wp_options` VALUES("529295", "yith_wcwl_fb_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("529296", "yith_wcwl_color_fb_button", "a:2:{s:10:\"background\";s:7:\"#39599E\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "yes");
INSERT INTO `wp_options` VALUES("529297", "yith_wcwl_tw_button_icon", "fa-twitter", "yes");
INSERT INTO `wp_options` VALUES("529298", "yith_wcwl_tw_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("529299", "yith_wcwl_color_tw_button", "a:2:{s:10:\"background\";s:7:\"#45AFE2\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "yes");
INSERT INTO `wp_options` VALUES("529300", "yith_wcwl_pr_button_icon", "fa-pinterest", "yes");
INSERT INTO `wp_options` VALUES("529301", "yith_wcwl_pr_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("529302", "yith_wcwl_color_pr_button", "a:2:{s:10:\"background\";s:7:\"#AB2E31\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "yes");
INSERT INTO `wp_options` VALUES("529303", "yith_wcwl_em_button_icon", "fa-envelope-o", "yes");
INSERT INTO `wp_options` VALUES("529304", "yith_wcwl_em_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("529305", "yith_wcwl_color_em_button", "a:2:{s:10:\"background\";s:7:\"#FBB102\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "yes");
INSERT INTO `wp_options` VALUES("529306", "yith_wcwl_wa_button_icon", "fa-whatsapp", "yes");
INSERT INTO `wp_options` VALUES("529307", "yith_wcwl_wa_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("529308", "yith_wcwl_color_wa_button", "a:2:{s:10:\"background\";s:7:\"#00A901\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "yes");
INSERT INTO `wp_options` VALUES("529949", "yith_wcact_db_version", "1.0.0", "yes");
INSERT INTO `wp_options` VALUES("529950", "widget_yith_woocommerce_auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("529954", "yith_wcact_show_auctions_shop_page", "yes", "yes");
INSERT INTO `wp_options` VALUES("529955", "yith_wcact_hide_auctions_out_of_stock", "no", "yes");
INSERT INTO `wp_options` VALUES("529956", "yith_wcact_hide_auctions_closed", "no", "yes");
INSERT INTO `wp_options` VALUES("529957", "yith_wcact_hide_auctions_not_started", "no", "yes");
INSERT INTO `wp_options` VALUES("529958", "yith_wcact_settings_tab_auction_show_add_to_cart_in_auction_product", "no", "yes");
INSERT INTO `wp_options` VALUES("529959", "yith_wcact_settings_tab_auction_show_name", "no", "yes");
INSERT INTO `wp_options` VALUES("529960", "yith_wcact_settings_tab_auction_show_button_plus_minus", "no", "yes");
INSERT INTO `wp_options` VALUES("529961", "yith_wcact_settings_tab_auction_show_button_pay_now", "yes", "yes");
INSERT INTO `wp_options` VALUES("529962", "yith_wcact_settings_date_format", "j/n/Y h:i:s", "yes");
INSERT INTO `wp_options` VALUES("529963", "yith_wcact_settings_cron_auction_send_emails", "no", "yes");
INSERT INTO `wp_options` VALUES("529964", "yith_wcact_settings_cron_auction_number_days", "1", "yes");
INSERT INTO `wp_options` VALUES("529965", "yith_wcact_settings_cron_auction_type_numbers", "days", "yes");
INSERT INTO `wp_options` VALUES("529966", "yith_wcact_settings_tab_auction_allow_subscribe", "no", "yes");
INSERT INTO `wp_options` VALUES("529967", "yith_wcact_settings_tab_auction_no_winner_email", "no", "yes");
INSERT INTO `wp_options` VALUES("529968", "yith_wcact_settings_automatic_reschedule_auctions_number", "0", "yes");
INSERT INTO `wp_options` VALUES("529969", "yith_wcact_settings_automatic_reschedule_auctions_unit", "days", "yes");
INSERT INTO `wp_options` VALUES("529970", "yith_wcact_settings_overtime_option", "0", "yes");
INSERT INTO `wp_options` VALUES("529971", "yith_wcact_settings_overtime", "0", "yes");
INSERT INTO `wp_options` VALUES("529972", "yith_wcact_settings_live_auction_my_auctions", "0", "yes");
INSERT INTO `wp_options` VALUES("529973", "yith_wcact_settings_live_auction_product_page", "0", "yes");
INSERT INTO `wp_options` VALUES("530056", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("530124", "simple_auctions_finished_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("530125", "simple_auctions_future_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("530126", "simple_auctions_dont_mix_shop", "yes", "yes");
INSERT INTO `wp_options` VALUES("530127", "simple_auctions_countdown_format", "yowdHMS", "yes");
INSERT INTO `wp_options` VALUES("530128", "simple_auctions_live_check", "yes", "yes");
INSERT INTO `wp_options` VALUES("530129", "simple_auctions_live_check_interval", "1", "yes");
INSERT INTO `wp_options` VALUES("530130", "simple_auctions_curent_bidder_can_bid", "no", "yes");
INSERT INTO `wp_options` VALUES("530131", "simple_auctions_database_version", "1.2.1", "yes");
INSERT INTO `wp_options` VALUES("530132", "simple_auctions_version", "1.2.37", "yes");
INSERT INTO `wp_options` VALUES("530133", "widget_recent_auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530134", "widget_featured-auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530135", "widget_woocommerce_random_auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530136", "widget_recently_viewed_auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530137", "widget_ending_soon_auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530138", "widget_my-auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530139", "widget_woocommerce_auction_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530140", "widget_future_auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530141", "widget_watchlist-auctions", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("530156", "simple_auction_last_activity", "1592918976", "yes");
INSERT INTO `wp_options` VALUES("542764", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("542774", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("542796", "duplicator_new_storage_position", "1", "yes");
INSERT INTO `wp_options` VALUES("549140", "yith-woocompare-page-id", "2971", "yes");
INSERT INTO `wp_options` VALUES("551677", "ywctm_admin_view", "yes", "yes");
INSERT INTO `wp_options` VALUES("551678", "ywctm_disable_shop", "yes", "yes");
INSERT INTO `wp_options` VALUES("551679", "ywctm_hide_variations", "no", "yes");
INSERT INTO `wp_options` VALUES("551689", "ywctm_hide_add_to_cart_settings", "a:3:{s:6:\"action\";s:4:\"hide\";s:5:\"where\";s:3:\"all\";s:5:\"items\";s:3:\"all\";}", "yes");
INSERT INTO `wp_options` VALUES("565860", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("565861", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("565862", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("565863", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("589505", "wpb_js_google_fonts_subsets", "a:1:{i:0;s:5:\"latin\";}", "yes");
INSERT INTO `wp_options` VALUES("589506", "wpb_js_gutenberg_disable", "1", "yes");
INSERT INTO `wp_options` VALUES("589507", "wpb_js_default_template_post_type", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("591065", "rs-addons-counter", "1", "yes");
INSERT INTO `wp_options` VALUES("628656", "woocommerce_version", "10.3.4", "yes");
INSERT INTO `wp_options` VALUES("628665", "wc_admin_note_home_screen_feedback_homescreen_accessed", "1603033264", "yes");
INSERT INTO `wp_options` VALUES("628674", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":3:{s:22:\"there_were_no_products\";b:0;s:22:\"there_are_now_products\";b:1;s:17:\"new_product_count\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("628688", "wp-smush-show_upgrade_modal", "1", "no");
INSERT INTO `wp_options` VALUES("636074", "elementor_log", "a:43:{s:32:\"5cce0680db0861a118b49ef799728deb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-03-11 23:36:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.18.3\";s:2:\"to\";s:6:\"3.20.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-03-11 23:36:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.18.3\";s:2:\"to\";s:6:\"3.20.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"63810c4ec8317a7e87b5e8f6ce06578f\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2024-04-08 13:25:59\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:54:\"Attempt to read property &quot;post_type&quot; on null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:290;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-03-12 16:08:23\";i:1;s:19:\"2025-03-12 16:10:26\";i:2;s:19:\"2025-03-12 16:12:24\";i:3;s:19:\"2025-03-12 16:14:26\";i:4;s:19:\"2025-03-12 16:16:26\";i:5;s:19:\"2025-03-12 16:18:24\";i:6;s:19:\"2025-03-12 16:20:27\";i:7;s:19:\"2025-03-12 16:22:23\";i:8;s:19:\"2025-03-12 16:24:26\";i:9;s:19:\"2025-03-12 16:26:24\";i:10;s:19:\"2025-03-12 16:28:26\";i:11;s:19:\"2025-03-12 16:30:25\";i:12;s:19:\"2025-03-12 16:32:25\";i:13;s:19:\"2025-03-12 16:34:26\";i:14;s:19:\"2025-03-12 16:36:25\";i:15;s:19:\"2025-03-12 16:38:25\";i:16;s:19:\"2025-03-12 16:40:28\";i:17;s:19:\"2025-03-12 16:42:26\";i:18;s:19:\"2025-03-12 16:44:26\";i:19;s:19:\"2025-03-12 16:46:26\";i:20;s:19:\"2025-03-12 16:48:26\";i:21;s:19:\"2025-03-12 16:50:29\";i:22;s:19:\"2025-03-12 16:52:28\";i:23;s:19:\"2025-03-12 16:54:27\";i:24;s:19:\"2025-03-12 16:56:29\";i:25;s:19:\"2025-03-12 16:58:27\";i:26;s:19:\"2025-03-12 17:00:27\";i:27;s:19:\"2025-03-12 17:02:29\";i:28;s:19:\"2025-03-12 17:04:27\";i:29;s:19:\"2025-03-12 17:06:27\";i:30;s:19:\"2025-03-12 17:08:23\";i:31;s:19:\"2025-04-23 09:59:13\";i:32;s:19:\"2025-04-23 10:01:22\";i:33;s:19:\"2025-04-23 10:03:23\";i:34;s:19:\"2025-04-23 10:05:24\";i:35;s:19:\"2025-04-23 10:06:06\";i:36;s:19:\"2025-04-23 10:06:22\";i:37;s:19:\"2025-04-23 10:06:23\";i:38;s:19:\"2025-04-23 10:07:23\";i:39;s:19:\"2025-04-23 14:05:09\";i:40;s:19:\"2025-04-29 11:50:17\";i:41;s:19:\"2025-04-29 11:51:26\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:44:\"Attempt to read property \"post_type\" on null\";s:4:\"file\";s:142:\"/home2/mimwpcom/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/plugins/elementor/includes/template-library/sources/local.php\";s:4:\"line\";i:1065;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:142:\"/home2/mimwpcom/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/plugins/elementor/includes/template-library/sources/local.php\";s:7:\"\0*\0line\";i:1065;}s:32:\"40ff1e9acb2c2dc349c9df008a56dd50\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-04-08 13:28:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-04-08 13:28:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"02f06a1835938e80de9380a54a319f69\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-04-08 13:28:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-04-08 13:28:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"7611f4a9ccb6fa472cd64fb67a0192b5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-04-08 13:28:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-04-08 13:28:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"99b4e3e3105bdaf7c545740b1eb0c5ca\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-04-08 13:28:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.20.0\";s:2:\"to\";s:6:\"3.20.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-04-08 13:28:10\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.20.0\";s:2:\"to\";s:6:\"3.20.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"344bfec001ac357f9b047ad83e57d79c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-06-18 13:55:04\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.20.3\";s:2:\"to\";s:6:\"3.22.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-06-18 13:55:04\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.20.3\";s:2:\"to\";s:6:\"3.22.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"bfe51b652ab5b07040b7b54d3aaf6d25\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-06-18 13:55:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-06-18 13:55:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"5506554b40867b7839d39efd0eabbd4e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-06-18 13:55:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-06-18 13:55:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"1630c88d1a7f4a26ee35877e0b542f73\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-06-18 13:55:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-06-18 13:55:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c8b9911c8c0dd9fd7e948106a2a33529\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-06-18 13:55:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.20.3\";s:2:\"to\";s:6:\"3.22.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-06-18 13:55:05\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.20.3\";s:2:\"to\";s:6:\"3.22.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ec3f0023cd9e13f30b6ee655f1b6e18f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-07-23 10:46:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.22.1\";s:2:\"to\";s:6:\"3.23.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-07-23 10:46:08\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.22.1\";s:2:\"to\";s:6:\"3.23.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"3d5267c00812bbb01f3cab70781d8f4a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-07-23 10:46:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-07-23 10:46:08\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"dfd0c7145a3a5af0b99bc1145536b29c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-07-23 10:46:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-07-23 10:46:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"2420e6d84393872dea36b364816df468\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-07-23 10:46:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-07-23 10:46:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"aa93110a225eec7be6610b9b4ef88b40\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-07-23 10:46:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.22.1\";s:2:\"to\";s:6:\"3.23.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-07-23 10:46:09\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.22.1\";s:2:\"to\";s:6:\"3.23.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1fc5347454cfbe424365719d534e05f4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-08-28 10:07:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.23.1\";s:2:\"to\";s:6:\"3.23.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-08-28 10:07:43\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.23.1\";s:2:\"to\";s:6:\"3.23.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6cb307c982f4f9e816f7b6e0a0fc5407\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-08-28 10:07:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-08-28 10:07:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a689bb320ec63ee06ee655b1683009fd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-08-28 10:07:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-08-28 10:07:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"925cc3a74643b49843aec46bb1e3063a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-08-28 10:07:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-08-28 10:07:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"d81c8a7ef1fd5caec982a22a099f647d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-08-28 10:07:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.23.1\";s:2:\"to\";s:6:\"3.23.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-08-28 10:07:44\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.23.1\";s:2:\"to\";s:6:\"3.23.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"cebd7c84d240613a2ae0fb5c2a464c64\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 16:39:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.23.4\";s:2:\"to\";s:7:\"3.25.10\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 16:39:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.23.4\";s:2:\"to\";s:7:\"3.25.10\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"13c528c7d0f07734b9bde3fd140a50ca\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 16:39:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 16:39:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"091b2830036f9db8fea462977d378cfe\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 16:39:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 16:39:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"e2b928ae0fd32621f45c25072fb8cc6d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 16:39:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 16:39:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"d41daadeb729f910afa887efc5f40f14\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-01 16:39:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.23.4\";s:2:\"to\";s:7:\"3.25.10\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-01 16:39:46\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.23.4\";s:2:\"to\";s:7:\"3.25.10\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"90421059dffc295e46baf7adb5f4c439\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-03 15:18:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:7:\"3.25.10\";s:2:\"to\";s:6:\"3.26.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 15:18:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:7:\"3.25.10\";s:2:\"to\";s:6:\"3.26.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8ad3d1bdbc35096be52ca455456084f9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-03 15:18:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 15:18:21\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f615f7d02dbb4e8b6c0782741776d117\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-03 15:18:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 15:18:21\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"0c4585ef2a7f6da6ed2c36d631f64a0b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-03 15:18:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 15:18:21\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"a0a7849e3169e0bd95491f83d5416d86\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-03 15:18:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 15:18:21\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"d044cd98a2598d310a5ee7bcc3769fb4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-03 15:18:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 15:18:21\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c533b738b7e10b8dc3758171ea8b46dd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-03 15:18:21\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:7:\"3.25.10\";s:2:\"to\";s:6:\"3.26.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-03 15:18:21\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:7:\"3.25.10\";s:2:\"to\";s:6:\"3.26.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"24402803bbdbe3ff29ecba5b05404119\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 11:44:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 11:44:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7e668304db9792dcdae33721c0fb5ae1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 11:44:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 11:44:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"31c3265f718fb96c270a0181331037b8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 11:44:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 11:44:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"072565ed4264149f5267e00c4837ff72\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 11:44:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 11:44:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"0fbef64974abcbafd972c9c15e9f1e67\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 11:44:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 11:44:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"dc9e80c204cbf0e4364c9dac0445c8eb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 11:13:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.33.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 11:13:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.33.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a19eb547378a73e6e02ef247fa882e58\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 11:13:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 11:13:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"e3667c15cbd815a19b14510d7ec4f394\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 11:13:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 11:13:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"cccdd7f94e41f5a370bbfd82b7ae395b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 11:13:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 11:13:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"cd94bc8df60ddbf6884191b1e42c9a74\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 11:13:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.33.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 11:13:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.33.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("636077", "elementor_active_kit", "2996", "yes");
INSERT INTO `wp_options` VALUES("636081", "elementor_install_history", "a:45:{s:6:\"3.0.12\";i:1603465557;s:6:\"3.0.14\";i:1606654278;s:6:\"3.0.15\";i:1608917667;s:6:\"3.0.16\";i:1610205262;s:5:\"3.1.0\";i:1611689560;s:5:\"3.1.1\";i:1613030592;s:5:\"3.1.3\";i:1615115433;s:5:\"3.1.4\";i:1616525262;s:5:\"3.2.1\";i:1619202999;s:5:\"3.2.3\";i:1620717288;s:5:\"3.2.4\";i:1622902724;s:5:\"3.2.5\";i:1623867441;s:5:\"3.3.1\";i:1627302751;s:5:\"3.4.3\";i:1631103676;s:5:\"3.4.7\";i:1636291769;s:5:\"3.5.2\";i:1640268534;s:5:\"3.5.3\";i:1642687679;s:5:\"3.5.4\";i:1643701701;s:5:\"3.5.5\";i:1645624399;s:5:\"3.5.6\";i:1647019182;s:5:\"3.6.2\";i:1649600887;s:5:\"3.6.5\";i:1652525550;s:5:\"3.6.7\";i:1658587735;s:5:\"3.7.6\";i:1663445687;s:5:\"3.7.8\";i:1666643873;s:5:\"3.8.0\";i:1667895164;s:5:\"3.8.1\";i:1669563009;s:5:\"3.9.2\";i:1671827757;s:6:\"3.10.0\";i:1673903013;s:6:\"3.11.2\";i:1677310471;s:6:\"3.12.1\";i:1680728682;s:6:\"3.13.4\";i:1686577175;s:6:\"3.14.1\";i:1689964926;s:6:\"3.16.5\";i:1697024422;s:6:\"3.17.2\";i:1699078926;s:6:\"3.18.3\";i:1705991993;s:6:\"3.20.0\";i:1710187571;s:6:\"3.20.3\";i:1712570290;s:6:\"3.22.1\";i:1718706305;s:6:\"3.23.1\";i:1721718969;s:6:\"3.23.4\";i:1724827064;s:7:\"3.25.10\";i:1733058586;s:6:\"3.26.3\";i:1735904901;s:6:\"3.28.4\";i:1745914485;s:6:\"3.33.0\";i:1762846997;}", "yes");
INSERT INTO `wp_options` VALUES("638836", "new_admin_email", "mimwp2@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("638837", "WPLANG_ADMIN", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("691367", "woocommerce_db_version", "10.3.4", "yes");
INSERT INTO `wp_options` VALUES("708494", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("708495", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("708496", "auto_update_core_major", "unset", "yes");
INSERT INTO `wp_options` VALUES("718519", "wpdg_specific_version_name", "5.5.3", "yes");
INSERT INTO `wp_options` VALUES("718520", "wpdg_download_url", "", "yes");
INSERT INTO `wp_options` VALUES("718521", "wpdg_edit_download_url", "", "yes");
INSERT INTO `wp_options` VALUES("729110", "secret_key", ":gTfVdn/,Heqm--@-{9$nFpzcaM.UUKA#C.ds&u5dD=q8g NC!Q~7p 3o6x$Z}2v", "no");
INSERT INTO `wp_options` VALUES("734464", "dig_hide_countrycode", "0", "yes");
INSERT INTO `wp_options` VALUES("734465", "digits_db_migrate7010", "1", "yes");
INSERT INTO `wp_options` VALUES("734466", "dig_reg_custom_field_data_backup", "e30=", "yes");
INSERT INTO `wp_options` VALUES("734467", "dig_reg_lb_data_backup", "", "yes");
INSERT INTO `wp_options` VALUES("734468", "dig_reg_custom_field_data", "W10=", "yes");
INSERT INTO `wp_options` VALUES("734469", "digits_do_activation_redirect", "1", "yes");
INSERT INTO `wp_options` VALUES("734475", "external_updates-digits", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1609575878;s:14:\"checkedVersion\";s:5:\"7.4.2\";s:6:\"update\";O:8:\"stdClass\":10:{s:4:\"slug\";s:6:\"digits\";s:7:\"version\";s:7:\"7.4.2.2\";s:12:\"download_url\";N;s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:29:\"https://digits.unitedover.com\";s:6:\"tested\";s:7:\"5.6.999\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:2:{s:2:\"1x\";s:48:\"https://unitedover.com/images/digits/icon128.png\";s:2:\"2x\";s:48:\"https://unitedover.com/images/digits/icon256.png\";}s:8:\"filename\";s:16:\"digits/digit.php\";}s:11:\"updateClass\";s:22:\"Puc_v4p6_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}", "no");
INSERT INTO `wp_options` VALUES("734476", "digits_activation_time", "1609575878", "yes");
INSERT INTO `wp_options` VALUES("734477", "digits_addon_update_page_redirect", "a:2:{s:4:\"time\";i:1609575878;s:7:\"version\";s:5:\"7.4.2\";}", "yes");
INSERT INTO `wp_options` VALUES("734565", "digits_sameorigin_protection", "0", "yes");
INSERT INTO `wp_options` VALUES("734566", "dig_login_rememberme", "1", "yes");
INSERT INTO `wp_options` VALUES("734567", "dig_login_fields", "a:6:{s:18:\"dig_login_username\";s:1:\"1\";s:15:\"dig_login_email\";s:1:\"1\";s:22:\"dig_login_mobilenumber\";s:1:\"1\";s:13:\"dig_login_otp\";s:1:\"1\";s:18:\"dig_login_password\";s:1:\"1\";s:17:\"dig_login_captcha\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("734568", "dig_reg_fields", "a:5:{s:12:\"dig_reg_name\";s:1:\"1\";s:13:\"dig_reg_uname\";s:1:\"0\";s:13:\"dig_reg_email\";s:1:\"1\";s:20:\"dig_reg_mobilenumber\";s:1:\"1\";s:16:\"dig_reg_password\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("734569", "dig_sortorder", "", "yes");
INSERT INTO `wp_options` VALUES("734570", "digit_tapp", "13", "yes");
INSERT INTO `wp_options` VALUES("734571", "digit_api", "a:3:{s:5:\"appid\";s:0:\"\";s:9:\"appsecret\";s:0:\"\";s:15:\"accountkit_type\";s:5:\"modal\";}", "yes");
INSERT INTO `wp_options` VALUES("734572", "digit_twilio_api", "a:3:{s:9:\"twiliosid\";s:0:\"\";s:11:\"twiliotoken\";s:0:\"\";s:14:\"twiliosenderid\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734573", "digit_msg91_api", "a:3:{s:12:\"msg91authkey\";s:0:\"\";s:13:\"msg91senderid\";s:0:\"\";s:10:\"msg91route\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("734574", "digit_yunpianapi", "", "yes");
INSERT INTO `wp_options` VALUES("734575", "digit_firebase", "a:1:{s:6:\"config\";s:360:\"const firebaseConfig = {\r\n  apiKey: \\\"AIzaSyAEIXpLHHMOkchI2UBy5Qw8k_X_x_EeVM4\\\",\r\n  authDomain: \\\"porto-bb94f.firebaseapp.com\\\",\r\n  databaseURL: \\\"https://porto-bb94f.firebaseio.com\\\",\r\n  projectId: \\\"porto-bb94f\\\",\r\n  storageBucket: \\\"porto-bb94f.appspot.com\\\",\r\n  messagingSenderId: \\\"23702322297\\\",\r\n  appId: \\\"1:23702322297:web:426e6f2e21c35c785228a8\\\"\r\n};\";}", "yes");
INSERT INTO `wp_options` VALUES("734576", "digit_facebook", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("734577", "digit_twilio", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("734578", "digit_msg91", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("734579", "digit_messagebird", "a:2:{s:9:\"accesskey\";s:0:\"\";s:10:\"originator\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734580", "digit_plivo", "a:3:{s:7:\"auth_id\";s:0:\"\";s:10:\"auth_token\";s:0:\"\";s:9:\"sender_id\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734581", "digit_clicksend", "a:3:{s:11:\"apiusername\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734582", "digit_infobip", "a:3:{s:8:\"base_url\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734583", "digit_amazon_sns", "a:4:{s:10:\"access_key\";N;s:13:\"access_secret\";N;s:6:\"region\";N;s:9:\"sender_id\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734584", "digit_amazon_pinpoint", "a:5:{s:6:\"app_id\";N;s:10:\"access_key\";N;s:13:\"access_secret\";N;s:6:\"region\";N;s:9:\"sender_id\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734585", "digit_alibaba", "a:3:{s:10:\"access_key\";N;s:13:\"access_secret\";N;s:4:\"from\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734586", "digit_alibaba_go_china", "a:5:{s:10:\"access_key\";N;s:13:\"access_secret\";N;s:4:\"from\";N;s:12:\"templatecode\";N;s:19:\"frosmsupextendcodem\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734587", "digit_clickatell", "a:2:{s:7:\"api_key\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734588", "digit_clockwork", "a:2:{s:12:\"clockworkapi\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734589", "digit_kaleyra", "a:2:{s:7:\"api_key\";s:0:\"\";s:9:\"sender_id\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734590", "digit_mobily_ws", "a:3:{s:6:\"mobile\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734591", "digit_alfa_cell", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734592", "digit_nexmo", "a:3:{s:7:\"api_key\";s:0:\"\";s:10:\"api_secret\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734593", "digit_smsapi", "a:2:{s:5:\"token\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734594", "digit_africas_talking", "a:3:{s:8:\"username\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734595", "digit_textlocal", "a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734596", "digit_unifonic", "a:2:{s:6:\"appsid\";s:0:\"\";s:8:\"senderid\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734597", "digit_melipayamak", "a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734598", "digit_adnsms", "a:2:{s:7:\"api_key\";N;s:10:\"api_secret\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734599", "digit_netgsm", "a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"from\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734600", "digit_smsc_ru", "a:3:{s:5:\"login\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734601", "digit_targetsms", "a:3:{s:5:\"login\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734602", "digit_ghasedak", "a:1:{s:7:\"api_key\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734603", "digit_farapayamak", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:4:\"from\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734604", "digit_sendinblue", "a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734605", "digit_ibulksms", "a:2:{s:8:\"auth_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734606", "digit_yunpian", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("734607", "digit_sms123", "a:1:{s:7:\"api_key\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734608", "digit_opersms", "a:2:{s:5:\"login\";N;s:8:\"password\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734609", "digit_sparrowsms", "a:2:{s:5:\"token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734610", "digit_adpdigital", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734611", "digit_spryng", "a:2:{s:12:\"bearer_token\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734612", "digit_karix", "a:3:{s:3:\"uid\";N;s:5:\"token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734613", "digit_bandwidth", "a:5:{s:3:\"uid\";s:0:\"\";s:5:\"token\";s:0:\"\";s:14:\"application_id\";s:0:\"\";s:10:\"account_id\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734614", "digit_cdyne", "a:2:{s:11:\"license_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734615", "digit_engagespark", "a:3:{s:7:\"api_key\";N;s:15:\"organization_id\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734616", "digit_kapsystem", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734617", "digit_telestax", "a:3:{s:11:\"account_sid\";N;s:10:\"auth_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734618", "digit_ttagsystems", "a:3:{s:4:\"user\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734619", "digit_wavecell", "a:3:{s:9:\"api_token\";N;s:13:\"subaccount_id\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734620", "digit_smsaero", "a:3:{s:5:\"email\";N;s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734621", "digit_gatewayapi", "a:3:{s:7:\"api_key\";N;s:10:\"api_secret\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734622", "digit_agiletelecom", "a:3:{s:8:\"sms_user\";N;s:12:\"sms_password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734623", "digit_greentext", "a:3:{s:9:\"client_id\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734624", "digit_mnotify", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734625", "digit_smsbroadcast", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734626", "digit_smsgatewayhub", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734627", "digit_thaibulksms", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734628", "digit_smscountry", "a:3:{s:4:\"user\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734629", "digit_textmagic", "a:3:{s:8:\"username\";N;s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734630", "digit_qsms", "a:3:{s:4:\"user\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734631", "digit_smsfactor", "a:2:{s:9:\"api_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734632", "digit_esms", "a:3:{s:7:\"api_key\";N;s:10:\"api_secret\";N;s:9:\"brandname\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734633", "digit_isms", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734634", "digit_textplode", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734635", "digit_routesms", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734636", "digit_skebby", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734637", "digit_sendhub", "a:2:{s:8:\"username\";N;s:7:\"api_key\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734638", "digit_proovl", "a:2:{s:4:\"user\";N;s:5:\"token\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734639", "digit_tyntec", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734640", "digit_bulksmsnigeria", "a:2:{s:9:\"api_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734641", "digit_bulksms", "a:3:{s:8:\"token_id\";N;s:12:\"token_secret\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734642", "digit_esendex", "a:4:{s:17:\"account_reference\";s:0:\"\";s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734643", "digit_websms", "a:1:{s:12:\"access_token\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734644", "digit_smsglobal", "a:3:{s:4:\"user\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734645", "digit_fortytwo", "a:2:{s:19:\"authorization_token\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734646", "digit_primotexto", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734647", "digit_spirius", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734648", "digit_experttexting", "a:4:{s:8:\"username\";N;s:8:\"password\";N;s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734649", "digit_jusibe", "a:3:{s:7:\"api_key\";N;s:5:\"token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734650", "digit_mensatek", "a:3:{s:5:\"email\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734651", "digit_speedsms", "a:2:{s:12:\"access_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734652", "digit_smsmisr", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734653", "digit_jazzcmt", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734654", "digit_moceansms", "a:3:{s:7:\"api_key\";N;s:10:\"api_secret\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734655", "digit_sendsms247", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734656", "digit_smscua", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734657", "digit_cpsms", "a:3:{s:8:\"username\";N;s:9:\"api_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734658", "digit_1s2u", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734659", "digit_textanywhere", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734660", "digit_sms77", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734661", "digit_verimor", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734662", "digit_labsmobile", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734663", "digit_unisender", "a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734664", "digit_aruba", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734665", "digit_comilio", "a:2:{s:19:\"authorization_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734666", "digit_smshosting", "a:3:{s:8:\"auth_key\";N;s:11:\"auth_secret\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734667", "digit_gateway", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734668", "digit_uwaziimobile", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734669", "digit_suresms", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734670", "digit_easysendsms", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734671", "digit_sinch", "a:3:{s:12:\"bearer_token\";s:0:\"\";s:15:\"service_plan_id\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734672", "digit_smsala", "a:3:{s:6:\"api_id\";N;s:12:\"api_password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734673", "digit_smsempresa", "a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734674", "digit_semaphore", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734675", "digit_wavy", "a:2:{s:8:\"username\";s:0:\"\";s:20:\"authentication_token\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734676", "digit_smsto", "a:2:{s:9:\"api_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734677", "digit_telnyx", "a:2:{s:14:\"profile_secret\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734678", "digit_telesign", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734679", "digit_d7networks", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734680", "digit_ismsindonesia", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734681", "digit_sendpk", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734682", "digit_mimsms", "a:4:{s:7:\"api_key\";N;s:9:\"api_token\";N;s:6:\"sender\";N;s:6:\"portal\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734683", "digit_openmarket", "a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734684", "digit_mobyt", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734685", "digit_tm4b", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734686", "digit_swiftsmsgateway", "a:2:{s:11:\"account_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734687", "digit_2factor", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734688", "digit_gupshup", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734689", "digit_digimiles", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734690", "digit_callfire", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734691", "digit_nowsms", "a:2:{s:8:\"username\";N;s:8:\"password\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734692", "digit_releans", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734693", "digit_zipwhip", "a:2:{s:8:\"username\";N;s:8:\"password\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734694", "digit_messagemedia", "a:3:{s:7:\"api_key\";N;s:10:\"api_secret\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734695", "digit_thesmsworks", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734696", "digit_mogreet", "a:4:{s:9:\"client_id\";N;s:5:\"token\";N;s:11:\"campaign_id\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734697", "digit_46elks", "a:3:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734698", "digit_slicktext", "a:2:{s:8:\"username\";N;s:11:\"private_key\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734699", "digit_smsidea", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734700", "digit_tatango", "a:2:{s:8:\"username\";N;s:8:\"password\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734701", "digit_smsedge", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734702", "digit_smsmasivos", "a:2:{s:7:\"api_key\";N;s:12:\"country_code\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734703", "digit_commzgate", "a:2:{s:8:\"username\";N;s:8:\"password\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734704", "digit_sms_ru", "a:2:{s:6:\"api_id\";N;s:4:\"from\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734705", "digit_messente", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734706", "digit_text_marketer", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:4:\"orig\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734707", "digit_spring_edge", "a:2:{s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734708", "digit_signalwire", "a:4:{s:9:\"space_url\";N;s:10:\"project_id\";N;s:9:\"api_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734709", "digit_camoo", "a:3:{s:7:\"api_key\";N;s:10:\"api_secret\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734710", "digit_cm_com", "a:2:{s:7:\"api_key\";N;s:4:\"from\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734711", "digit_ooredoo_sms", "a:3:{s:6:\"mobile\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734712", "digit_max-sms", "a:3:{s:5:\"uname\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734713", "digit_payam_resan", "a:3:{s:5:\"uname\";N;s:8:\"password\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734714", "digit_foxglove", "a:3:{s:4:\"user\";N;s:12:\"account_type\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734715", "digit_txtsync", "a:2:{s:7:\"api_key\";N;s:4:\"from\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734716", "digit_serwersms", "a:3:{s:8:\"username\";N;s:8:\"password\";N;s:4:\"from\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734717", "digit_orange_gateway", "a:2:{s:12:\"access_token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734718", "digit_msegat", "a:3:{s:8:\"username\";N;s:7:\"api_key\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734719", "digit_altiria", "a:4:{s:5:\"login\";N;s:8:\"password\";N;s:9:\"sender_id\";N;s:8:\"domainId\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734720", "digit_redsms", "a:3:{s:7:\"api_key\";N;s:5:\"login\";N;s:4:\"from\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734721", "digit_custom_gateway", "a:8:{s:11:\"gateway_url\";s:0:\"\";s:11:\"http_header\";s:0:\"\";s:11:\"http_method\";s:3:\"GET\";s:18:\"gateway_attributes\";s:0:\"\";s:14:\"send_body_data\";s:1:\"0\";s:14:\"encode_message\";s:1:\"0\";s:12:\"phone_number\";s:1:\"1\";s:9:\"sender_id\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734722", "digit_whatsappdisabled", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("734723", "digit_whatsapptwilio", "a:3:{s:11:\"account_sid\";s:0:\"\";s:10:\"auth_token\";s:0:\"\";s:14:\"whatsappnumber\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("734724", "digit_whatsappmessagebird", "a:2:{s:9:\"accesskey\";N;s:10:\"channel_id\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734725", "digit_whatsappkarix", "a:3:{s:3:\"uid\";N;s:5:\"token\";N;s:6:\"sender\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734726", "digit_whatsappgupshup", "a:2:{s:7:\"api_key\";N;s:8:\"src_name\";N;}", "yes");
INSERT INTO `wp_options` VALUES("734727", "digit_whatsapp_gateway", "-1", "yes");
INSERT INTO `wp_options` VALUES("734728", "digonlylogintrans", "ورود", "yes");
INSERT INTO `wp_options` VALUES("734729", "diglogintrans", "Login / Register", "yes");
INSERT INTO `wp_options` VALUES("734730", "digregistertrans", "ثبت نام", "yes");
INSERT INTO `wp_options` VALUES("734731", "digforgottrans", "رمز عبور خود را فراموش کرده اید؟", "yes");
INSERT INTO `wp_options` VALUES("734732", "digmyaccounttrans", "حساب کاربری من", "yes");
INSERT INTO `wp_options` VALUES("734733", "diglogouttrans", "خروج", "yes");
INSERT INTO `wp_options` VALUES("734734", "dig_messagetemplate", "Your OTP for {NAME} is {OTP}", "yes");
INSERT INTO `wp_options` VALUES("734735", "dig_whatsapp_messagetemplate", "Your OTP for {NAME} is {OTP}", "yes");
INSERT INTO `wp_options` VALUES("734736", "dig_otp_size", "6", "yes");
INSERT INTO `wp_options` VALUES("734737", "digit_custom_css", "", "yes");
INSERT INTO `wp_options` VALUES("734738", "dig_mobilein_uname", "1", "yes");
INSERT INTO `wp_options` VALUES("734739", "dig_wp_login_inte", "0", "yes");
INSERT INTO `wp_options` VALUES("734740", "dig_redirect_wc_to_dig", "0", "yes");
INSERT INTO `wp_options` VALUES("734741", "dig_mobile_no_formatting", "2", "yes");
INSERT INTO `wp_options` VALUES("734742", "digforgotpass", "1", "yes");
INSERT INTO `wp_options` VALUES("734743", "dig_overwrite_forgotpass_link", "1", "yes");
INSERT INTO `wp_options` VALUES("734744", "dig_enable_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("734745", "dig_show_asterisk", "1", "yes");
INSERT INTO `wp_options` VALUES("734746", "dig_mob_otp_resend_time", "30", "yes");
INSERT INTO `wp_options` VALUES("734747", "dig_use_strongpass", "1", "yes");
INSERT INTO `wp_options` VALUES("734748", "login_reg_success_msg", "1", "yes");
INSERT INTO `wp_options` VALUES("734749", "dig_reqfieldbilling", "0", "yes");
INSERT INTO `wp_options` VALUES("734750", "enable_createcustomeronorder", "0", "yes");
INSERT INTO `wp_options` VALUES("734751", "defaultuserrole", "customer", "yes");
INSERT INTO `wp_options` VALUES("734752", "dig_default_ccode", "Iran", "yes");
INSERT INTO `wp_options` VALUES("734753", "digit_color", "a:23:{s:7:\"bgcolor\";s:7:\"#4cc2fc\";s:13:\"loginboxcolor\";s:19:\"rgba(255,255,255,1)\";s:2:\"sx\";s:1:\"0\";s:2:\"sy\";s:1:\"2\";s:5:\"sblur\";s:1:\"4\";s:7:\"sspread\";s:1:\"0\";s:7:\"sradius\";s:1:\"4\";s:6:\"scolor\";s:18:\"rgba(0, 0, 0, 0.5)\";s:10:\"fontcolor1\";s:16:\"rgba(20,20,20,1)\";s:10:\"fontcolor2\";s:19:\"rgba(255,255,255,1)\";s:9:\"backcolor\";s:13:\"rgba(0,0,0,1)\";s:4:\"type\";s:1:\"1\";s:10:\"left_color\";s:19:\"rgba(255,255,255,1)\";s:14:\"input_bg_color\";s:13:\"rgba(0,0,0,0)\";s:18:\"input_border_color\";s:13:\"rgba(0,0,0,0)\";s:16:\"input_text_color\";s:13:\"rgba(0,0,0,0)\";s:15:\"button_bg_color\";s:13:\"rgba(0,0,0,0)\";s:19:\"signup_button_color\";s:13:\"rgba(0,0,0,0)\";s:26:\"signup_button_border_color\";s:13:\"rgba(0,0,0,0)\";s:17:\"button_text_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"signup_button_text_color\";s:13:\"rgba(0,0,0,0)\";s:12:\"left_bg_size\";s:4:\"auto\";s:16:\"left_bg_position\";s:13:\"Center Center\";}", "yes");
INSERT INTO `wp_options` VALUES("734754", "digit_color_modal", "a:22:{s:7:\"bgcolor\";s:18:\"rgba(6, 6, 6, 0.8)\";s:13:\"loginboxcolor\";s:19:\"rgba(255,255,255,1)\";s:2:\"sx\";s:1:\"0\";s:2:\"sy\";s:1:\"0\";s:5:\"sblur\";s:2:\"20\";s:7:\"sspread\";s:1:\"0\";s:7:\"sradius\";s:1:\"0\";s:6:\"scolor\";s:18:\"rgba(0, 0, 0, 0.3)\";s:10:\"fontcolor1\";s:16:\"rgba(20,20,20,1)\";s:10:\"fontcolor2\";s:19:\"rgba(255,255,255,1)\";s:4:\"type\";s:1:\"1\";s:10:\"left_color\";s:13:\"rgba(0,0,0,1)\";s:14:\"input_bg_color\";s:13:\"rgba(0,0,0,0)\";s:18:\"input_border_color\";s:13:\"rgba(0,0,0,0)\";s:16:\"input_text_color\";s:13:\"rgba(0,0,0,0)\";s:15:\"button_bg_color\";s:13:\"rgba(0,0,0,0)\";s:19:\"signup_button_color\";s:13:\"rgba(0,0,0,0)\";s:26:\"signup_button_border_color\";s:13:\"rgba(0,0,0,0)\";s:17:\"button_text_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"signup_button_text_color\";s:13:\"rgba(0,0,0,0)\";s:12:\"left_bg_size\";s:4:\"auto\";s:16:\"left_bg_position\";s:13:\"Center Center\";}", "yes");
INSERT INTO `wp_options` VALUES("734755", "digits_logo_image", "", "yes");
INSERT INTO `wp_options` VALUES("734756", "digits_bg_image_modal", "", "yes");
INSERT INTO `wp_options` VALUES("734757", "digits_bg_image", "", "yes");
INSERT INTO `wp_options` VALUES("734758", "digits_left_bg_image", "", "yes");
INSERT INTO `wp_options` VALUES("734759", "digits_left_bg_image_modal", "", "yes");
INSERT INTO `wp_options` VALUES("734760", "dig_preset", "1", "yes");
INSERT INTO `wp_options` VALUES("734761", "login_page_footer", "", "yes");
INSERT INTO `wp_options` VALUES("734762", "login_page_footer_text_color", "rgba(255,255,255,1)", "yes");
INSERT INTO `wp_options` VALUES("734763", "digits_myaccount_redirect", "", "yes");
INSERT INTO `wp_options` VALUES("734764", "digits_loginred", "", "yes");
INSERT INTO `wp_options` VALUES("734765", "digits_regred", "", "yes");
INSERT INTO `wp_options` VALUES("734766", "digits_forgotred", "", "yes");
INSERT INTO `wp_options` VALUES("734767", "digits_logoutred", "", "yes");
INSERT INTO `wp_options` VALUES("734875", "dig_unr", "1609577718", "no");
INSERT INTO `wp_options` VALUES("752100", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `wp_options` VALUES("821063", "woocommerce_merchant_email_notifications", "yes", "no");
INSERT INTO `wp_options` VALUES("822200", "smush-in-progress-3054", "1", "yes");
INSERT INTO `wp_options` VALUES("822294", "widget_mf_products_on_sale", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("844666", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("883454", "fs_active_plugins", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("883455", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("883456", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:4123;a:3:{s:4:\"slug\";s:10:\"menu-image\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:25:\"menu-image/menu-image.php\";}}s:11:\"plugin_data\";a:1:{s:10:\"menu-image\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:25:\"menu-image/menu-image.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1619093354;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.4.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"3.0.4\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:9:\"mimwp.com\";s:9:\"server_ip\";s:13:\"46.245.106.59\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1619093354;s:7:\"version\";s:5:\"3.0.4\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1619093371;s:7:\"version\";s:5:\"3.0.4\";}}}s:13:\"file_slug_map\";a:1:{s:25:\"menu-image/menu-image.php\";s:10:\"menu-image\";}s:7:\"plugins\";a:1:{s:10:\"menu-image\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:10:\"Menu Image\";s:4:\"slug\";s:10:\"menu-image\";s:12:\"premium_slug\";s:18:\"menu-image-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";s:8:\"selected\";s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:25:\"menu-image/menu-image.php\";s:7:\"version\";s:5:\"3.0.4\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:7:\"Premium\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_1a1cac31f5af1ba3d31bd86fe0e8b\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"4123\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"dbc8e0deb80c8343d81d0540ffe3720a\";s:13:\"admin_notices\";a:1:{s:10:\"menu-image\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("883457", "fs_gdpr", "a:1:{s:3:\"u70\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("883458", "fs_api_cache", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("911043", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("911075", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `wp_options` VALUES("948494", "woocommerce_inbox_variant_assignment", "8", "yes");
INSERT INTO `wp_options` VALUES("962483", "yith-wcbm-hide-on-sale-default", "no", "yes");
INSERT INTO `wp_options` VALUES("962484", "yith-wcbm-hide-in-sidebar", "yes", "yes");
INSERT INTO `wp_options` VALUES("962485", "yith-wcbm-product-badge-overrides-default-on-sale", "yes", "yes");
INSERT INTO `wp_options` VALUES("969694", "theme_mods_martfury-child", "a:1:{s:18:\"custom_css_post_id\";i:2430;}", "no");
INSERT INTO `wp_options` VALUES("975047", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("996653", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("996654", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:16:\"mimwp2@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:16:\"mimwp2@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("996678", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("996682", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("996692", "woocommerce_WC_ZPal_settings", "a:10:{s:11:\"base_config\";s:0:\"\";s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:35:\"پرداخت امن زرین پال\";s:11:\"description\";s:117:\"پرداخت امن به وسیله کلیه کارت های عضو شتاب از طریق درگاه زرین پال\";s:14:\"account_config\";s:0:\"\";s:12:\"merchantcode\";s:0:\"\";s:12:\"zarinwebgate\";s:3:\"yes\";s:14:\"payment_config\";s:0:\"\";s:15:\"success_massage\";s:83:\"با تشکر از شما . سفارش شما با موفقیت پرداخت شد .\";s:14:\"failed_massage\";s:178:\"پرداخت شما ناموفق بوده است . لطفا مجددا تلاش نمایید یا در صورت بروز اشکال با مدیر سایت تماس بگیرید .\";}", "yes");
INSERT INTO `wp_options` VALUES("1004822", "product_brand_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1011776", "wp-reset", "a:4:{s:4:\"meta\";a:3:{s:13:\"first_version\";s:4:\"1.93\";s:13:\"first_install\";i:1628447592;s:11:\"reset_count\";i:0;}s:17:\"dismissed_notices\";a:1:{s:7:\"welcome\";b:1;}s:8:\"last_run\";a:0:{}s:7:\"options\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("1040069", "ywccp-enable-js-error-check", "no", "yes");
INSERT INTO `wp_options` VALUES("1040070", "ywccp-enable-js-vat-check", "no", "yes");
INSERT INTO `wp_options` VALUES("1040071", "ywccp-enable-tooltip-check", "no", "yes");
INSERT INTO `wp_options` VALUES("1040072", "ywccp-date-format-datepicker", "mm/dd/yy", "yes");
INSERT INTO `wp_options` VALUES("1040073", "ywccp-time-format-datepicker", "12", "yes");
INSERT INTO `wp_options` VALUES("1040074", "ywccp-override-formatted-addresses", "no", "yes");
INSERT INTO `wp_options` VALUES("1040075", "ywccp-show-label-formatted-addresses", "yes", "yes");
INSERT INTO `wp_options` VALUES("1040076", "ywccp-field-checkout-columns", "no", "yes");
INSERT INTO `wp_options` VALUES("1040077", "ywccp-field-input-height", "40", "yes");
INSERT INTO `wp_options` VALUES("1040078", "ywccp-field-border-color", "#d1d1d1", "yes");
INSERT INTO `wp_options` VALUES("1040079", "ywccp-field-border-color-focus", "#d1d1d1", "yes");
INSERT INTO `wp_options` VALUES("1040080", "ywccp-field-border-color-success", "#69bf29", "yes");
INSERT INTO `wp_options` VALUES("1040081", "ywccp-field-border-color-error", "#a00a00", "yes");
INSERT INTO `wp_options` VALUES("1040082", "ywccp-field-error-color", "#a00a00", "yes");
INSERT INTO `wp_options` VALUES("1040090", "ywccp_fields_billing_options", "a:11:{s:18:\"billing_first_name\";a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"نام\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:1:{i:0;s:14:\"form-row-first\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:8:\"required\";b:1;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:17:\"billing_last_name\";a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:23:\"نام خانوادگی\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:1:{i:0;s:13:\"form-row-last\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:8:\"required\";b:1;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:15:\"billing_company\";a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:15:\"نام شرکت\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:8:\"required\";b:0;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:15:\"billing_country\";a:17:{s:4:\"type\";s:7:\"country\";s:5:\"label\";s:21:\"کشور / منطقه\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:3:{i:0;s:13:\"address-field\";i:1;s:23:\"update_totals_on_change\";i:2;s:13:\"form-row-wide\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:8:\"required\";b:1;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:17:\"billing_address_1\";a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:12:\"خیابان\";s:11:\"placeholder\";s:40:\"پلاک خانه و نام خیابان\";s:7:\"options\";a:0:{}s:5:\"class\";a:2:{i:0;s:13:\"address-field\";i:1;s:13:\"form-row-wide\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:8:\"required\";b:1;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:17:\"billing_address_2\";a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:46:\"آپارتمان، مجتمع، واحد و...\";s:11:\"placeholder\";s:58:\"شماره واحد ، بلوک ، پلاک (دلخواه)\";s:7:\"options\";a:0:{}s:5:\"class\";a:2:{i:0;s:13:\"address-field\";i:1;s:13:\"form-row-wide\";}s:11:\"label_class\";a:1:{i:0;s:18:\"screen-reader-text\";}s:8:\"validate\";s:0:\"\";s:8:\"required\";b:0;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:12:\"billing_city\";a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"شهر\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:2:{i:0;s:13:\"address-field\";i:1;s:13:\"form-row-wide\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:8:\"required\";b:1;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:13:\"billing_state\";a:17:{s:4:\"type\";s:5:\"state\";s:5:\"label\";s:10:\"استان\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:2:{i:0;s:13:\"address-field\";i:1;s:13:\"form-row-wide\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";a:1:{i:0;s:5:\"state\";}s:8:\"required\";b:1;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:16:\"billing_postcode\";a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:12:\"کدپستی\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:2:{i:0;s:13:\"address-field\";i:1;s:13:\"form-row-wide\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";a:1:{i:0;s:8:\"postcode\";}s:8:\"required\";b:0;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:2:\"0|\";}s:13:\"billing_phone\";a:17:{s:4:\"type\";s:3:\"tel\";s:5:\"label\";s:8:\"تلفن\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";a:1:{i:0;s:5:\"phone\";}s:8:\"required\";b:1;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}s:13:\"billing_email\";a:17:{s:4:\"type\";s:5:\"email\";s:5:\"label\";s:19:\"آدرس ایمیل\";s:11:\"placeholder\";s:0:\"\";s:7:\"options\";a:0:{}s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:11:\"label_class\";s:0:\"\";s:8:\"validate\";a:1:{i:0;s:5:\"email\";}s:8:\"required\";b:1;s:7:\"enabled\";b:1;s:13:\"show_in_email\";b:1;s:13:\"show_in_order\";b:1;s:17:\"custom_attributes\";a:1:{s:12:\"data-tooltip\";s:0:\"\";}s:20:\"condition_input_name\";s:0:\"\";s:14:\"condition_type\";s:0:\"\";s:15:\"condition_value\";s:0:\"\";s:16:\"condition_action\";s:0:\"\";s:18:\"condition_required\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("1046688", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("1112952", "woocommerce_task_list_hidden_lists", "a:1:{i:0;s:5:\"setup\";}", "yes");
INSERT INTO `wp_options` VALUES("1112995", "woocommerce_refund_returns_page_id", "3134", "yes");
INSERT INTO `wp_options` VALUES("1131543", "widget_yith_woocommerce_ajax_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1131544", "yith_wcas_search_input_label", "Search for products", "yes");
INSERT INTO `wp_options` VALUES("1131545", "yith_wcas_search_submit_label", "Search", "yes");
INSERT INTO `wp_options` VALUES("1131546", "yith_wcas_min_chars", "3", "yes");
INSERT INTO `wp_options` VALUES("1131547", "yith_wcas_posts_per_page", "3", "yes");
INSERT INTO `wp_options` VALUES("1131548", "yith_wcas_enable_transient", "no", "yes");
INSERT INTO `wp_options` VALUES("1131549", "yith_wcas_transient_duration", "12", "yes");
INSERT INTO `wp_options` VALUES("1238275", "woocommerce_task_list_tracked_completed_tasks", "a:5:{i:0;s:13:\"store_details\";i:1;s:8:\"products\";i:2;s:8:\"payments\";i:3;s:8:\"purchase\";i:4;s:14:\"store_creation\";}", "yes");
INSERT INTO `wp_options` VALUES("1238276", "woocommerce_task_list_completed_lists", "a:2:{i:0;s:8:\"extended\";i:1;s:19:\"extended_two_column\";}", "yes");
INSERT INTO `wp_options` VALUES("1335432", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("1335435", "woocommerce_admin_version", "3.2.1", "yes");
INSERT INTO `wp_options` VALUES("1509539", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("1679791", "revslider-update-check", "1762846884", "yes");
INSERT INTO `wp_options` VALUES("1679792", "revslider_update_info", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("1679801", "woocommerce_task_list_reminder_bar_hidden", "yes", "yes");
INSERT INTO `wp_options` VALUES("1679859", "wc_downloads_approved_directories_mode", "disabled", "yes");
INSERT INTO `wp_options` VALUES("2061399", "user_count", "12", "off");
INSERT INTO `wp_options` VALUES("2068323", "product_cat_children", "a:1:{i:143;a:1:{i:0;i:144;}}", "yes");
INSERT INTO `wp_options` VALUES("2136415", "_transient_global_styles_martfury", "body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--font-size--small: 13px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}", "no");
INSERT INTO `wp_options` VALUES("2187923", "_transient_global_styles_svg_filters_martfury", "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-dark-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncG type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncB type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.54901960784314 0.98823529411765\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.71764705882353 0.25490196078431\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-red\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.27843137254902\" /><feFuncB type=\"table\" tableValues=\"0.5921568627451 0.27843137254902\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-midnight\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0\" /><feFuncG type=\"table\" tableValues=\"0 0.64705882352941\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-magenta-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.78039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.94901960784314\" /><feFuncB type=\"table\" tableValues=\"0.35294117647059 0.47058823529412\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-green\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.65098039215686 0.40392156862745\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.44705882352941 0.4\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-orange\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.098039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.66274509803922\" /><feFuncB type=\"table\" tableValues=\"0.84705882352941 0.41960784313725\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg>", "no");
INSERT INTO `wp_options` VALUES("2216363", "woocommerce_downloads_deliver_inline", "", "no");
INSERT INTO `wp_options` VALUES("2216398", "wpb_license_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2217662", "duplicator_settings", "a:19:{s:7:\"version\";s:6:\"1.5.14\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:48;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("2217663", "duplicator_version_plugin", "1.5.14", "yes");
INSERT INTO `wp_options` VALUES("2217667", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-11 07:53:55\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.1.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:17:\"Martfury336Zhaket\";s:4:\"Hash\";s:35:\"5168511b06c28cd96715_20251111075355\";s:8:\"NameHash\";s:53:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:63:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:101:\"/home/mimwpcom/public_html/theme/martfury/main;/home/mimwpcom/public_html/theme/martfury/soo-importer\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:70:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3423;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:29979;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-11 07:53:55\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.1.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:17:\"Martfury336Zhaket\";s:4:\"Hash\";s:35:\"5168511b06c28cd96715_20251111075355\";s:8:\"NameHash\";s:53:\"Martfury336Zhaket_5168511b06c28cd96715_20251111075355\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:84:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:79:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-admin\";i:1;s:82:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-includes\";i:2;s:91:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:70:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall\";i:1;s:70:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall\";i:2;s:81:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content\";i:3;s:89:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/uploads\";i:4;s:89:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/plugins\";i:5;s:92:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/mu-plugins\";i:6;s:88:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:102:\"/home/u617046102/domains/mimwp.com/public_html/theme/martfury/xinstall/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("2217670", "duplicator_ui_view_state", "a:3:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("2226335", "woocommerce_navigation_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("2226336", "woocommerce_feature_custom_order_tables_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("2231491", "martfury_variation_images", "no", "yes");
INSERT INTO `wp_options` VALUES("2231717", "ab87759cd451398a855b755f66c51f", "YTo1OntzOjI5OiJlZjUyODVkYTE5MDExZWRkMDgyNTM3Y2FiNWEyYiI7YjowO3M6MzE6ImI2NGJlMDE0MjMyNDQyOTkzNWUzZWUxZTFlNTAzNmIiO3M6NDk6ItmE2KfbjNiz2YbYsyDYqNin24zYryAzNiDaqdin2LHYp9qp2KrYsSDYqNin2LTYry4iO3M6MjE6ImRlOGM4ZTkzMWE3NmRlZTE4YTU1ZCI7aToxNzA1NDExOTM3O3M6Mjk6ImYyMjI3YjIxNmQ5MzQxNmMzNjZkMWZiNDhhZjNhIjtiOjE7czozMToiZWNiYzAyZDBhM2VmMmEwNmM2MzZmZGRkNTY4MDMwYSI7YjowO30=", "yes");
INSERT INTO `wp_options` VALUES("2234241", "_transient_woocommerce_shipping_task_zone_count_transient", "0", "yes");
INSERT INTO `wp_options` VALUES("2240690", "martfury_product_bought_together", "yes", "yes");
INSERT INTO `wp_options` VALUES("2240691", "woocommerce_new_product_management_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("2240727", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_options` VALUES("2247306", "widget_mf_search_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("2247348", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("2247349", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("2247353", "wp_smush_pre_3_12_6_site", "0", "no");
INSERT INTO `wp_options` VALUES("2256427", "persian_woocommerce_translates", "a:6:{s:9:\"View cart\";s:17:\"نمایش سبد\";s:8:\"Checkout\";s:12:\"پرداخت\";s:19:\"تسویه حساب\";s:12:\"پرداخت\";s:12:\"Product name\";s:17:\"نام محصول\";s:11:\" Unit price\";s:17:\"قیمت واحد\";s:13:\" Stock status\";s:21:\"وضعیت انبار\";}", "yes");
INSERT INTO `wp_options` VALUES("2261296", "duplicator_notifications", "a:4:{s:6:\"update\";i:1762846721;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("2261311", "wc_blocks_use_blockified_product_grid_block_as_template", "no", "yes");
INSERT INTO `wp_options` VALUES("2261312", "wc_blocks_version", "11.8.0-dev", "yes");
INSERT INTO `wp_options` VALUES("2261313", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:14:\"ووکامرس\";}}", "yes");
INSERT INTO `wp_options` VALUES("2261316", "woocommerce_feature_product_block_editor_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("2261325", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1708455404;}", "yes");
INSERT INTO `wp_options` VALUES("2261328", "wp_smush_global_stats", "a:1:{s:25:\"rescan_required_timestamp\";i:1712573392;}", "no");
INSERT INTO `wp_options` VALUES("2261329", "wp_smush_image_sizes_state", "a:2:{s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:3:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";b:1;}s:6:\"medium\";a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;}s:5:\"large\";a:3:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;}s:9:\"1536x1536\";a:3:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";b:0;}s:9:\"2048x2048\";a:3:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";b:0;}s:18:\"martfury-blog-grid\";a:3:{s:5:\"width\";i:380;s:6:\"height\";i:300;s:4:\"crop\";b:1;}s:18:\"martfury-blog-list\";a:3:{s:5:\"width\";i:790;s:6:\"height\";i:510;s:4:\"crop\";b:1;}s:21:\"martfury-blog-masonry\";a:3:{s:5:\"width\";i:370;s:6:\"height\";i:588;s:4:\"crop\";b:0;}s:21:\"woocommerce_thumbnail\";a:3:{s:5:\"width\";i:480;s:6:\"height\";i:480;s:4:\"crop\";i:1;}s:18:\"woocommerce_single\";a:3:{s:5:\"width\";i:600;s:6:\"height\";i:0;s:4:\"crop\";i:0;}s:29:\"woocommerce_gallery_thumbnail\";a:3:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:4:\"crop\";i:1;}s:12:\"medium_large\";a:2:{s:5:\"width\";i:768;s:6:\"height\";i:0;}}s:4:\"hash\";i:86783418982;}", "yes");
INSERT INTO `wp_options` VALUES("2261517", "wpmudev_notices", "a:3:{s:7:\"plugins\";a:1:{s:5:\"smush\";i:1564408908;}s:5:\"queue\";a:1:{s:5:\"smush\";a:2:{s:4:\"rate\";i:1690712659;s:8:\"giveaway\";i:1690107873;}}s:4:\"done\";a:1:{s:5:\"smush\";a:1:{s:5:\"email\";i:1577000291;}}}", "no");
INSERT INTO `wp_options` VALUES("2265868", "woocommerce_custom_orders_table_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("2265869", "woocommerce_custom_orders_table_data_sync_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("2265870", "woocommerce_custom_orders_table_created", "no", "yes");
INSERT INTO `wp_options` VALUES("2270858", "woocommerce_feature_marketplace_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("2270866", "wcpay_was_in_use", "no", "yes");
INSERT INTO `wp_options` VALUES("2270879", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \".BKGafUBOdsYN&=XD86+bkIg2n7Zpi1b4fM0xcZcp3oN\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 14,\n    \"buildLastDate\": 1745914939,\n    \"buildFailedCount\": 1,\n    \"buildFailedLastDate\": 1705992191,\n    \"siteSizeMB\": 529.63,\n    \"siteNumFiles\": 33402,\n    \"siteDbSizeMB\": 25.5,\n    \"siteDbNumTables\": 83\n}", "yes");
INSERT INTO `wp_options` VALUES("2271029", "cab882bc779d829465e2cbe3509d15d", "YTo0OntzOjI5OiJlZjUyODVkYTE5MDExZWRkMDgyNTM3Y2FiNWEyYiI7YjowO3M6MzE6ImI2NGJlMDE0MjMyNDQyOTkzNWUzZWUxZTFlNTAzNmIiO3M6NDk6ItmE2KfbjNiz2YbYsyDYqNin24zYryAzNiDaqdin2LHYp9qp2KrYsSDYqNin2LTYry4iO3M6Mjk6ImYyMjI3YjIxNmQ5MzQxNmMzNjZkMWZiNDhhZjNhIjtiOjE7czozMToiZWNiYzAyZDBhM2VmMmEwNmM2MzZmZGRkNTY4MDMwYSI7YjowO30=", "yes");
INSERT INTO `wp_options` VALUES("2296215", "woocommerce_store_id", "29ecff9b-1157-4398-9753-97a115bc8c39", "yes");
INSERT INTO `wp_options` VALUES("2296231", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[38,39,40,41,42,43,44,45,46,47],\"failedPackageIds\":[]}", "yes");
INSERT INTO `wp_options` VALUES("2296242", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("2342945", "woocommerce_product_match_featured_image_by_sku", "no", "yes");
INSERT INTO `wp_options` VALUES("2342946", "woocommerce_feature_order_attribution_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("2343394", "guardino_last_check_guard_license", "a:1:{s:28:\"be7605219f177e2f2f66ade0cb9f\";i:1708435902;}", "no");
INSERT INTO `wp_options` VALUES("2378891", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1707955859", "no");
INSERT INTO `wp_options` VALUES("2391057", "woocommerce_remote_variant_assignment", "44", "yes");
INSERT INTO `wp_options` VALUES("2391103", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2395736", "pw_notices", "a:1:{s:7:\"notices\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("2399613", "woocommerce_hpos_fts_index_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("2404302", "woocommerce_attribute_lookup_optimized_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("2409368", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("2421844", "elementor_checklist", "{\"last_opened_timestamp\":-1,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"editor_visit_count\":0,\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp_options` VALUES("2421848", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("2421849", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("2421894", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"1831f4a91c8f95e8a4a207c2e9318038\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("2424264", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("2424284", "elementor_connect_site_key", "9b2930ff9e80624eb2ca798493bcd4f3", "auto");
INSERT INTO `wp_options` VALUES("2424289", "woocommerce_share_key", "OVooDWnYiRKLhd1Safw3S7UKLkRdIylx", "auto");
INSERT INTO `wp_options` VALUES("2424292", "woocommerce_show_lys_tour", "yes", "auto");
INSERT INTO `wp_options` VALUES("2424293", "woocommerce_coming_soon", "no", "auto");
INSERT INTO `wp_options` VALUES("2424328", "duplicator_expire_search-replace-wpcode", "{\"expire\":1737124173,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wp_options` VALUES("2424329", "duplicator_expire_wp-mail-smtp", "{\"expire\":1737124178,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.2\"}}", "on");
INSERT INTO `wp_options` VALUES("2424330", "duplicator_expire_insert-headers-and-footers", "{\"expire\":1737124183,\"value\":{\"wp_version\":\"4.6\",\"php_version\":\"5.5\"}}", "on");
INSERT INTO `wp_options` VALUES("2439179", "_transient_is_multi_author", "0", "on");
INSERT INTO `wp_options` VALUES("2440191", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("2440192", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("2440193", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("2440196", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("2440197", "woocommerce_email_auto_sync_with_theme", "no", "off");
INSERT INTO `wp_options` VALUES("2440198", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("2440199", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("2440200", "woocommerce_feature_email_improvements_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("2440201", "woocommerce_feature_reactify-classic-payments-settings_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("2440213", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("2440217", "wp_smush_event_times", "a:1:{s:15:\"plugin_upgraded\";i:1762846997;}", "off");
INSERT INTO `wp_options` VALUES("2477084", "_transient_timeout_wc_child_has_weight_1992", "1763111969", "off");
INSERT INTO `wp_options` VALUES("2477085", "_transient_wc_child_has_weight_1992", "0", "off");
INSERT INTO `wp_options` VALUES("2477086", "_transient_timeout_wc_child_has_dimensions_1992", "1763111969", "off");
INSERT INTO `wp_options` VALUES("2477087", "_transient_wc_child_has_dimensions_1992", "0", "off");
INSERT INTO `wp_options` VALUES("2478662", "_transient_timeout_wc_product_loop_908d8c74aa655c4045f35850b6d05abb", "1763958290", "off");
INSERT INTO `wp_options` VALUES("2478663", "_transient_wc_product_loop_908d8c74aa655c4045f35850b6d05abb", "a:2:{s:7:\"version\";s:10:\"1707912644\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:8:{i:0;i:1992;i:1;i:99;i:2;i:47;i:3;i:40;i:4;i:37;i:5;i:34;i:6;i:31;i:7;i:22;}s:5:\"total\";i:8;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}", "off");
INSERT INTO `wp_options` VALUES("2478664", "_transient_timeout_wc_product_loop_86819dd97e342fce3cb474d97ede890b", "1763958290", "off");
INSERT INTO `wp_options` VALUES("2478665", "_transient_wc_product_loop_86819dd97e342fce3cb474d97ede890b", "a:2:{s:7:\"version\";s:10:\"1707912644\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:7:{i:0;i:126;i:1;i:87;i:2;i:83;i:3;i:79;i:4;i:76;i:5;i:73;i:6;i:70;}s:5:\"total\";i:7;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}", "off");
INSERT INTO `wp_options` VALUES("2478666", "_transient_timeout_wc_product_loop_874c867d7b520602a89514bf6d121c18", "1763958290", "off");
INSERT INTO `wp_options` VALUES("2478667", "_transient_wc_product_loop_874c867d7b520602a89514bf6d121c18", "a:2:{s:7:\"version\";s:10:\"1707912644\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:7:{i:0;i:90;i:1;i:264;i:2;i:19;i:3;i:15;i:4;i:282;i:5;i:281;i:6;i:280;}s:5:\"total\";i:7;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}", "off");
INSERT INTO `wp_options` VALUES("2479236", "_transient_timeout_wc_child_has_weight_79", "1764254140", "off");
INSERT INTO `wp_options` VALUES("2479237", "_transient_wc_child_has_weight_79", "0", "off");
INSERT INTO `wp_options` VALUES("2479238", "_transient_timeout_wc_child_has_dimensions_79", "1764254140", "off");
INSERT INTO `wp_options` VALUES("2479239", "_transient_wc_child_has_dimensions_79", "0", "off");
INSERT INTO `wp_options` VALUES("2479358", "_transient_timeout_wc_term_counts", "1765439480", "off");
INSERT INTO `wp_options` VALUES("2479359", "_transient_wc_term_counts", "a:250:{i:38;s:0:\"\";i:39;s:0:\"\";i:41;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:47;s:0:\"\";i:3;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:55;s:0:\"\";i:56;s:0:\"\";i:130;s:0:\"\";i:2;s:0:\"\";i:63;s:0:\"\";i:4;s:0:\"\";i:69;s:0:\"\";i:70;s:0:\"\";i:73;s:1:\"1\";i:131;s:0:\"\";i:74;s:1:\"3\";i:176;s:0:\"\";i:75;s:0:\"\";i:155;s:0:\"\";i:77;s:0:\"\";i:79;s:0:\"\";i:83;s:0:\"\";i:156;s:0:\"\";i:157;s:0:\"\";i:86;s:0:\"\";i:175;s:0:\"\";i:88;s:0:\"\";i:143;s:0:\"\";i:89;s:0:\"\";i:144;s:0:\"\";i:145;s:0:\"\";i:146;s:0:\"\";i:90;s:0:\"\";i:172;s:0:\"\";i:93;s:0:\"\";i:173;s:0:\"\";i:166;s:0:\"\";i:98;s:1:\"2\";i:132;s:0:\"\";i:133;s:0:\"\";i:99;s:0:\"\";i:100;s:1:\"5\";i:101;s:1:\"1\";i:177;s:0:\"\";i:103;s:0:\"\";i:147;s:0:\"\";i:107;s:0:\"\";i:179;s:0:\"\";i:151;s:0:\"\";i:149;s:0:\"\";i:110;s:0:\"\";i:150;s:0:\"\";i:154;s:0:\"\";i:170;s:0:\"\";i:142;s:0:\"\";i:152;s:0:\"\";i:129;s:0:\"\";i:158;s:0:\"\";i:111;s:0:\"\";i:112;s:0:\"\";i:114;s:0:\"\";i:115;s:0:\"\";i:116;s:0:\"\";i:178;s:0:\"\";i:117;s:0:\"\";i:159;s:0:\"\";i:138;s:1:\"7\";i:141;s:1:\"1\";i:139;s:1:\"1\";i:171;s:1:\"1\";i:122;s:1:\"1\";i:135;s:1:\"1\";i:119;s:1:\"7\";i:161;s:1:\"1\";i:134;s:1:\"1\";i:181;s:1:\"2\";i:136;s:1:\"2\";i:123;s:1:\"1\";i:120;s:1:\"1\";i:160;s:1:\"6\";i:167;s:1:\"1\";i:168;s:1:\"1\";i:169;s:1:\"1\";i:125;s:1:\"2\";i:174;s:1:\"1\";i:162;s:1:\"2\";i:126;s:1:\"1\";i:148;s:1:\"1\";i:180;s:1:\"2\";i:127;s:1:\"1\";i:153;s:1:\"1\";i:128;s:1:\"2\";i:137;s:1:\"2\";i:163;s:1:\"1\";i:164;s:1:\"1\";i:121;s:1:\"1\";i:140;s:1:\"1\";i:124;s:1:\"2\";i:85;s:1:\"2\";i:118;s:1:\"2\";i:96;s:1:\"2\";i:102;s:1:\"2\";i:72;s:1:\"4\";i:81;s:1:\"4\";i:15;s:1:\"0\";i:165;s:1:\"0\";i:71;s:1:\"3\";i:76;s:1:\"2\";i:78;s:1:\"1\";i:80;s:1:\"1\";i:82;s:1:\"5\";i:106;s:1:\"2\";i:108;s:1:\"8\";i:58;s:0:\"\";i:60;s:0:\"\";i:62;s:0:\"\";i:67;s:0:\"\";i:68;s:0:\"\";i:84;s:0:\"\";i:87;s:0:\"\";i:91;s:0:\"\";i:9;s:0:\"\";i:94;s:0:\"\";i:97;s:0:\"\";i:105;s:0:\"\";i:8;s:0:\"\";i:109;s:0:\"\";i:95;s:0:\"\";i:113;s:0:\"\";i:5;s:0:\"\";i:104;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:40;s:0:\"\";i:42;s:0:\"\";i:46;s:0:\"\";i:48;s:0:\"\";i:57;s:0:\"\";i:61;s:0:\"\";i:64;s:0:\"\";i:65;s:0:\"\";i:14;s:0:\"\";s:15:\"130_product_cat\";i:1;s:15:\"131_product_cat\";i:1;s:15:\"138_product_cat\";i:7;s:15:\"141_product_cat\";i:1;s:15:\"139_product_cat\";i:1;s:15:\"176_product_cat\";i:1;s:15:\"155_product_cat\";i:1;s:15:\"171_product_cat\";i:1;s:15:\"122_product_cat\";i:1;s:15:\"135_product_cat\";i:1;s:15:\"156_product_cat\";i:1;s:15:\"157_product_cat\";i:1;s:15:\"119_product_cat\";i:7;s:15:\"175_product_cat\";i:1;s:15:\"161_product_cat\";i:1;s:15:\"143_product_cat\";i:1;s:15:\"144_product_cat\";i:1;s:15:\"145_product_cat\";i:1;s:15:\"146_product_cat\";i:1;s:15:\"172_product_cat\";i:1;s:15:\"134_product_cat\";i:1;s:15:\"181_product_cat\";i:2;s:15:\"136_product_cat\";i:2;s:15:\"173_product_cat\";i:1;s:15:\"123_product_cat\";i:1;s:15:\"120_product_cat\";i:1;s:15:\"160_product_cat\";i:6;s:15:\"167_product_cat\";i:1;s:15:\"168_product_cat\";i:1;s:15:\"169_product_cat\";i:1;s:15:\"166_product_cat\";i:3;s:15:\"125_product_cat\";i:2;s:15:\"132_product_cat\";i:1;s:15:\"133_product_cat\";i:1;s:15:\"177_product_cat\";i:1;s:15:\"174_product_cat\";i:1;s:15:\"162_product_cat\";i:2;s:15:\"126_product_cat\";i:1;s:15:\"148_product_cat\";i:1;s:15:\"147_product_cat\";i:6;s:15:\"180_product_cat\";i:2;s:15:\"127_product_cat\";i:1;s:15:\"179_product_cat\";i:1;s:15:\"151_product_cat\";i:3;s:15:\"149_product_cat\";i:1;s:15:\"153_product_cat\";i:1;s:15:\"150_product_cat\";i:1;s:15:\"154_product_cat\";i:1;s:15:\"170_product_cat\";i:2;s:15:\"142_product_cat\";i:8;s:15:\"152_product_cat\";i:2;s:15:\"128_product_cat\";i:2;s:15:\"129_product_cat\";i:2;s:15:\"158_product_cat\";i:1;s:15:\"137_product_cat\";i:2;s:15:\"163_product_cat\";i:1;s:15:\"164_product_cat\";i:1;s:15:\"121_product_cat\";i:1;s:15:\"140_product_cat\";i:1;s:15:\"178_product_cat\";i:1;s:15:\"124_product_cat\";i:2;s:15:\"159_product_cat\";i:1;s:14:\"15_product_cat\";i:0;s:15:\"165_product_cat\";i:0;s:16:\"71_product_brand\";i:3;s:16:\"73_product_brand\";i:1;s:16:\"74_product_brand\";i:3;s:16:\"76_product_brand\";i:2;s:16:\"78_product_brand\";i:1;s:16:\"80_product_brand\";i:1;s:16:\"82_product_brand\";i:5;s:16:\"98_product_brand\";i:2;s:17:\"100_product_brand\";i:5;s:17:\"101_product_brand\";i:1;s:17:\"106_product_brand\";i:2;s:17:\"108_product_brand\";i:8;s:14:\"87_product_tag\";i:4;s:14:\"91_product_tag\";i:2;s:14:\"79_product_tag\";i:2;s:14:\"85_product_tag\";i:2;s:15:\"117_product_tag\";i:5;s:15:\"118_product_tag\";i:2;s:14:\"75_product_tag\";i:2;s:14:\"77_product_tag\";i:3;s:14:\"86_product_tag\";i:2;s:14:\"88_product_tag\";i:10;s:14:\"89_product_tag\";i:2;s:15:\"107_product_tag\";i:3;s:15:\"109_product_tag\";i:2;s:15:\"110_product_tag\";i:3;s:15:\"111_product_tag\";i:2;s:15:\"115_product_tag\";i:4;s:14:\"96_product_tag\";i:2;s:15:\"102_product_tag\";i:2;s:14:\"72_product_tag\";i:4;s:14:\"81_product_tag\";i:4;s:15:\"112_product_tag\";i:2;s:14:\"94_product_tag\";i:1;s:14:\"97_product_tag\";i:3;s:15:\"104_product_tag\";i:1;s:14:\"95_product_tag\";i:2;s:15:\"113_product_tag\";i:2;}", "off");
INSERT INTO `wp_options` VALUES("2479372", "_transient_timeout_wc_product_loop_7314beace6750d10d1ff05e082aa8e08", "1764321276", "off");
INSERT INTO `wp_options` VALUES("2479373", "_transient_wc_product_loop_7314beace6750d10d1ff05e082aa8e08", "a:2:{s:7:\"version\";s:10:\"1707912644\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:6:{i:0;i:31;i:1;i:37;i:2;i:99;i:3;i:22;i:4;i:47;i:5;i:1992;}s:5:\"total\";i:6;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}", "off");
INSERT INTO `wp_options` VALUES("2479374", "_transient_timeout_wc_product_loop_daa1838e9f4b217d543636d1626d70c0", "1764321276", "off");
INSERT INTO `wp_options` VALUES("2479375", "_transient_wc_product_loop_daa1838e9f4b217d543636d1626d70c0", "a:2:{s:7:\"version\";s:10:\"1707912644\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:4:{i:0;i:34;i:1;i:22;i:2;i:37;i:3;i:31;}s:5:\"total\";i:4;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}", "off");
INSERT INTO `wp_options` VALUES("2479378", "_transient_timeout_wc_product_loop_e14d5e926d772cc3dca77b144f33acc9", "1764321279", "off");
INSERT INTO `wp_options` VALUES("2479379", "_transient_wc_product_loop_e14d5e926d772cc3dca77b144f33acc9", "a:2:{s:7:\"version\";s:10:\"1707912644\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:5:{i:0;i:70;i:1;i:126;i:2;i:87;i:3;i:76;i:4;i:79;}s:5:\"total\";i:5;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}", "off");
INSERT INTO `wp_options` VALUES("2479380", "_transient_timeout_wc_product_loop_b32ff5e95681632196e4880cc4b9d963", "1764321279", "off");
INSERT INTO `wp_options` VALUES("2479381", "_transient_wc_product_loop_b32ff5e95681632196e4880cc4b9d963", "a:2:{s:7:\"version\";s:10:\"1707912644\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:0:{}s:5:\"total\";i:0;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}", "off");
INSERT INTO `wp_options` VALUES("2479866", "_transient_timeout_wc_product_children_79", "1764565035", "off");
INSERT INTO `wp_options` VALUES("2479867", "_transient_wc_product_children_79", "a:3:{s:3:\"all\";a:3:{i:0;i:2657;i:1;i:3189;i:2;i:2139;}s:7:\"visible\";a:3:{i:0;i:2657;i:1;i:3189;i:2;i:2139;}s:7:\"version\";s:10:\"1681719366\";}", "off");
INSERT INTO `wp_options` VALUES("2479868", "_transient_timeout_wc_var_prices_79", "1765439098", "off");
INSERT INTO `wp_options` VALUES("2479869", "_transient_wc_var_prices_79", "{\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2657\":\"55\",\"2139\":\"55\"},\"regular_price\":{\"2657\":\"55\",\"2139\":\"55\"},\"sale_price\":{\"2657\":\"55\",\"2139\":\"55\"}}}", "off");
INSERT INTO `wp_options` VALUES("2479902", "_transient_timeout_wc_product_children_1992", "1764585067", "off");
INSERT INTO `wp_options` VALUES("2479903", "_transient_wc_product_children_1992", "a:3:{s:3:\"all\";a:2:{i:0;i:2658;i:1;i:2338;}s:7:\"visible\";a:2:{i:0;i:2658;i:1;i:2338;}s:7:\"version\";s:10:\"1681719366\";}", "off");
INSERT INTO `wp_options` VALUES("2479904", "_transient_timeout_wc_var_prices_1992", "1765439447", "off");
INSERT INTO `wp_options` VALUES("2479905", "_transient_wc_var_prices_1992", "{\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2658\":\"40\",\"2338\":\"36\"},\"regular_price\":{\"2658\":\"40\",\"2338\":\"36\"},\"sale_price\":{\"2658\":\"40\",\"2338\":\"36\"}}}", "off");
INSERT INTO `wp_options` VALUES("2479920", "_transient_timeout_woocommerce_blocks_asset_api_script_data", "1764592300", "off");
INSERT INTO `wp_options` VALUES("2479921", "_transient_woocommerce_blocks_asset_api_script_data", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"4d43a4bcb41a5a6336c2\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"df3cbcae422855d48387\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"0d3321630119e50d175f\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"94f6fdb24497762c3877\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"13ca26913ccb282c047e\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"6d08dccfb4bf1a392a0d\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"4d3dbff32a4959449c1d\",\"dependencies\":[\"react\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-dom-ready\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"ce9125bf472706dea11a\",\"dependencies\":[\"react\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"cba59eca47d9101980bf\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"a3e67bb0b09f566d5bdf\",\"dependencies\":[\"wc-settings\",\"wp-html-entities\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"a5f075e4ff6dd6090875\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"a16e7eb12f5267371fe0\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"2def9412eeabab2071b2\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"0ea5d4718f1bb3c42ede\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"c163716dbc1e3cc6748c\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"e4169377f115faded81a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"daf82f32ab7ca75c7285\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"92dea44f259a5d3cc1aa\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"http:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.8.4\",\"dependencies\":[]}},\"version\":\"wc-9.8.4\",\"hash\":\"fdb7df28161713d35bb9594e0545fbf9\"}", "off");
INSERT INTO `wp_options` VALUES("2480290", "_site_transient_timeout_woocommerce_blocks_patterns", "1765438997", "off");
INSERT INTO `wp_options` VALUES("2480291", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:6:\"10.3.4\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:10:\"banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:15:\"coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:18:\"header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:51:\"heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:24:\"hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:43:\"intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:29:\"no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:21:\"no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:28:\"page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:34:\"page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:33:\"page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:38:\"page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:50:\"product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:36:\"social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:41:\"three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `wp_options` VALUES("2480292", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1765439030", "off");
INSERT INTO `wp_options` VALUES("2480293", "_transient_woocommerce_blocks_asset_api_script_data_ssl", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"508473c3c2ece9af8f8f\",\"dependencies\":[\"wc-types\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"f0cc692c0367e0930c80\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"d79dedade2f2e4dc9df4\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"c7cac5d19cadee0eb772\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"d1d7e81455daca642e25\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"a16aa912ffa0a15063f1\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"f508ac0666cf96706aa4\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-blocks\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"a5ca704c2348a9a180b5\",\"dependencies\":[\"react-jsx-runtime\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"c18bbb2325f333897e6b\",\"dependencies\":[\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"57e176e7cc02bdd27978\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"00b931bcc27024fa60ca\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"bcad3fab21852551edee\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"161c226e82cfe5aeaa29\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"fd501851f2904ac6131a\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"8b64025baef8d338aa5e\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"f762078aeb4207fe9c3d\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/sanitize\\/index.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/sanitize\\/index.js\",\"version\":\"555561bffd642731f079\",\"dependencies\":[]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"ebdc0b2d7487174621e6\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"0446a66f2604add5f739\",\"dependencies\":[\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"2b8c9f76f07b4d13473b\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-sanitize\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/mimwp.com\\/theme\\/martfury\\/xinstall\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-10.3.4\",\"dependencies\":[]}},\"version\":\"wc-10.3.4\",\"hash\":\"3468679dc8f94e5d8297362f4f732a4c\"}", "off");
INSERT INTO `wp_options` VALUES("2480358", "_transient_timeout_wc_layered_nav_counts_product_brand", "1762930843", "off");
INSERT INTO `wp_options` VALUES("2480359", "_transient_wc_layered_nav_counts_product_brand", "a:76:{i:0;b:0;s:32:\"02510b2a1cf2744b3987cd2295f4d569\";a:12:{i:71;i:3;i:73;i:1;i:74;i:3;i:76;i:2;i:78;i:1;i:80;i:1;i:82;i:5;i:98;i:2;i:100;i:5;i:101;i:1;i:106;i:2;i:108;i:8;}s:32:\"b18c24b3adf5b26da74baf465513d5e7\";a:4:{i:74;i:2;i:78;i:1;i:100;i:4;i:106;i:1;}s:32:\"25e838c973da6246efa5fb9749418632\";a:2:{i:82;i:1;i:100;i:1;}s:32:\"fb6b674710cbf19586e1a673109ca660\";a:1:{i:98;i:1;}s:32:\"51cbac61edc168a9ff16b8dc93779f61\";a:1:{i:100;i:1;}s:32:\"9ac298dd0f3863433d759e89e1851cea\";a:2:{i:73;i:1;i:80;i:1;}s:32:\"6bcb9300c437b46b9d0925da62aa86cf\";a:1:{i:100;i:1;}s:32:\"036b769e471b9070f13c2d6e46187040\";a:2:{i:82;i:1;i:108;i:1;}s:32:\"df644cc5e791e1fe718e64f6c5728e94\";a:2:{i:106;i:1;i:108;i:1;}s:32:\"e73999f8394d49bbf1ebf2e182c0472b\";a:0:{}s:32:\"5581b84d74ec61d80d58aedce9c067f6\";a:1:{i:98;i:1;}s:32:\"5fa746ee3b82732b1d46ea18e6dc4d5f\";a:6:{i:73;i:1;i:76;i:1;i:80;i:1;i:98;i:1;i:100;i:3;i:101;i:1;}s:32:\"134821549cb4f380022d37b46fad0282\";a:1:{i:108;i:1;}s:32:\"937c39167e7cb0ac5e3ca250bb73d90b\";a:2:{i:82;i:5;i:108;i:1;}s:32:\"b32f16284ba05cebeb5405d37cb3dc76\";a:3:{i:71;i:3;i:106;i:2;i:108;i:2;}s:32:\"f7c967b139ff825ca86c1a807db903d1\";a:1:{i:100;i:1;}s:32:\"4b3cfcff46e6a16deb49685c81e13d57\";a:1:{i:108;i:1;}s:32:\"36f95425d4580c110d518de6122fc57f\";a:1:{i:98;i:1;}s:32:\"b5f296cd6bb3682ce939fa0045f24b58\";a:2:{i:100;i:1;i:106;i:2;}s:32:\"14c9e85ba8ffb38dd8767330adb46704\";a:2:{i:100;i:1;i:101;i:1;}s:32:\"c47c6c967395398fd7428e60c3a5f8ef\";a:1:{i:73;i:1;}s:32:\"3fa76280ac2e1edebf8fb84a19d5fa4d\";a:1:{i:100;i:1;}s:32:\"abd48a0066745fa63a4732ca64b3a057\";a:1:{i:98;i:1;}s:32:\"db88f5e6a021c4a967a1362972b93dca\";a:1:{i:74;i:1;}s:32:\"6e30ebb28d0bbcdeff4f57c9536db0e5\";a:1:{i:98;i:1;}s:32:\"39a7bb196005ca08cc35bfe1f3703c11\";a:1:{i:74;i:1;}s:32:\"49a07c301f09b06da83428ce8a321cad\";a:2:{i:76;i:1;i:108;i:5;}s:32:\"777f9318c0c6142230d4e2a1f2afb09b\";a:1:{i:74;i:1;}s:32:\"0473a008e2900437ca083a5119b21901\";a:1:{i:106;i:1;}s:32:\"3377b0f14ba07f318ce588e36c63d473\";a:1:{i:108;i:1;}s:32:\"424f58ce89e07c3ba36b6cdb71dc4a85\";a:1:{i:74;i:2;}s:32:\"72688d2f19ed8a61fcef716fdf93a5da\";a:2:{i:73;i:1;i:80;i:1;}s:32:\"9fcdd0946471e60866edb455fff9a4da\";a:1:{i:78;i:1;}s:32:\"e6ff344f14d9c1d5bbbb81b507d3f77c\";a:1:{i:108;i:1;}s:32:\"eff41c3c68e12de4f9807c2e687b4d31\";a:1:{i:76;i:1;}s:32:\"7924567780f50966c6087508a6bedd7e\";a:1:{i:82;i:2;}s:32:\"32b3b4678410566f43887907a6540845\";a:1:{i:71;i:1;}s:32:\"728467f55a048cf3cfcb118d5129687a\";a:1:{i:80;i:1;}s:32:\"ed3354bf1bd38a2b332eab9af5cc52fd\";a:4:{i:74;i:2;i:78;i:1;i:98;i:1;i:100;i:2;}s:32:\"642359ae0c0e0b2174916eec3f46f5a4\";a:1:{i:106;i:1;}s:32:\"c07dfa54e6bf3c6970ef806d7a055678\";a:2:{i:76;i:1;i:108;i:1;}s:32:\"61fdbf37776058816140014db3337234\";a:1:{i:71;i:1;}s:32:\"089a091fe1a3c56ca98ae3e5531fc065\";a:2:{i:71;i:1;i:74;i:1;}s:32:\"dddf2893084f4017cdf08bcba047419d\";a:1:{i:108;i:2;}s:32:\"06c1a3d1baa803ef80138e2b2f10a066\";a:1:{i:73;i:1;}s:32:\"2ec2c89fbc87ae2088ad11c67052e7a4\";a:1:{i:82;i:1;}s:32:\"677018e67c32cc68942b4f0ea5d81ebf\";a:1:{i:80;i:1;}s:32:\"c4dc74b4f36fa42f8aa9e5d299916c09\";a:1:{i:100;i:1;}s:32:\"5a80a6a713cdb460d2b86e9b8041ad7c\";a:1:{i:106;i:1;}s:32:\"9b93b71cd21e683a72e637bf348ea638\";a:1:{i:98;i:1;}s:32:\"6334a13c2b8abdafc8ec25edce6be786\";a:2:{i:76;i:1;i:108;i:4;}s:32:\"7bbbee2fa022435fb043a1138310dd05\";a:1:{i:74;i:1;}s:32:\"20d44a792a104c678df296da8bbfdb3b\";a:1:{i:106;i:1;}s:32:\"880afe1c6e0b82bb25e35af263eae598\";a:1:{i:98;i:1;}s:32:\"c5e09c166ba13a47e111772363f75108\";a:1:{i:82;i:1;}s:32:\"dcee133d7cce9be1d1fa29f2cb512eac\";a:4:{i:74;i:1;i:80;i:1;i:98;i:1;i:100;i:2;}s:32:\"5a896c46c5b007cb4705d68d70301d7a\";a:1:{i:98;i:1;}s:32:\"94d993617347bda1b969ec9d985eefa1\";a:1:{i:71;i:1;}s:32:\"967acafd1b595d880124323fd7daf693\";a:1:{i:82;i:1;}s:32:\"62d7c7d7d6c77f01ac7d287af5fa4e28\";a:0:{}s:32:\"d4dd056629bcfd30a01b7b3433b854f9\";a:2:{i:76;i:1;i:82;i:1;}s:32:\"2dc85c8f312b9148e472e9be2b37e5f2\";a:1:{i:98;i:1;}s:32:\"59d6b0b83f05e964627735157b4a9af2\";a:1:{i:74;i:1;}s:32:\"a049c35ae10c5eebda7d78c198f09aeb\";a:1:{i:108;i:1;}s:32:\"2725c9545085a1ab36e8e481754d3430\";a:1:{i:100;i:1;}s:32:\"3a988b7d616b48c4931c380f06cbd7a2\";a:1:{i:100;i:1;}s:32:\"41e5f773d41e4f8902c5cd2e2bbcbf1c\";a:2:{i:82;i:1;i:108;i:2;}s:32:\"e46dd1b2a18f25142816a9f0284278b9\";a:1:{i:106;i:1;}s:32:\"86520b38f0966c9773e5d339accaac95\";a:2:{i:71;i:1;i:106;i:1;}s:32:\"128e4235be46b48ecf0fda5356dc3b2d\";a:1:{i:100;i:1;}s:32:\"1286662ef4d0254c90206d433a16645f\";a:1:{i:100;i:1;}s:32:\"650648303c95a7329050b2377abbd1cf\";a:1:{i:82;i:1;}s:32:\"a6e89a84d6ef49eeed6f697d4fcfe755\";a:2:{i:76;i:1;i:108;i:1;}s:32:\"ad779fc92803de8480b776f11f828998\";a:0:{}s:32:\"8727d56807fa22861c55d848c55f7ab4\";a:1:{i:71;i:1;}}", "off");
INSERT INTO `wp_options` VALUES("2480720", "_transient_timeout_wc_products_onsale", "1765004604", "off");
INSERT INTO `wp_options` VALUES("2480721", "_transient_wc_products_onsale", "a:16:{i:0;i:19;i:1;i:22;i:2;i:31;i:3;i:34;i:4;i:37;i:5;i:56;i:6;i:67;i:7;i:280;i:8;i:292;i:9;i:293;i:10;i:295;i:11;i:296;i:12;i:297;i:13;i:2426;i:14;i:2428;i:15;i:50;}", "off");
INSERT INTO `wp_options` VALUES("2481242", "_transient_timeout_wc_layered_nav_counts_pa_color", "1762933925", "off");
INSERT INTO `wp_options` VALUES("2481243", "_transient_wc_layered_nav_counts_pa_color", "a:2108:{i:0;b:0;s:32:\"130716ee49ca516a7330cb12ec5d2886\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"7343d5b3828c3e929f68e5c8cd2fbe7e\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"e0839f049047569a7b20c8828cbafad1\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"b1b1bb028bd20c82fea05fae598c09d7\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:2;i:103;i:2;i:114;i:4;}s:32:\"71bac2753e6afcbe32269089d94e166f\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:114;i:6;}s:32:\"89b98c25d599635cc9387d2bb5eb9e38\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"2935971a9926aac54994f34f4784a038\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"3411a45b0aadc2659967cd1cad4e965e\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:114;i:8;}s:32:\"c0a67c36afbba0ded2d6c0126459939c\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"ee3878c4452b743399e33e7bf0cc4aba\";a:7:{i:69;i:2;i:70;i:2;i:84;i:3;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"9987dcaea78458c0c72dbff1f2faa5c0\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:14;i:103;i:4;i:105;i:2;i:114;i:16;}s:32:\"ee45685f71a20f2bbd23d68f5244950b\";a:0:{}s:32:\"c4a17255c8a04319208e87ade6b97691\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"839ff22d31eff863dcceda9f1d44fc6e\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"23943ced86add34d43518af83e9c3778\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:2;i:114;i:6;}s:32:\"f296ab9cafe4076877dac0c4c1eb346e\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:10;}s:32:\"10db079ded14142b0549e76330759a15\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"e82a0301a00558501f004e74f248d516\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"365ab70d6a975a4fda8b44305d910329\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:7;}s:32:\"ca45e798668b3ff5c3e242c33c246283\";a:6:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:3;}s:32:\"74146e9b101164d8d41aeae14adad8a4\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:8;}s:32:\"22cc0c766707aa333b4ace7b532d2284\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"1740b7aae9b6cecb5bda782cb810a86a\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"bf0759ea90e4084e6a9712ae5a981f35\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:1;i:114;i:4;}s:32:\"5d5777dfc6812ca4975c950b78c03d1b\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"cbe4ba38ed95fe3b0d283f027c32bd16\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"6cc53451322260bc7e9ccc8e43a7fe37\";a:5:{i:69;i:1;i:70;i:1;i:99;i:2;i:103;i:1;i:114;i:2;}s:32:\"9fbcd7db3086c5c8c0b88a4107f5934e\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:2;i:114;i:5;}s:32:\"82162c6d0e4b7a610cf80bedef89e431\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"5f3200c743c7ac00b68ac7387904e0b6\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:2;i:114;i:13;}s:32:\"26fe51d1be998dd7d268281bf148ef0d\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"bdb00f09d4302fc2235ad03641200169\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:114;i:9;}s:32:\"8ae4e99bacf6fc2ee46e69575a264cd9\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"59137e0d9a2e77abe58baabd30332935\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"ca4db84cd4a9d16bd269fed24f51f81c\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"541e481abe56d6e71da96f876dbae2b5\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"ae5c2d00a33bc1b2239b8dd0ae8211ea\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"5d51bbf8ddba2aadc95b5ee026e60aae\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"8c8d66fb5ac4e3901e284a9d7f202d11\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"3fbd0749690a56e3f820e1f1477d950a\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"451cd41b894b91757c9e2b7a1c2249e8\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"b1c049a5c61cf06771c9b588c565b3aa\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"58a2978a16e233ffc7fa5c8d1a6d5844\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:2;i:103;i:1;i:114;i:2;}s:32:\"ee220023f17216452f50f72c464aea50\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:2;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"b032d55feb1298111bf8503d6e0e5961\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"f82739932638654d81bce1e4f5012be1\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"0b2c96efb53fb53bdfd77390b7c771d6\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"2ef9bd7e9948434bdc78835dd75c6884\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"966a177672f12d900f9848ce00e5b639\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"a0cd924234447548d5e9117fd8dd9aed\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"b5402cc738c7dfd03dea26c087843c8f\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"6a9f991a66eaa55146aa69a82b952b6a\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"9cc76e8ed514873bc510b134c75327d0\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"122c5258cf2ba20aff66177ee6ff85c5\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"06ee7c5727ea5b9a27e02e770b7e500d\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"52d957190789dff38e843921f89547b4\";a:5:{i:69;i:1;i:90;i:1;i:99;i:2;i:103;i:1;i:114;i:6;}s:32:\"6b6570dd360da9c52eb765e91f6e6dfa\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"82ff7280f9f2834690ed3dc53274e799\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"2cb86b5e0478b9dde225901834dc0a43\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"15b6c7810629e4ba84c3461a55a354cc\";a:7:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"6b16013f18edcbd40526759a104078ec\";a:5:{i:69;i:1;i:84;i:2;i:99;i:1;i:105;i:1;i:114;i:1;}s:32:\"783f184308bc464305da44316a8f1497\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"f297d12a4aef7b16b768f7e3cee20cb8\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"a83fdc76e53677f4ccddcc4b447b3a2e\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"de90ce02ed7d9bddc20a1b57f8b70f19\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"80c68ebaa70aa0ba67e2410ed53baea9\";a:8:{i:69;i:1;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"6d677b563f8e227ed4f854341a88d94a\";a:6:{i:69;i:1;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"55b526a7ea745fd7389695829e9fe3cf\";a:5:{i:69;i:1;i:90;i:2;i:99;i:2;i:103;i:1;i:114;i:6;}s:32:\"657d97e027d2525d674f7368a65563e2\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"433a61404b959cb9852c549c62b00ed1\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:4;i:103;i:1;i:105;i:2;i:114;i:2;}s:32:\"15f84b0775e60d261aeb130554385900\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"667ba98ecd87483da57403e116c638c1\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:9;i:103;i:2;i:105;i:2;i:114;i:12;}s:32:\"c93d4678ed08f55966f12fd572e84833\";a:7:{i:69;i:1;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"202cf5abf015d6fce3c59d7c934d2b11\";a:7:{i:69;i:2;i:84;i:2;i:90;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:9;}s:32:\"a1e760947ae4977b36b0a1946bca51de\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"9933e25c0bf535e850a1beb9d9b48c90\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"3f4e4d6de80ab2152e46bd9611220b85\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"00f2ea91963371777e456cc951c490ef\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"16e19fc680342c5c1ee5057f392b48db\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"7ce95fb4221a635401ba3baca9e47e3c\";a:5:{i:69;i:1;i:70;i:2;i:99;i:5;i:103;i:2;i:114;i:5;}s:32:\"d71864c608c147a323560304386c7b85\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"a206d42ac4fb57edac57308783795bb8\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"8356794e69a885d2ae0b20001c506a51\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"29c9c4bd25fa370e6dda9ff3eed70d89\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:10;}s:32:\"b64fcb53f0af336f6a9fdcc0788e4750\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"99813506d9c5834bdb494ddadb503349\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"931da42ac7a4bbfb2ad1cbf9749feeb7\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"1cec284a18f1d144ec4655e76f43de2f\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:114;i:9;}s:32:\"2bb2eff47b08f3a2da6a6cb96c2bc607\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:2;i:103;i:2;i:114;i:5;}s:32:\"bf348fa72c91f4d15635fb3089f20590\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"df587311e6cc9d66e1193a36085d1879\";a:7:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"74ee1c1df4540bfc7219811dad7e7fb5\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"57c6779b5b289ca6abb5757c62b8bcc1\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"91c4778acb66ada6527f5fdeffb6e377\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"11bd732de82f88e99f914362fdc8f88f\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"44bda23ce247f22e3bde8562c9ab7366\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"6d0683f878e54c7836ce159041e55d4c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"bbcaf65a66c021daaf4797fb83eed18f\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:5;}s:32:\"578ed5652fac97303905b2966b7a551c\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"df84ac5d4c3b9381eaff33b7a502aad2\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"be9d92efd2c48d060357ed5720f89c52\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"d0b58aa46ad12a3822b8f8d3deff4f38\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:11;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"057765a0eedde43cd459fea16d06a6d1\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"e5468f625fdde1caca6b54060e52fd88\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"3764378dab7e9e9c03157786310c798f\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"9885b237e833912b2b05418153b04fde\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"d3dec4dfb985885aabd7bcd088507e8a\";a:2:{i:99;i:1;i:114;i:2;}s:32:\"a4cc9d06737dd287f23d3092d659c9be\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"167803a0c7d60e9f1cf08d0319d3240e\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:1;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"77dd918aa50e00583632604fc0eec9f5\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"a229780f47739147392a9ce6b67bfad3\";a:3:{i:99;i:3;i:105;i:1;i:114;i:1;}s:32:\"d8559e01ba3bc7b076a24f238174a8b1\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"95d511d612be78325772dfe1a107a3f5\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:114;i:8;}s:32:\"95f8aab67e9d98ed911aa6cf900f4e6b\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:10;}s:32:\"e0b97d0c527d8543c9551a0b9f9a1f5c\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:4;}s:32:\"cc01cd354ac549e122d4a3fc0393f721\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"6c74af52e2b81668a972bb5b478778d3\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:6;}s:32:\"cd74abb925589feea93262ce62f0ae05\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:5;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"4a7150efc62842afa9cc99e58603be0b\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:7;}s:32:\"a862701f4199f98ba63b86aa37ccf95b\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"92a5b5469e461d30ace3848c7bf5a4c1\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"fb8ea54252345bb9bcfa678d3a7d480a\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:8;}s:32:\"bb16019d37abbcb756d3e6a0c9a9b8b2\";a:5:{i:69;i:1;i:90;i:1;i:99;i:1;i:103;i:1;i:114;i:4;}s:32:\"5bedc219885bd26edf007fd22ff2677d\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"ae933dd1b96871dade3b31cccc2e639f\";a:6:{i:69;i:1;i:84;i:2;i:90;i:1;i:99;i:1;i:105;i:1;i:114;i:3;}s:32:\"fc4a8c2f67d1d39a19cf248217bee1a2\";a:5:{i:69;i:1;i:84;i:2;i:99;i:1;i:105;i:1;i:114;i:3;}s:32:\"80186b0fb161040308a6382b6e46e44a\";a:6:{i:69;i:1;i:90;i:2;i:99;i:6;i:103;i:1;i:105;i:1;i:114;i:8;}s:32:\"cdabc256bb33c86cdf4fbb0a97852dc2\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"3d7524f892b896a2c19f6ea9144fa0ff\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:8;}s:32:\"81c03ab0e2f36d017d33fa523287b73c\";a:8:{i:69;i:2;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:2;i:114;i:5;}s:32:\"d87dc0a8f04a86d321c465d35b59de75\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"31fcdb8a354e34db987b8f84829bcfd4\";a:2:{i:99;i:3;i:114;i:3;}s:32:\"0babc89b925f59f69dd9420be987ceb9\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"dc2d366cfda600fbcf763c27da08366b\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"a596baa00be019090854ae289d1fdf2e\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:4;i:103;i:2;i:114;i:8;}s:32:\"8af55509ef69e561c1b225685412672f\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"84dd3df7755eb25bad4012db7405c085\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:1;i:114;i:5;}s:32:\"381c08e5a2fb0d17eff9f5261b7ef63d\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"fe18cc0bfb6fbf3f143c1ff5d87b314c\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"074b985835c59f4d1394bc51b7a05ccd\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"3d8ae06e691364e7aefa697f73315318\";a:5:{i:69;i:1;i:90;i:1;i:99;i:3;i:103;i:1;i:114;i:6;}s:32:\"f5e7aa9b82b1baf377a2114397c474a8\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"afd26c681d4b6e501b0053ee1eaa4711\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"a2fefca05568c3a2c34e65a1eaba1e36\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"d3727f8cff31172f52cdaf3cb519a065\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"86d6f6dbbe86a3daa8e826964b89df46\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:11;i:103;i:3;i:105;i:2;i:114;i:13;}s:32:\"45b0baa8ceaf789cccda76eeff71349c\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:5;i:103;i:2;i:114;i:8;}s:32:\"13b7f405f00b1fbe5c463b7020902a23\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"bd849fd4c6c55ef70c5f8143326451bc\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:114;i:7;}s:32:\"3c4feea80cd86d0fb6acab548ecbeda5\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:4;i:105;i:1;i:114;i:7;}s:32:\"5e75a678b513d043a9aa8f00e4171d50\";a:5:{i:69;i:1;i:84;i:2;i:99;i:3;i:105;i:2;i:114;i:3;}s:32:\"67bffa206c648c92dd44758873573027\";a:8:{i:69;i:1;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"dde0a7ccb0db480cea70e127923943a2\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"f736e9fa7df1d4b23160a2d34202983d\";a:5:{i:69;i:1;i:70;i:2;i:99;i:5;i:103;i:2;i:114;i:3;}s:32:\"5ccb2d4609bb0e7ab15d77b09061cc08\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"9c616b7fa1b0b19bcbfea13b00e48951\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"ace9f8a71a617d57c2d1dc91ced160b3\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"569e4477cc7b355bf01c038fcfc9e51a\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:114;i:7;}s:32:\"7b6050370142096a0c7718a3d6e38995\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"99a6a360d61a0895b9be44f7a881d68e\";a:7:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"d9ea0428abf9b25226ed7a6d9567b1ca\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"f6d960749baf4b990c0ac07a3ecd5871\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"e461e5f17d1f7f2902e2bb829667549e\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"269b20079a6684686778aa1555c06f39\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"5d54a7ebc214978d402d3b2700f29e83\";a:6:{i:69;i:1;i:70;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"1899e27cccacaf5d51dec5c9ed13d50a\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"2916a9798cbce348cf8ccfc43e3a0ca5\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:5;i:103;i:2;i:114;i:8;}s:32:\"81673465905a750d2e753101a2ba68d2\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"28ddb982923e99c27b2c52bbbfdd814d\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"30a095cec8425852666fe7e9c318b88b\";a:8:{i:69;i:1;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"421b622bb6d704bd06681a2415615a48\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"7023e05a76cbfdbd3b775ba324e690ff\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"8d470bc1f5813d3b02cb30e1cfadfa22\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"9d89e155f4586c55468c8a04240ead59\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"0f38c0942b37628585a09ff0d12b4ebf\";a:7:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"2a5e09a7c0fd0c75ac75bd3e9edcda76\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:3;}s:32:\"63e8df259c28ab6cba45d49af9fa67cd\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:2;i:114;i:6;}s:32:\"e9053cd227047d6ced6ae06b21024a93\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"cd2dbaabd86e6b8fc8c466371c967261\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"8f4545b8e8ef8e26068fad005dfbf27a\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:3;i:103;i:2;i:114;i:7;}s:32:\"bad3782c39ce97c3fcd27f45e57a061f\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"60f8ebb0795e4f121ef9ff5924327fc3\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"5e66be9cdcee6ac990fa882b7ddfc899\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"7cce02d85618ff8711872dd2a6761f8d\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:12;i:103;i:4;i:105;i:2;i:114;i:13;}s:32:\"f7fbd3df48151e36bcae6305227263c7\";a:2:{i:99;i:2;i:114;i:2;}s:32:\"3352d801c1ac5a52fb02fba9457e5d42\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:1;}s:32:\"886e3b6eed66fad7565283d0066f484e\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"4c5081c712d4235aa4ef5fb2259c58c6\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"4411ea25c9c6e138ed26ccc8785e38ca\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"6bde81ada7891a8638ca56872b5e1b05\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"6feead1c39340d802eeffffda8f0db86\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"e92d95b37befaaa1466c0ab0e605fcc9\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"143e384b3465c1ee3be920d90cdc78c4\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"b7a17dfabe788efb5cea71a1395a1d89\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"9c5bf1dbb383d655e23c4efce5451cc9\";a:5:{i:69;i:1;i:70;i:1;i:99;i:3;i:103;i:1;i:114;i:3;}s:32:\"3931d9d27846bf55a063d2fc94826476\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"31ff6ee4279b9c3253b59ecdd675592b\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"2a59b91347171e6f5ecc4a8e07ee6342\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"3e77e9da355ccea05d3e8acd6c48db31\";a:5:{i:69;i:1;i:84;i:2;i:99;i:2;i:105;i:1;i:114;i:4;}s:32:\"59ceea8a8555eaeb7dab26378b9258a5\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"8c075dfc974f524143ede38602a73696\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:7;i:103;i:1;i:105;i:2;i:114;i:5;}s:32:\"c0af0c34beddbefd72496a2a7e2c6868\";a:8:{i:69;i:1;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"c43ab8294abdc9b525a04b4237db5a35\";a:7:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:6;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"4671ed01a689331902d1301cf673d8f9\";a:6:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:7;i:103;i:3;i:114;i:10;}s:32:\"4606938147815c5e37322078c5ebad5e\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"a31bedffc3a50d5f4e80001fd0522937\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"5f432d695f3bf623455ec9d5274c7885\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:8;}s:32:\"561838c5cdc119eed54d81d384f7aef5\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"4b43c94e9331d73bd8f985a2dd888eae\";a:8:{i:69;i:2;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"1f481a0a2a91741f4f9d47c4f42293cb\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:7;}s:32:\"566d52496e989d9f68e72be9dd54d590\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"01e5798b188de25ba4f44e4cef129b6a\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"868a8109370648ecb05b7cf6fd6f1e55\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"cdeabb1ba4b5e1bb48ab447c5802fb51\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"878aa10ce51323079fc963248c9ec006\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:5;}s:32:\"cf782e89c8b2f2d9f8b1a6db6c607bdf\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"4d1c7a3298377b93cf158d537ab7de82\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:1;}s:32:\"b783ead5a8a49aaa9a26fcace3e0a135\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"0af0ac1ab41bb712d49e3de509cf090b\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"43069b1be8e71f60f6d796da65c82738\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"510047f85de84ce3dd39dd98eba7ddff\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"97a247ab3169f2c7c2b2e68199cd209c\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"a45439897a37c8e35058cfb777f8cb01\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"d96b4cdc4c563e338527ab8587b2e92b\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:4;}s:32:\"81323365a898fc79d5896365773ecebb\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"5dda883acbc91edfcb0c3cfa12d1b1ee\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"f02cdf87910171e47e8223b09b39e5ca\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"73484ad1e10b5fa9e0128b72d075f3d3\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"179e1339687c31282c63fd2723411a49\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"20df9b1162dbd5a1a662e9cf8fa7311f\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"ac6794f0454301204574eff0b58e9f80\";a:6:{i:69;i:1;i:70;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"3ee1bb35c56536aebf4608c0bf4c2db7\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"140573301ec523fd27a86ab8a24324cd\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"9f1ba451f438c7b9a518926e86956148\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"45a35cf59cb4af14cb1619e9e7429a96\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"73334a6ba706671076a87648b923af9f\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:7;}s:32:\"d8b4c47ec1c1da8bffe8c8d16c6ad523\";a:7:{i:69;i:1;i:70;i:2;i:84;i:1;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"67cd0edaf6d8f2e3d79f36f1e89049ae\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"6c7a620f1485ffc5dfc9ad51bd016ba8\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"c09c61e0d97e178840baae84bd7b45ce\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"3c5a2f819dfed7dc286daa771c9786f9\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"a3ea4d3ac02b69f036e9ea7a0daf26b4\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:114;i:9;}s:32:\"9945b7d418f498ab13670422532e4bd6\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"1bf0f16dd920f2a2dd93eda1edf90f5c\";a:5:{i:69;i:1;i:90;i:2;i:99;i:1;i:103;i:1;i:114;i:5;}s:32:\"c6a85722834f57598cdaf1517cd372f5\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"71c4387a329b0eda676316500f5c0858\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"8aace575f46f68ee3559bbbbf8ac2698\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:1;i:114;i:4;}s:32:\"cc58b6532668c6225fe695b44e0e7af8\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"b51fcfd6a3b7eb02674ef8a9adeaf244\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"c97d64ebf5b4e5e61abaaa4d981ba9f8\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:3;}s:32:\"d72e02e5934e950c88e6c2e99dbd5281\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"ba48f6a231e03708ad635edf36809a5b\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"3dced0c2f30d6992e1e24c078e7fb880\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"4331c0f13d9883f54aceeb7f432a189d\";a:6:{i:69;i:1;i:84;i:2;i:90;i:1;i:99;i:1;i:105;i:1;i:114;i:2;}s:32:\"45d0313104a65230c424fb945c6b79d5\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"25de2bfd66ca8a51411ae9d5cc5a8d0f\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"17a8a3486213a729bce89bb0fb259dac\";a:7:{i:69;i:2;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:9;}s:32:\"b2113e061c83be77ecd0021aee7f10ab\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"409ddd6da05f2d4a83751a945ce9bb4b\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:4;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"c914798d57082ff2f500b5f1f2e00a52\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:2;}s:32:\"51559730c266b5e26d5f8bcb5e67a982\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"cb5b9b9e12c5ec4f9ecc74da1a37d2e6\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"ab1f9e2d06a2bc06dc0893d851ab1976\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"2985b6f4ba16c7e8a15a76b96c29e029\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"0bbad9166048021157061fc0a0ea3489\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"495fef27ab03613d6d5575c49bf8073b\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"6ea41300060a5b361e9e928a1e59ce32\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"931a8a3fe3dfcec858cad48bd5681b3c\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"ba48c76969a31dc4e6d1e0b842e99581\";a:8:{i:69;i:2;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"bbb7c1b7d87dea1071870e11411489c7\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"fe218d61f5063e4bada8cfb9119aa6f7\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:5;}s:32:\"723051a024bfe37a69aa42e1bc60e23b\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"14d706199e84ce72fde4485289c9eae0\";a:5:{i:69;i:1;i:70;i:2;i:99;i:4;i:103;i:2;i:114;i:2;}s:32:\"f6547b543422b23772307681c52d8a71\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:1;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"17fc3a266a2ef0f200a0865463d48a50\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"34261423b9f0f7d26d628fca68749a40\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"166e25d41808a134af6a4f27b1ac963f\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:5;}s:32:\"ebdf2a9f1db75ae32d0bfd6a547899d6\";a:6:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:5;i:103;i:3;i:114;i:9;}s:32:\"686e608645da3a7dd896ee01c8654d47\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"05bd33309de4f20678831193de83bdd5\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"678d2fe2042e4a3aa5442ddbd13dee7e\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:3;}s:32:\"8890bb7e5e15255de6af93986981fdea\";a:4:{i:70;i:1;i:90;i:1;i:99;i:2;i:114;i:3;}s:32:\"959e84407d9f4a09c15a662a9f4caaa1\";a:7:{i:69;i:1;i:70;i:1;i:84;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"69784025452d46154b1bab94f742a8dc\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"3a3490df0b2ed60fa31c911230976685\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"6ca1f82a9b4fb6905c5b819e0f734ddc\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"85c840d1790087f046b6dceb741517ea\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:1;}s:32:\"5199332f9f7248d02bd404ef31102b1c\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"aa720e236adf92fe737f6e655cf1c599\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"845663868e3f517279108d8329d8c304\";a:7:{i:69;i:1;i:70;i:1;i:84;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"7b400d23be65f0e29d0006921515b1d8\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"52c4ce709fdab53699af66aaf03a77e8\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"7d1ccd9704b1b58113dfa930bd520789\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"0b8343ae10057cb6fc041323edd8fcd9\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"617278f86ce2eff328ead5a2d3da2371\";a:6:{i:69;i:1;i:90;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"69059aff9ae4460f26aa59322e7b1619\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"99c2c58f3a0eff0e64706d3d2207d4ed\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"4f76073af0f74b21b8194815da5f7cc2\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"b5537ac8135809b035e2f276742b519e\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"02bbdb2c0c5103f66859264acf52f812\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"a20f47e94d62474028fb51a3102c3397\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"ac30fe12bff3ed18338bf146a176f250\";a:8:{i:69;i:1;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"0a1893435166abaa79b965d33c641909\";a:7:{i:69;i:2;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:9;}s:32:\"61a1a0d106430f847f0e5d3ad7057521\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"989a693ad971c0790ac6133d0beb06ad\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"1d84c3f7768bdd8f491fdd5ff03f0001\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"15c2fb08279c6fc275ab15aa5c012d6d\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:8;i:103;i:1;i:105;i:2;i:114;i:6;}s:32:\"406f16ac32b8f8b73553cfebb04af99e\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"20ed7bc96fbb73ce8ab7f0ed80bb9aa0\";a:6:{i:69;i:1;i:90;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:7;}s:32:\"270ec128112f2b138dc163f97e99b7e9\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"6eaee037f58afce5a48431e2a49c1255\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"b45e59e579e2c99cd1da1171ec2050ad\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"6a3e76e95a6f6d5908099b107e2a563a\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"9990e385f80cf30b8d5ef8a7a4ce7a76\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"11490500778a96acce3540fe63bb35c2\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:9;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"3108a7890b8bd86fa11a8c00a468ec32\";a:4:{i:70;i:1;i:99;i:4;i:103;i:1;i:114;i:5;}s:32:\"1b45a4fc265595242303d9e2c384d17d\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:13;}s:32:\"edd049c2d6348a60352b04bbf6218f62\";a:8:{i:69;i:2;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:6;}s:32:\"13fdf1ef11698da111831392300e106c\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"93649109682c1dbf41fac4e39a7bffdb\";a:7:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"7864927b4566b942fc1d75a98544e7d7\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"79618ccafdc06942309954994ea69f0f\";a:5:{i:69;i:1;i:70;i:2;i:99;i:4;i:103;i:2;i:114;i:3;}s:32:\"eed4ec5b607b2ed643d57411884b9787\";a:8:{i:69;i:1;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"1156a85e2e683fc2802aacdfe3032732\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:7;}s:32:\"cd21eb0842f5056665d4b840ac17f6d0\";a:4:{i:69;i:1;i:70;i:1;i:99;i:1;i:103;i:1;}s:32:\"af159b5a09dcff6e2925480ee092141b\";a:1:{i:99;i:1;}s:32:\"fd7862adf1fd052741c9001c1282a9a1\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"c49be069273362da074ef4937361d933\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"81d404dc3e2aa8b32fcbb30d3803ac97\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"c143179e6e6ca66937bdc679f24b2970\";a:8:{i:69;i:2;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"bf82b9f886f6f999d5726f0036527c4f\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"d81958189551ab9f2dc07842da324ec9\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:2;i:114;i:13;}s:32:\"97de9474fb22b444d13788210b3ceea4\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:11;}s:32:\"f7ed3c489e7b18199029f05c185d98cf\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"936c959b8dbf4861df04e6b3fee95228\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"f863e11d1f6f762d031e6710e85f6c36\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"d5fd0d734119bc595fed126b6f6dceff\";a:6:{i:69;i:1;i:70;i:1;i:90;i:2;i:99;i:6;i:103;i:2;i:114;i:9;}s:32:\"42772629a610be879b24ed1b80cc2b53\";a:8:{i:69;i:1;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:7;}s:32:\"6a70f556bf1b344f377edf8ec056c5ca\";a:8:{i:69;i:2;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:6;}s:32:\"ee5bb970fb88f35bb82e067fedc4c2ec\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:2;i:103;i:2;i:114;i:4;}s:32:\"951d9dcded0afa850dec2737ee8a87ff\";a:5:{i:69;i:1;i:90;i:1;i:99;i:1;i:103;i:1;i:114;i:4;}s:32:\"dea08352750d3b6ee4ecb9c95d724d2f\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"ecfb9503adda43142ecc0acd45c89236\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"367fb316f2d4834638899cd734863c76\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"91db2d07781239ef50c329eba7fa67dc\";a:5:{i:69;i:1;i:70;i:1;i:99;i:4;i:103;i:1;i:114;i:2;}s:32:\"9eea870e39a1a30e14d90632c9af9abf\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"c79a8ec3bfd9826ba574fe78002d865e\";a:7:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"ff1e7b4d4ab0d8943ba2cd445314303e\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"e080d0fe98af0e8764f3a2dbe63baf33\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:11;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"c48e47c771381b11c1ef4a2a9f5722a5\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"8d75589259ff13d8550ea0554e89db57\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"897814cf0c90c758ff56ceb21ebfebda\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"cc321f3c6852c1d59249b16133525002\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"dd89fafa28b48447b9b8a40ef2528b39\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:114;i:7;}s:32:\"b9e84dcadb415e228f78718cf32e524e\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"7ae334a9ceb2edc1212f2a0ccee565a6\";a:5:{i:69;i:1;i:70;i:1;i:99;i:2;i:103;i:1;i:114;i:1;}s:32:\"5b3dcf90a99d305b8a093257d62f79da\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:6;}s:32:\"886787c1934b5bf3587f59c572c4eaf4\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"842274e7322761d1b8eff8b86ff5ebc7\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"746b6869c8f689ba07db4b6e747ce20d\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"e4942101c937e48012aae5b2c630af11\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"419c52ccac86866f6140184c407dca50\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"6d0a60f52d3e5dab807fa023d5a6dbe0\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"b0808c1d3f2eae52009a1df09a16535a\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"befb563ff69e43c14c02fac2a8d94384\";a:4:{i:69;i:1;i:84;i:2;i:105;i:1;i:114;i:1;}s:32:\"b4ab3eddac0261add8fbdb074f58581d\";a:7:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:7;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"650f6e5a9ff5114c328a79071b02c449\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"d66ba8b8cb523c997e4e96277381b5b2\";a:7:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"e80b7b8fe293631c4f756b14f364ff74\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:12;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"7aa041dff28998690992ef9402bad8f8\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"1c41132c6696382056af1de0c799979d\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:1;i:114;i:4;}s:32:\"ac15242a97767e9d02e07f4918a5688c\";a:5:{i:69;i:1;i:70;i:2;i:99;i:3;i:103;i:2;i:114;i:2;}s:32:\"b66cef6e1506dac6a7a9878aecc5eab2\";a:7:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"fa579880e479a05599bb00a05352299d\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"2aad2a335244bdc5df99ce98704269a5\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"4f5966767898cbfa7d4b6dfdbe3b889d\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"4f9bb25678e3f141451f7b7bd39b0dbf\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"44be4ebe49778d56f45085b2456e6540\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"5719a57f088792afdfca474cb424dc8d\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"35521b90d2f9fe182f350474f01683ea\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"9656849b4391e85d1eab361b46010a10\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:2;i:114;i:7;}s:32:\"828390a10ff19972d6563df951127562\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"70fdd41b42b9a19bc58ec25982620c6e\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"e68c1554127732105ff33a019ee3d40a\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"a351760c69b008774bb48a3da31a39bf\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:114;i:9;}s:32:\"338881ed31a31395e277a5c6cb72550c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"2f93e87d2265e448a074add90cb95187\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"a99e23f603d899cd018ff169e54f428f\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"dfb56f490e912d3664cd4564e1969e30\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:5;}s:32:\"77528fd5541000df57c7bdb80c7c9017\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"87f4e9f2e1fa87ec1b1cf82302fb704a\";a:7:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"26c5f08fbe2660893f5b71787f5e8609\";a:6:{i:69;i:1;i:84;i:2;i:90;i:1;i:99;i:2;i:105;i:1;i:114;i:5;}s:32:\"afa4eeac65394147f7b456c059930e27\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:12;}s:32:\"4997cd7b823bd98e4e0e65095e5b552c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"ee847efca79eed7f7056dc81b0a7fd58\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"73ae15737caff6fe681f9d3b7be9c7c3\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"9b4a6ff310a3d58e0cf7cc70775b2089\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"4b4e30f59663faac5aaf46fdf181cbc8\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"8926f92f9df3b6e0a3a29a3e9a667626\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"c1f77ad1dcb3f9897ba4a2ff7cdc130c\";a:6:{i:69;i:1;i:70;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"c33465df099a5a1edd5c72dbd25fdd80\";a:5:{i:69;i:1;i:70;i:1;i:99;i:3;i:103;i:1;i:114;i:3;}s:32:\"5bee3f3a29a92d7f4c811edab2731e5c\";a:7:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"ebcd7d7570e6d12f2c5afacb887af30a\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"9c9f9924a828de91563556459d374019\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"8f5d9ff85f8ab46200c497a04283f67e\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"35dfb4e4ddfd2750ec3375d2bcb161aa\";a:5:{i:69;i:1;i:90;i:1;i:99;i:2;i:103;i:1;i:114;i:4;}s:32:\"5911ca4bc501dbc3eefe3a5f651a25a1\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:11;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"6b83cdd5f16df880fb9b2aef465af028\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"57d1a7b73740b1759e78cda352a5eea3\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"70211b55f387c707cf58736fd70d8020\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:4;}s:32:\"ec1f23bb5d71bee3aa9e766c39e3e0ae\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:2;i:105;i:1;i:114;i:10;}s:32:\"1975df9d979f205628a2cf556290b4ec\";a:7:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"9cce2adad5b37108e217b58e943a0112\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"53b7e69f4867aff8b9ae42ef2c3f0a90\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"2c2f8eaffb3178d7c2bdac867489df76\";a:7:{i:69;i:2;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:10;}s:32:\"2453d13379abea7bfbd40354a90c9e8f\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"a07faf97256de4b29063e965c7f7fc59\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"fd26835c823f2062fea653a7d185cc6c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"3486d4f3236abb87ad66901ca1c89d4c\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:10;}s:32:\"1f0ff8d00c7355fe5926b35a803081fe\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"241e86605e975ce2f5ff80feaa722b6e\";a:3:{i:90;i:1;i:99;i:2;i:114;i:3;}s:32:\"48e7b149fe3bd4fec85adf8686c0f3e5\";a:7:{i:69;i:2;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"2e90c6683cacde9fdd5ef3a085bc28c8\";a:2:{i:99;i:1;i:114;i:1;}s:32:\"191de236b7b2d1528358ee238a2d5482\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"52ffb95a3a917d3d327a2709a50b9f84\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"a16dc6e663269d87f1d1ea95561d6c47\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"ab50b593250b264368861599c9fd48ed\";a:7:{i:69;i:1;i:70;i:1;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"cc9abc63e24669b0d75a8935c220bd89\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"4fa572b10fcfac65cfa1494fffd1c142\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"1cb4d07f9adb8ce7647dc1953c4a0c68\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"67e879041d4c137429929ff4e1b7a8f7\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:7;}s:32:\"a14874ca343c8318978dadf1d2d46909\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"317c4d86197ccbefdd0584d0a6b494b6\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"0203acdf852b355eead29a4dbec24e44\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"e501d75820b5e9beb5b115ef8836a553\";a:6:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:6;i:103;i:3;i:114;i:8;}s:32:\"74508814d466f3051c9f0ee1eb771890\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"ab86b2be762970a64217bfb2465efc96\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"b870cb5369e27448a4984f569cd40916\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"eaafec46c6600377b335947795ba1428\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"4941c3635fb9ab5671bb0d714265813a\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"8c4879a5f92ee509c933130bdbee7186\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"2a5f736bc08e69e9c1b306c9bc1e88af\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"2efc5cc9c42303717a084a899b585cf4\";a:5:{i:69;i:1;i:90;i:1;i:99;i:2;i:103;i:1;i:114;i:5;}s:32:\"7f83592ed4d6cf81a3f4173274bf6212\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"7594a14fd883019cff148aedb706e80c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"2fb1abab6a08ab7cf94305e6e03d29b8\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:7;}s:32:\"e3eecf122c938aed9411aaa2e663d72c\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:12;}s:32:\"657010388a8570b8f46cd8c67b4a381d\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"ee7e30681ad2fcb74c88aef89fca5cb4\";a:7:{i:69;i:1;i:70;i:1;i:84;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"bceef4c44968c57df04d48b399d23e00\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:13;}s:32:\"d081d336a180cb7cd6d042b484ca38cc\";a:5:{i:69;i:1;i:70;i:1;i:99;i:4;i:103;i:1;i:114;i:3;}s:32:\"aa483fabd4cd17b473e24c00f18fe2e4\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"2f324d89f78791df6a5e31ad7d4700b4\";a:5:{i:69;i:1;i:90;i:2;i:99;i:3;i:103;i:1;i:114;i:8;}s:32:\"0eefdc52ea70dad42d5a45739e5b6822\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"1961429f2255a6687735f8dc279773be\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"dff4dcc1ca80b2e44c75180782090121\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"7dc547d304e137a07354ee65fee88830\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"a79d91aa9a2226c45707ef3141fdcaa5\";a:7:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"c3c54d5deb3dc9dc699d9c9f75348c9b\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"d467b268c07e12b4cec50314772b8381\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"682450b0d0534b7ec888abc4f1b45ed9\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"352f4cc5112c02ee69e0cf0430577308\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"71a73dcd83815b4131d97101b3762b70\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"af2c1a037da9f42bb462cbdd660b30a4\";a:5:{i:69;i:1;i:90;i:1;i:99;i:3;i:103;i:1;i:114;i:6;}s:32:\"c09627e1f605e81cbcfa0244050d9719\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"2996ec00681ac0f161d229c461b50fae\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"061b3c10afccba5ec746053a360bc099\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"72b7141bbbab62b7146156ef2f16eb55\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"64c50b16d8d6ce9e00d2305565aca87a\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"a081fc453e4327716b60d1c901ffbda9\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:3;}s:32:\"a4aa84e12371e5500635fdab387565a9\";a:7:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"5053690258924a8d0779d4fa4ac6e32a\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"34c4f7eaf9c6559656952259f5f405c4\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:3;}s:32:\"83b00a11658e5da32a0590757a5557df\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"823873e91dda45c22c99c2a7689f47b6\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:10;}s:32:\"e6bdfcf93ed334dea4701d932e8896a0\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"fd1fac97e84449060092c8f75a60b418\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"bca518bda1f258146fb9a96a905d86f2\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:4;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"e1b3043c9322651ae8aa28c5bbb45f8a\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"ce6d747dbf841c60759d7cdb324c62b7\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"53b41778fe7280a9303a975b25c213b0\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"01347b965d091cb8d8a77082796e7ee9\";a:3:{i:90;i:1;i:99;i:4;i:114;i:5;}s:32:\"ed24acac9fb48a507f6186788894f0ab\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"04544a3684119b0c9a81793d6804c54a\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"230074ac30c2030e4a07c4e89d19cacf\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:11;}s:32:\"3dbc388db83c81676479d5cf56340191\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"3c8a7ff604244b2afde1c028d8d9e191\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"6c2428ccd7b44c7da0497485d39dae92\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"ccb1fa136776e5ccb6721ac8da4a0352\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"319893a212eb063e9510039bf9de1361\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:3;i:103;i:2;i:114;i:5;}s:32:\"249059f27b022995cbb6bdcad7490303\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:114;i:7;}s:32:\"7ab1ff549bc07ac4847680ed6b264c94\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:3;i:103;i:2;i:114;i:7;}s:32:\"2f76a67519d7e426bf926a4c12cd6a67\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"2768c12ffcb874694b9a78ea361022a4\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"51174dc1087d67ac02ecbe403fb18fe2\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"23bdc0d534bccc08219567ea448116ff\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"2e718d83312f9561c073d79e4f13f7c8\";a:5:{i:69;i:1;i:84;i:2;i:90;i:1;i:105;i:1;i:114;i:2;}s:32:\"f98ab9869f935555482e4f3780ccf125\";a:5:{i:69;i:1;i:70;i:2;i:99;i:4;i:103;i:2;i:114;i:4;}s:32:\"0e7d7bd21713871e2eecb1bd3d24ae83\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"db40e41950078a8b6c1a2f60ffeb3989\";a:4:{i:70;i:1;i:99;i:3;i:103;i:1;i:114;i:4;}s:32:\"2fd01ff13e2ac3749aaef323636d4a1b\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"00a196097bcc319ec4b8890e9ca6b077\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"6113e5ebd5c6f5f43149f1c8999a2282\";a:4:{i:69;i:1;i:70;i:1;i:99;i:2;i:103;i:1;}s:32:\"10151e81a0334094c420e359477114d3\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"2bb898b2a11b1a063d22f1465f97d811\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"178c3dabfb85f11033a45aa815f377cc\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"c708d09540432e97ae9822040c5c74a6\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:4;i:103;i:2;i:105;i:2;i:114;i:2;}s:32:\"6d7ba065a9d447158cd60e74e59f8986\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"b0d0511f04b411d6d45eedb0d3896747\";a:5:{i:69;i:1;i:84;i:2;i:99;i:1;i:105;i:1;i:114;i:2;}s:32:\"3a38cbde5c81273d0c081fbeec3efd09\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:1;i:114;i:12;}s:32:\"c7677281fb8b080255f408ee83d7f763\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"b3da0ec68460c4b053b3286b9fb5537d\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:7;}s:32:\"5ee8004bfc8fdba0f2eb60818e629557\";a:6:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:7;i:103;i:3;i:114;i:11;}s:32:\"9c15cca8577430f809d064013aa8c196\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"75630ff1c4ea510e02d20f7686c87391\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:10;}s:32:\"b6185a7ea29c92ec6562d6c28d330883\";a:8:{i:69;i:1;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:1;i:105;i:2;i:114;i:8;}s:32:\"29ccaae0789a152d43a47bbed21035cc\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"92ad6cb7be2316cdee4f3719d2520859\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"fd834698e79711695ba1038624c2f7df\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"8abe29b5c829eaa9eb1a07c7eccaebd3\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"06c74f0d5b3bfc678ab762054f4f2d2a\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"5af705c2191271c8b1079b24adb20d82\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"f566fa86873b0d4365e18319d860922e\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"2dac5c95da0b30226d84bd1db0accb38\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"2739a76cc4e8f0cd369d390e0cb23dea\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"5bf61dfdaa91e6fb608d8cd88e0f2c44\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"df0bb4c7b7f78ed16458c877d7eb48af\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:8;}s:32:\"19a8ae89dc71e98307c151866a4af032\";a:4:{i:90;i:1;i:99;i:4;i:105;i:1;i:114;i:2;}s:32:\"b24a19a9a1164b63e7ed392ec4242c58\";a:2:{i:99;i:2;i:114;i:3;}s:32:\"90f92ff0190e77ac9a0472927daa1b53\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"585cea232d279f087c34f1e4a97ccffe\";a:5:{i:69;i:1;i:70;i:1;i:99;i:3;i:103;i:1;i:114;i:2;}s:32:\"8b75fb2a44f0a2739ae87ade3fb5ea13\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"7a2d268790f17e1c36af047ea04461f2\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"8f0fff55a68631115ace2c551ced63a9\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"ca317bcd9ef28deefec4ef0dc4b9cc52\";a:2:{i:99;i:1;i:114;i:2;}s:32:\"41e1c0b785868e649a2b136e7a5c9064\";a:5:{i:69;i:1;i:84;i:2;i:99;i:3;i:105;i:1;i:114;i:4;}s:32:\"53e66dbb9024a1c472b6adf52bd19e12\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:1;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"676338ec34f132db98e2ecfecaed1f57\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"dfbf6930933e8f7267002370df23dd7e\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"64067818801443c4ecb2e44efdf32e8b\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"b37df142b07ab508db0151c43607f338\";a:6:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:114;i:6;}s:32:\"46a4238a2639eb8a9ec2dc7f975d8bce\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:3;}s:32:\"a029cc176e1f8125df330e2ff0403907\";a:6:{i:69;i:1;i:70;i:1;i:90;i:2;i:99;i:3;i:103;i:2;i:114;i:7;}s:32:\"ee5000200caea5ba6dca543fe8b9140e\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"b7b9d5876aed287840168f1855ba048a\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"72bc79e68bb69d2bd7d73581032dbeb0\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"6b98040ec0a731c5c884a0aa3199bb34\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:2;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"20721377514c3dcd6f22f46c6dac4eb6\";a:7:{i:69;i:1;i:70;i:1;i:84;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"1d9ec134c8e88b5efeff84041f083368\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"5694d4d805214ba54e99602157943704\";a:6:{i:69;i:1;i:70;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"384d578e1bbe8a8fb998461247a30630\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"b84a6a6132d4b093b0e366fbb22e9b48\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"25610a9423a6eda75ebf3c6fd6f24e67\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"77f72d3915d44f5f735a682cb9cdc2c5\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:114;i:7;}s:32:\"620085116d0166a8846aa358cac94afa\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:4;i:103;i:3;i:114;i:6;}s:32:\"77939aec9fb0947319cbecdde8fc172e\";a:7:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"fb5c4d10b613804857c77f6b7c5a7125\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"30c12b8e3a9aaeb1a14bf7536ff473de\";a:3:{i:99;i:4;i:105;i:1;i:114;i:2;}s:32:\"c0c6c3298c734d10684af7278bb98cee\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"6b437b7b546955f78fc56c4964de30d5\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:6;}s:32:\"d60c5cdd0fc6ce998554d04c96e19c1c\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"4534f2766361b9a5da92a91c4a6dcb69\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:3;}s:32:\"eed80b0373631c4c34487dda027a06ed\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"bbc06330e9cf40d1b0ff42500cfc886b\";a:7:{i:69;i:1;i:70;i:1;i:90;i:2;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:10;}s:32:\"992154cfeea922a020d8a55a8832b6c2\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"b3212954df65167419250a351dd48a86\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"256c424d941028b41f8b295846357f6d\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"79d7caf16c7558dc82bec5607afa03dd\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"815796252bdff7bf705cf8369e1ded28\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"6bd786e978968e2db867b3d1f3f3272d\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"bfe3b7d13a10bdc2f3cf7d0c68344da9\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"17ce3b874fcd9738ed01ae28d9d2b0e4\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"0939bb1f7c527f54219eedbc616af578\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"ad78f61ad6efe286822e15f4b52255d5\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"3a9e7ca7959c413614c74b45d1db1075\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"f1bae5a5f49bd280cf6099a06d3f4260\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:3;}s:32:\"b520682599267ff2bb91ee87edadda41\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"7f2e3ab3f77a6b2ae2d3431e4865f196\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"73ad44f322e40461376747d944ee539a\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"ef342ca1384493c97e4d03dc9eaba353\";a:6:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:114;i:5;}s:32:\"6ddd42ae1130bf4dc8800035c313b47e\";a:6:{i:69;i:1;i:70;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"165306eede78215f99864627d7cb8de5\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:4;i:105;i:1;i:114;i:7;}s:32:\"f6b601ed898b5fa9febaa320a6b95715\";a:7:{i:69;i:1;i:70;i:1;i:84;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"c8eaedd434154162b67eadac7a567e84\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:10;}s:32:\"f3c4fbbe3b149fabfcca33f265fb555e\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"b09b6ab1857e901e93d888990b1ebe79\";a:5:{i:69;i:1;i:70;i:2;i:99;i:7;i:103;i:2;i:114;i:6;}s:32:\"46aa2e7a9d4872c3ed0a54a205d876ff\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"6abaaf1814279c4e3af54c75037daf94\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"3fadf03bde9cce3a9583fee938e4fbb3\";a:6:{i:69;i:1;i:70;i:1;i:90;i:2;i:99;i:4;i:103;i:2;i:114;i:8;}s:32:\"fd46bfe8e9f2ce0a2ff14ae8eb17098d\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:2;i:114;i:3;}s:32:\"dab38d678d913c2d50fc1dfe2d40c910\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"ae65b3b884801ef62d32527ef7cd3e1c\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"7ad4f760c75078177240d7ab5f2d7904\";a:3:{i:90;i:1;i:99;i:1;i:114;i:1;}s:32:\"abcd308e628739bd369f0ec8aff0995b\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"71cf9c9450af527b5e9084ed4b9c5bf9\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"213add8f1a082326b54aed1bf1646edf\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"28085ea842024c327cfa2200419d84c9\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"e8c3c8ca11c93ca4723675985179cfa8\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"86aa64efb614676f02c416ecf2393087\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:114;i:8;}s:32:\"7aa2389a47f04b299b4e02228ec09149\";a:7:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"7b20bf414099f61344fe22b7a930bb9b\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"fb9c6532a313e8f63f40668d24fa1104\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:4;i:103;i:2;i:105;i:2;i:114;i:2;}s:32:\"c2f01e651fe83fead8e3680a3b83dd53\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:11;}s:32:\"f0e93f299d67daf6e2f78b815dbcd376\";a:7:{i:69;i:1;i:70;i:1;i:84;i:2;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"221bccdafbd3e1ea3a600583306b1629\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"6d1b3db0066b3cdbe201586e6fff1b6d\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"845c9301c463d7f4ac020be0d578642c\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"f8b237e2655ed04bcecbf987da05a9c1\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"10dafb7ca5ab4fa1bdf324513ddaf389\";a:4:{i:70;i:1;i:99;i:3;i:103;i:1;i:114;i:3;}s:32:\"2223417df036d213ed0f56185558b41b\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:11;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"ea6e2e2542712301f6946d5bc2630413\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"e2fdde99b159c933a80938bad933e3cb\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"911b872126e5ea1dd75943276acf0348\";a:4:{i:69;i:1;i:70;i:1;i:99;i:1;i:103;i:1;}s:32:\"460330c6952136b0470984c2106c025e\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:10;}s:32:\"77dc2d08eaec428984027fdad05a6d23\";a:7:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"74e2762f5711f7024676176010fb9810\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"250ab26ec016565b17d4e245d60190c3\";a:5:{i:69;i:1;i:70;i:2;i:99;i:6;i:103;i:2;i:114;i:5;}s:32:\"46c4be4d476e2c8bcbbe27217570ee1a\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"8677136ac2a0208819001a985053da71\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"c6ca44eab7a9a3b3d24a536469d070d0\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:11;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"09a3092325847378b62ca550af147b30\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:4;i:103;i:2;i:114;i:7;}s:32:\"34df9aba134b89f0ca6f0470dbe0fbd6\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"7863b3b987a0b8cea5e8c8ac29051a39\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"dffd45d4f1e37733fc51737962977c34\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"4d401a453edd82dd18585e704b66434f\";a:7:{i:69;i:1;i:70;i:1;i:84;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"3179654e45730d61536b196c90839592\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"f8543b767734d10db993b66d5d08795c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"bf5e340586e7a99d245558a982ec84d5\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"6a65e4d05dc6f15ed72161b3162477ce\";a:7:{i:69;i:1;i:70;i:2;i:84;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"0cf299f5a4c773563adf9f504af30692\";a:6:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:6;i:103;i:3;i:114;i:10;}s:32:\"6757168d38b2ee61199b7bc6149922a2\";a:3:{i:90;i:1;i:99;i:1;i:114;i:3;}s:32:\"2f631eabdd4baaab2136a4fe1816687d\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"0ca6723c900837f30eaffd2b0dab4327\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:13;}s:32:\"1d2d0b0f4ddcb636afb875cfc77e814b\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"7531b588c380cc5c2faf1337a9fc1afd\";a:7:{i:69;i:2;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"28e5aa7067660220fc7e18c6333a43e8\";a:1:{i:114;i:1;}s:32:\"45a9b20840b28372f554009068b031c9\";a:6:{i:69;i:1;i:70;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"f3d2781bf78f072c35367133a1fdac49\";a:5:{i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:1;i:114;i:3;}s:32:\"d6213fcdccf0c3410d1e2def39784a7a\";a:6:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:4;i:103;i:3;i:114;i:7;}s:32:\"b1c07aea4b77cfab182ab4c3a0632590\";a:3:{i:70;i:1;i:99;i:1;i:114;i:1;}s:32:\"433532d87c2ec1c194eae3ba1b2c2935\";a:5:{i:69;i:1;i:70;i:1;i:99;i:4;i:103;i:1;i:105;i:1;}s:32:\"ca715c68378a3cd58967cf609112b1bc\";a:5:{i:69;i:1;i:70;i:2;i:99;i:5;i:103;i:2;i:114;i:4;}s:32:\"5ce9b825b6d46baa455f738dd3a95060\";a:7:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"02a0f4be78534bde6ee505ad6f287983\";a:3:{i:99;i:3;i:105;i:1;i:114;i:1;}s:32:\"57b72fd06ced17338abc5ad350b415a6\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"9c53ce2a484edad235e0d304b1724a72\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"3dbe4e332c24f508fb77908bda0543c7\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"497a90ed6a11193df6d9a72383f0aea9\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"8c9a3dcad83d1e5850595652b57539c2\";a:7:{i:69;i:1;i:70;i:2;i:84;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"d2f7569401e036413596434c2e8794ab\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"9e8df226b0b43e3a64d3bc50681b6a4b\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"81760509019409c421af9b73786f3449\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"978e4f4c34a5ff4331a24cf48462185f\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"1aa8c3eed9980eb53a1b1a7c343fe768\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"5ea1730d9e385140ba73fb8b153efb7a\";a:8:{i:69;i:1;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"6ae89cbdbf6da19f17cecc0cca64c4a2\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"2f5dcb68adcf2e57c58f2039b3696912\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"1f67f8a0f4806eb2a7ef171dd26fc882\";a:6:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:114;i:6;}s:32:\"9bc7523aaacabefa5169f344189f2343\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:2;}s:32:\"3b27ec67eca19f35fb67017999fc52a6\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"9cb76a2bd44c1c13dc8f5fc1e99671b9\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"047680b40c3139ae288935efee5b6c80\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"8faa642ed8b55307938844bcb46bd9f0\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"c465203183becb193266398296d9add1\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"f0b23732a05e498d919edaa96727fdb9\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"41b620bd3d698d9f6c7aa6063037360e\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:3;}s:32:\"0a48c5b92fcd11a13302fe902101c0b6\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"fa585cbb72c7dc5c8a6f175e0e20f2f1\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"485e2f7062c2b2475770bec2d4e143c1\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"f4c5c1dd8e95e9e6ca08ba086583494f\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"b52733e16e99f0c42f9e8050beaf39af\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:11;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"5ed7f8fc9aba47b5b1ebcb1fe96681cb\";a:7:{i:69;i:1;i:70;i:2;i:84;i:1;i:99;i:9;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"8deb8f8a95c2448ebae584cddd40a360\";a:7:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"fcf10d43c9a0fcd8b6aada739ce95dc8\";a:3:{i:90;i:1;i:99;i:3;i:114;i:4;}s:32:\"3ea4054ad3af216ea1e92a88108f5eb1\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:114;i:8;}s:32:\"e191687063de80c52cf35c59fe08353b\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:114;i:9;}s:32:\"761004b22cb0c23bb4e26ea40b0cadab\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"3bb3bb3508d98b2bb7b689ebd9c1c595\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"ad1cf035b9cc2ec7bda655c4e6b08b8d\";a:8:{i:69;i:2;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"a05b2598d03855855d5617c5fe418051\";a:6:{i:69;i:1;i:70;i:1;i:99;i:6;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"c99bde71ada9035de0aa936f3d3cb3d3\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"02c547948c5ae15e4e7fd87d3027363b\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"936c255023b3a299170573ef36590ff7\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"f36e42d7cb3809d63c97901a21c81f0a\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"e6755dd03cb6f3f5882e2d6cdfb5e55f\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"8be04764da6f1ae19957b080479fc2ba\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"c653d6f866fdcb003156d15c53f4d21c\";a:5:{i:69;i:1;i:70;i:1;i:99;i:2;i:103;i:1;i:114;i:1;}s:32:\"c85722aea1c06872c2e07a666059ef28\";a:6:{i:69;i:1;i:70;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"b2e94ff702bc4575eba025328353f605\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"16c2b4d85905eb292d8d63f1e8bcafff\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:4;i:105;i:2;i:114;i:8;}s:32:\"f5db1e9267e5931bd36e5d6eec44b8d7\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"6559fdd882f04e2397b229c44310e041\";a:6:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:114;i:5;}s:32:\"e6b537b1665614e5d94071508cae7a0f\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"877f6dad73b4056c78529acc59f08d7f\";a:7:{i:69;i:1;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"fa9415ed157a2420ee89f546e238d790\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"b291e34148908b3d7e247e581598a463\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"61e80b7409c793ccef8f6d618d759941\";a:7:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"bf3137d99494a3a99337d92eb483087d\";a:7:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"020f58d0f95157d7d915c95754bcd78d\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"93173ace97b1a4f937a336e500bacb13\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:2;i:103;i:1;i:114;i:1;}s:32:\"2b0e9888d2b2ff39369db60e03496eaf\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"74a360052d7b7c347450a926679a54f2\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"e5631b81aa07dc5282240553acbacee2\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"d14d967408a215e5ea1d8fa6446efdb2\";a:6:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:6;i:103;i:3;i:114;i:9;}s:32:\"40fff4cd5549fda526703a8ecd95f428\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"aa0ac406134bdc0908971465f26456b5\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"5cf44369c0b5e7b8f096effeee1b85f3\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"49632249c54c604b93e51ebd83ffbe98\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"85b2b5ea3dba1de456f5788bac4c534f\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"d6b287e81647bd7a1be4c949a4b4a4e1\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:1;}s:32:\"5d30fcc8713d5326d2c9ead5db328660\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"9a3fe0fe8654efaac34e8f8a3c2a75d8\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:2;}s:32:\"f94823e9b625e30a04cf392ba8fcd0a4\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"d5f7b9cad4cf39d0271ae850355985aa\";a:6:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:6;i:103;i:3;i:114;i:9;}s:32:\"35ac552244193d1429829b48a87f5601\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"37b26447ad4766e1ca42f3ea03613e0b\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"2379e7c6ad059caa8355880feeb7ee42\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:5;}s:32:\"d16e746f244f9e1b12339efee648dc10\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"4a1670ab8319a54db407d188a5218418\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"5a41ff593621597de937072687189ae4\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"3a4bc6feafe8ce653f1f54811110c46b\";a:6:{i:69;i:1;i:84;i:2;i:90;i:1;i:99;i:6;i:105;i:2;i:114;i:6;}s:32:\"cf5debe53d70511c59dcea9104f8d0d4\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:3;}s:32:\"68426e4b35f91347ace1c034c9ef66c0\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"653a0b99a1720e9c470ea163efea5b26\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:6;}s:32:\"fb146b30b46af99a7663d2a9e660f7be\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:7;}s:32:\"cce0604d358e3c2f3be51dab3279eecd\";a:3:{i:99;i:3;i:105;i:1;i:114;i:1;}s:32:\"6abd01ef0e6d2645dc3756900d7c01c4\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"e966dc1f3cf9dae729c4a3f9e65fbc75\";a:7:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:9;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"fa328a55eac00657a3c61dc56c6ea7b5\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"befecdbbdc0f47f60f5d37db28489208\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"9ac642eaec79b93c29094f2e93fa32dc\";a:8:{i:69;i:1;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:1;i:105;i:1;i:114;i:5;}s:32:\"70b3605f07bfca21fcf81e0a4df46e17\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"0cebc0d3ed21bf905e19f66ec17ae8e1\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:12;i:103;i:4;i:105;i:1;i:114;i:12;}s:32:\"aa316e84779c64a2192da7e380dc4ec1\";a:8:{i:69;i:2;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"88786840704a33fac96b5dbc6b8e5447\";a:8:{i:69;i:2;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"65d18c9f066884c80f843e1633af52df\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:114;i:7;}s:32:\"50aafee82c582e15b2575f0547d3e74e\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"6af92e21ff97859098ad402a95147659\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"abbb6ec26f9cdaaa4bc2960f9e4d42b6\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"c8182515225caf529a3d6fbeefe06d1f\";a:1:{i:99;i:1;}s:32:\"fec55b0b13caf5d3d567e2f987eeb390\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"50fa67e0e2e636cefd4057e65478188b\";a:7:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"cf5dd433f63c46de7f907df35b9b25b6\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:3;}s:32:\"bcc13fab15cd924f8cffff9494f4e753\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"653e83d8b0da3ddecb6e52d50932d2a0\";a:2:{i:90;i:1;i:114;i:1;}s:32:\"a02dd10e46598c1e01ef2270b9fdd486\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"ac591b0568145192a6a74907283e0312\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"c6b438f4b060e01ca92fbfc1ae016974\";a:2:{i:99;i:2;i:114;i:1;}s:32:\"4ae2cea549b246b4cb9150d280f672c4\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"f410a8360e7a99730a39318d6dae724f\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:2;i:114;i:6;}s:32:\"7a5caf88a442195d4c310b24926475d0\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:2;i:114;i:4;}s:32:\"a5c43e0951ce9e17fe473877d7d91b07\";a:7:{i:69;i:2;i:84;i:2;i:90;i:2;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:8;}s:32:\"981553a0da0698c62a98df2ef0812b5e\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"6b8f86936ceff4663f27a5a4635e041a\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"b321a2b42643dd6efc419bb345a5f389\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"2e60a3d10cb96726300dbbc3ff869d38\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"059d433be66b53a9c00500de3f089601\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"c713398348659d3837108b32fe12341b\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"976cf6d6453c9284575fc771277b94c8\";a:6:{i:69;i:1;i:70;i:1;i:90;i:2;i:99;i:4;i:103;i:2;i:114;i:9;}s:32:\"0cd30ad64afa26299392295ec8df2c29\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"986634bd09ebb5a3acd9faa79e233d00\";a:5:{i:70;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"e8cdea7a59150f43abd3da6fdbd691ad\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"da0b5c3561b5fad449c2fe5818eaa122\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:6;}s:32:\"8cde393308039624ebff2a10fcb576f4\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"08b89f91de43565ec695e79b95cb68af\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"8ad8c1243e95cb55b113825e3b7bac36\";a:6:{i:69;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:105;i:2;i:114;i:4;}s:32:\"a815db7a62c046b772420ee73d4f4997\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"31f3b448c38d109414e9ca2dfa9b9ca3\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:4;}s:32:\"0d47da2548b480b1f2f03e62042f3640\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"cd99a2a07c5df28f21e7dfefecd11940\";a:3:{i:90;i:1;i:99;i:2;i:114;i:4;}s:32:\"d0fd5b2295526f5765917afc1662e9aa\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"6f7247c4252cf51d4f48d9f62772c3c0\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"9fbae53cd3864ff8ce81279b74774325\";a:5:{i:69;i:1;i:90;i:1;i:99;i:2;i:103;i:1;i:114;i:6;}s:32:\"72988fd4362cc779588731e58bb07f78\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:5;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"fd7a37906f03c0025a5558150582b341\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"f729b9de7729a47342529dc87f5d6bcd\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"c7326bb9f906b07589cd8fce1cdfe7d0\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"37e7d706b1e68796378c739a4e04b903\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:2;i:114;i:2;}s:32:\"b1e9c170d184844f30830424799353da\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"ba420545959fc9b0bf78d5a3f2f9193c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:2;i:114;i:3;}s:32:\"99a021500844225d86a9f5cc4749a717\";a:5:{i:69;i:1;i:70;i:2;i:99;i:5;i:103;i:2;i:114;i:5;}s:32:\"ea797eeb8946cfe57ce12f598cbe87bb\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:4;}s:32:\"131577d4602c18e62cb14547579ded53\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"572e0daa2019940ef7c7ac16504a0fa0\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:10;}s:32:\"dc6c6b3021139b4abc2e9a46509572c9\";a:5:{i:69;i:1;i:70;i:2;i:99;i:5;i:103;i:2;i:114;i:4;}s:32:\"4bbecb81729baff31eb7e982deda616b\";a:5:{i:69;i:1;i:70;i:1;i:99;i:3;i:103;i:1;i:105;i:1;}s:32:\"58e95e2d0fdf419685a1abfb99bbf19d\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:2;i:103;i:1;i:114;i:3;}s:32:\"a46f2d31f0f31e39e388d810f977a6cc\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"b2222ab97a70a4410d0e870336a161fa\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"9fed3827e661582369ef3b8ad4663c4f\";a:7:{i:69;i:2;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:8;}s:32:\"b0f301bc7097c986a2ee3c9a663f387c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"6cdeec2a99cccfc5a1af645d0123674d\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:2;i:103;i:1;i:105;i:1;i:114;i:2;}s:32:\"0b2497e857b9b6b5cdf2fe2495775e8a\";a:8:{i:69;i:1;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"12ebf04d036bc5452dabe5c76f765f11\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"acc68eeaf909671f6eb74a61befee538\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"e0d9d39f571839ac38450acfaf1582d2\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"6f7f1884890351b093785e4873634846\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:2;i:114;i:6;}s:32:\"008bdcbbcd9bfc14e8505c928ced784f\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"b2114b0bc13fae0b110a559224e6a828\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"08a435726b0f685e060d70db469b4b3e\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"2d96bd1cc3ee94fbae515ddbcf03889b\";a:3:{i:90;i:1;i:99;i:3;i:114;i:4;}s:32:\"27ff1ba01ff69a75f6bb7fa5437a410f\";a:1:{i:114;i:1;}s:32:\"2327a24727cddb21549d9d254a4e878f\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"0cdd57e9cb44207e2da4526fa19687fe\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"5d8c7fb45d8e702f2f0c57c93dc0ff19\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"7b3ab359a71baa99017954586d4ef143\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"a79ef7f5adae40140a31e9f936a97331\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"29ba8f95856bee5eee546a50255fed98\";a:2:{i:90;i:1;i:114;i:1;}s:32:\"9e48657b9675b25c293ef967383c18e5\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"6fcb8af2f4ae5cfc4612587c2db6fa1f\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"3a3ce5c43621f6b5db6a121169293415\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"84528c74f1b63fd523d437e87e3d34c9\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:8;}s:32:\"56666c0eb5662d1f0a7732a67bd4119b\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:12;}s:32:\"9cedf7ceb99566da2fd85033bd24e734\";a:6:{i:69;i:1;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:114;i:6;}s:32:\"f4c85a4913b15069551a11e3076d0aaf\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:3;i:103;i:2;i:114;i:6;}s:32:\"885fcc1b640201055e490124b2d79194\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"27ceefcfc5abf6992afcac37563a7f03\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"bd0fdea099a64e184f80238e45165e48\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"3fe4c8f9199793286221d82460151196\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:12;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"de474634965e277aed78c6fa4986ad37\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:4;}s:32:\"5a3a14b4c44fb97c3d6f8c96122eda06\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:4;i:103;i:2;i:114;i:8;}s:32:\"aee366b4c4bcd43f432f558909c474c1\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:11;i:103;i:4;i:105;i:1;i:114;i:10;}s:32:\"6483de6fd68eb0cdc1252e285bf9c30a\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"f2eb01895a9471420923b51e329e0c44\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"6c7c3a9a3eec9cb915a49226c38356a2\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"4a6c432bd3c2d92cec35689dc80fdc71\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"9f8a09e7df5be8f772f5e9ecc25f6894\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"f862ebc1293dbb946a942f6459388f26\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"fbc590f0bc56423238c86eaac7e9c2d4\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"44cba065275be1543f26bf6f71a02ce7\";a:8:{i:69;i:2;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:6;}s:32:\"4a76f902ddd1933be96aff6fc11a73ac\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:11;}s:32:\"502dc4fa0a9ab974827b44a548a02295\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:3;i:103;i:2;i:114;i:6;}s:32:\"119d5a14f692e2cd8e1c991e67a06ac5\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"18ce8bc63356b8492069bc7448752750\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:1;i:103;i:1;i:114;i:1;}s:32:\"f7864588572154c2cce31afa8ae4b65b\";a:6:{i:69;i:1;i:70;i:1;i:90;i:2;i:99;i:5;i:103;i:2;i:114;i:9;}s:32:\"5aed03d4611fd00fe32281a01ab8210c\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"694f50ec10c11de3a62cd02ae0dc7ffd\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"6f191f0688b2848603f482d14e3d3e6b\";a:5:{i:69;i:1;i:84;i:2;i:99;i:2;i:105;i:1;i:114;i:3;}s:32:\"9732252d3515f56cc351ad1795422d5f\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"3e24c78cd727e96625a4be0f0257f15e\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"f2478fe0e80639cea7ce87e2a1b85de3\";a:7:{i:69;i:2;i:70;i:2;i:84;i:3;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"abded4777e6d8e882ca3b35ecce65458\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"eafc3fb27d1dabbc36c3ecf72ae42c5b\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"be3e404d8d47bb96bd11246facd67ca4\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"39a0758ed70838b410f649113747f62d\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:5;}s:32:\"3a360b5e8d5c42cd8256fad8fe019ce3\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"9d58720f9cbca79b79b6388bc85dc27d\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"500d5b078f6b926cb5c8f9d2b2031e39\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"45b22c6d2073fc898ec3e5de23fbb368\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:12;}s:32:\"39a00424dd64295d9fcc48a967401506\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"11d3ac64104b2b791a40922dcc5666bc\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"d4002d8dc43c01c55f131e39981f2d84\";a:7:{i:69;i:2;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:8;}s:32:\"c85c6539e49e312aba49c2be19392b50\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"e08996ab2847877ed3c3476397e99c8f\";a:7:{i:69;i:1;i:70;i:1;i:84;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:1;}s:32:\"2220476a7357acea517baee568fa1464\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"25fdb87c009b99690d5924cce0d3d1bd\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"6bc5df38af353dc892cb4474e2bc7e06\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"a0f65f9979e443508cbdec49deb8c0ed\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:8;}s:32:\"1f77e746442e285075aed67cda39303e\";a:7:{i:69;i:2;i:84;i:2;i:90;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:7;}s:32:\"d63599fcceded58306e74cc1174d83b6\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:114;i:6;}s:32:\"57c9b21d5270d783b0dd33b533651776\";a:5:{i:69;i:1;i:70;i:2;i:99;i:5;i:103;i:2;i:114;i:5;}s:32:\"be4461c0db00d222b3eb7157af8cdbfa\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:3;i:103;i:1;i:114;i:2;}s:32:\"8dd656c077e1c655712bc9694c9abe2d\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"7a40377e022b841a742899704c1e4c67\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"9a15edcc883af1a07223684c39bbd6e8\";a:5:{i:69;i:1;i:70;i:2;i:99;i:5;i:103;i:2;i:114;i:3;}s:32:\"325478b8b0465628860c6373e8071a5d\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:114;i:8;}s:32:\"8802374cc968c82801664611f8e4e17c\";a:5:{i:69;i:1;i:70;i:1;i:99;i:2;i:103;i:1;i:114;i:1;}s:32:\"ffff45b7907eadc92b4be973fb507ba9\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"df9bab28145b9e805a5938b12bf9590a\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"1f9a26b446867dfbcb54de48b4e88e08\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:5;}s:32:\"0f72d62e265d6ee970e76ed14ef99d11\";a:6:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:114;i:8;}s:32:\"b8bd428cdc382b2ed3b831ca4c198115\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:2;i:114;i:1;}s:32:\"e3fb92e968487af47a5e041fa93856a2\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"930812b34ccbf9527da376c7477e0a92\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:5;i:103;i:2;i:114;i:9;}s:32:\"f7e687b3f7a2379065af0724ad57b597\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"706b224fdab0f444d5c6ecfdf85847bf\";a:7:{i:69;i:2;i:70;i:2;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"d3a7a1b93e71ea39ffdf7d4bcd170340\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"64d0e7949823277f1e8515967b724c62\";a:7:{i:69;i:1;i:70;i:1;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:8;}s:32:\"7d781c9c33c63a555dccbe96170f6f74\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"c6729503a36f39aef22b8cdfed8ecec9\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"ff76676c1cc3be78995a50048a3dba96\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"a06f85c1b679d0c79299fe57c6e8f7e4\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"54f5985448deb9dd939459911618e4d6\";a:8:{i:69;i:2;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"e520647546f93e27ed1d3573e334b2bf\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"0a761646f58395df408d26fa4301a3cb\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"4e70f7be2f6f1329301df599a6685674\";a:8:{i:69;i:1;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"4846d3420f0ceddd15f669b80deadeb8\";a:8:{i:69;i:2;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"587577235d71373515f24cfea7cff060\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:10;}s:32:\"07cf9a8440e4af47d2a56b346f29724c\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"4a18eafc107c6c0e088bf1191462a7ac\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"e5abb29977e4878b955dff6d74275f7e\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"9fa8917216c9bfec45c33bd59b21b72f\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:3;i:103;i:1;i:105;i:2;i:114;i:2;}s:32:\"030389419246971d579a64087f51c428\";a:2:{i:99;i:3;i:114;i:2;}s:32:\"5e76684864efb555b751295038a28754\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:10;}s:32:\"a3295a1cdd971812818cadc76581578c\";a:5:{i:69;i:1;i:70;i:2;i:99;i:4;i:103;i:2;i:114;i:4;}s:32:\"f872f468d45e909acd0b7bed8d6e5931\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"f63bfb5eb53db02a4cd869dc8338c7b3\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:13;}s:32:\"4b1decceecbaaf4491920ec2ca649fe0\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"eee7078776f1e0ac18c9642630d10db7\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:4;i:105;i:1;i:114;i:8;}s:32:\"823e4325ec9a94657841fcc4ccf1bb99\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"93c378d0826af18f3df27a3ba7093b2e\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:3;}s:32:\"8c6eb1c495b56b71aed9bf696f5726ff\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"831e3756a99cb371b1030d8d6fed9e7a\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:9;}s:32:\"219156e1c7e90168046ce368b9a85f86\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"fe94127ce3448e9530a0c1b7f1259a4c\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"05ef1e3f246d85437444b6cf10bb139a\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"78d759bb56b89f22435bb67eddecd390\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:10;i:103;i:4;i:105;i:1;i:114;i:11;}s:32:\"d7d00bdef549318fea2d7e111347f5ee\";a:6:{i:69;i:2;i:70;i:1;i:90;i:2;i:99;i:6;i:103;i:2;i:114;i:9;}s:32:\"65de6cf5830c1df2d071f859df83bce3\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:114;i:9;}s:32:\"85a3b8bfc7de2b35c5c2262da6563a62\";a:4:{i:70;i:1;i:99;i:5;i:103;i:1;i:114;i:5;}s:32:\"3a403a8b2dae0fc63fd9ada6ffb3adc0\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:11;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"43e7fa2857915896b3f85eb410f8a57c\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:8;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"e22f1377cc131d62f5abdd97719883b1\";a:7:{i:69;i:1;i:70;i:1;i:84;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"d6bd624516b2417f21893e71799bb1e9\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"6144ec7f488816768651ec4672dac356\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"e1f211c9522d4bd1f0374c26d39d7e57\";a:7:{i:69;i:2;i:84;i:2;i:90;i:2;i:99;i:6;i:103;i:1;i:105;i:2;i:114;i:9;}s:32:\"dd458dd82832218ec3686618abc5bfb7\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:7;}s:32:\"7cdac96bc98e2c6432b58acf394ee2b9\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"1fb1f7923a24145017eeca080e6a5a41\";a:7:{i:69;i:1;i:70;i:2;i:84;i:1;i:99;i:9;i:103;i:2;i:105;i:1;i:114;i:6;}s:32:\"b2ed120ab2a0de5931788714df87347d\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:9;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"003a4194a1b5cf5c7f8ec46cddbd0979\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"21ee509ea609684e446f38ae1d1832c0\";a:7:{i:69;i:2;i:70;i:1;i:84;i:3;i:99;i:5;i:103;i:1;i:105;i:2;i:114;i:3;}s:32:\"069780c345338b2fa670aa169d51d2a1\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:1;i:114;i:9;}s:32:\"09fa34508d083d30c70b8e3f45af82f8\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"f28acbe79ec50cbc2a477d049358d66c\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:10;}s:32:\"356dc3cf1914cc294561090b87a8ed73\";a:6:{i:69;i:1;i:70;i:1;i:99;i:5;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"b3989703f6d7f2d34b5af56842fd2a16\";a:8:{i:69;i:3;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"54d68ba982808e743a4f3f0e478edf6f\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"68ba6582837582e033fe900fd61b8f15\";a:8:{i:69;i:3;i:70;i:1;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:9;}s:32:\"27ff9eb6ae9239f2391c09a834d1d729\";a:8:{i:69;i:1;i:70;i:1;i:84;i:1;i:90;i:1;i:99;i:4;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"724db9bd7949055f14a48437abd3b3f6\";a:5:{i:69;i:1;i:70;i:1;i:99;i:3;i:103;i:1;i:114;i:1;}s:32:\"2bd7d9042097f90a8942013a14d2f156\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:5;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"754b14cf9ac93e1a7a071f63081fbf66\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:9;}s:32:\"58a122718fded1da4a2ff274c16832ef\";a:6:{i:69;i:1;i:90;i:1;i:99;i:6;i:103;i:1;i:105;i:1;i:114;i:7;}s:32:\"d844842b85ff3c1a68a5f5c8c456e490\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:2;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:11;}s:32:\"8fb5a27f5515857efe13dda14d7677b1\";a:8:{i:69;i:4;i:70;i:2;i:84;i:3;i:90;i:2;i:99;i:6;i:103;i:3;i:105;i:2;i:114;i:9;}s:32:\"80255c657d6a5102aad485e85865151c\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"fb384f804651c58f73556fea96756f69\";a:8:{i:69;i:3;i:70;i:3;i:84;i:1;i:90;i:2;i:99;i:11;i:103;i:4;i:105;i:1;i:114;i:12;}s:32:\"74c5af578ca60ba78535bf1a3425525a\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"479c237c75c2e7b3904fb0582b8da008\";a:7:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:10;}s:32:\"40aeb0b6ace1bf8cc349895bd3373036\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:4;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"9b6eae1cc90f0158c8d7d0e66c371af9\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:4;i:105;i:2;i:114;i:8;}s:32:\"59f04d7d92ec6c780f07bfc0c78ae6ac\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:3;}s:32:\"76f1f203dabb8036cbee10db5f9d22f8\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:9;i:103;i:4;i:105;i:2;i:114;i:10;}s:32:\"1f5a628ccfc720a6295fd064095c90c7\";a:7:{i:69;i:3;i:70;i:2;i:84;i:3;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:4;}s:32:\"6f30abc314a01d426d6c6598db229e24\";a:5:{i:69;i:1;i:84;i:2;i:99;i:4;i:105;i:2;i:114;i:4;}s:32:\"5476b25deefdc7e2b1c305568d001dd8\";a:8:{i:69;i:3;i:70;i:3;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:2;i:114;i:6;}s:32:\"f91ff7612af080a4197c7b8a178f402a\";a:8:{i:69;i:3;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:7;}s:32:\"d876905c853958e22d2395623aaa467b\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"a4a16f16c177974225b2bd27a7e9a61d\";a:7:{i:69;i:2;i:70;i:3;i:84;i:1;i:99;i:10;i:103;i:3;i:105;i:1;i:114;i:6;}s:32:\"851df17e11b38bb2c9eacbb642045cad\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:6;}s:32:\"cd2fb93fa37fadf3c20c09d6436ebd31\";a:8:{i:69;i:4;i:70;i:3;i:84;i:3;i:90;i:2;i:99;i:8;i:103;i:4;i:105;i:2;i:114;i:11;}s:32:\"34e0256f76d8cad371dc66c9ea103096\";a:6:{i:69;i:2;i:70;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:114;i:9;}s:32:\"a08bd35ea3063a99879e30a66d44b38b\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:6;i:103;i:2;i:105;i:2;i:114;i:5;}s:32:\"3785f39192bb962540e8b7643aa8c0a1\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"2e90013b04ca9caa1e3a6e5ebaaec873\";a:7:{i:69;i:2;i:70;i:1;i:84;i:2;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"8ed6d754f8ffa101422b54b3d33e262f\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:9;i:103;i:3;i:105;i:2;i:114;i:8;}s:32:\"b6d907404aa91aa6ad072303185c738e\";a:8:{i:69;i:2;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:4;}s:32:\"2f316e59fbf99e1f965a85705f6a7872\";a:7:{i:69;i:2;i:70;i:2;i:84;i:2;i:99;i:5;i:103;i:2;i:105;i:2;i:114;i:3;}s:32:\"d195f983fe197b431683733eb87303d5\";a:7:{i:69;i:2;i:70;i:2;i:84;i:1;i:99;i:6;i:103;i:2;i:105;i:1;i:114;i:4;}s:32:\"bc34931acf5a8f863e7d27211cb345a5\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:7;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"537d0be60ce92b78d53e5b68d0e2b82c\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:2;i:99;i:9;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"0e5896d767c59bca8061633ff3601a60\";a:7:{i:69;i:3;i:70;i:3;i:84;i:3;i:99;i:10;i:103;i:3;i:105;i:2;i:114;i:7;}s:32:\"49e9b97d21b1c92c502d13052bef9c72\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:6;i:103;i:3;i:105;i:1;i:114;i:8;}s:32:\"bcf6cf815f9280ddebca7236b19c627e\";a:8:{i:69;i:2;i:70;i:1;i:84;i:1;i:90;i:2;i:99;i:7;i:103;i:2;i:105;i:1;i:114;i:9;}s:32:\"6861c70bec436c0649c1ab721f39b23d\";a:8:{i:69;i:2;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:5;i:103;i:2;i:105;i:1;i:114;i:2;}s:32:\"9a196cf2135d10c946e2fbd256c74d6a\";a:6:{i:69;i:2;i:70;i:1;i:90;i:1;i:99;i:4;i:103;i:2;i:114;i:7;}s:32:\"4bd9a973976979ef82647e9886d1fb99\";a:8:{i:69;i:3;i:70;i:2;i:84;i:3;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:2;i:114;i:7;}s:32:\"522426b5ee449eb71366af1ab6605c0e\";a:8:{i:69;i:1;i:70;i:2;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:2;i:105;i:1;i:114;i:7;}s:32:\"a5346d8769087bf94def57e70b66b787\";a:8:{i:69;i:3;i:70;i:2;i:84;i:2;i:90;i:1;i:99;i:7;i:103;i:3;i:105;i:1;i:114;i:11;}s:32:\"debe3e1db90f34ec667bcd4fbbe42ecc\";a:8:{i:69;i:1;i:70;i:1;i:84;i:2;i:90;i:1;i:99;i:3;i:103;i:1;i:105;i:1;i:114;i:6;}s:32:\"9894392dd7a8d25a90d741f727cc48a2\";a:8:{i:69;i:2;i:70;i:3;i:84;i:1;i:90;i:1;i:99;i:8;i:103;i:3;i:105;i:1;i:114;i:5;}s:32:\"eb34daebda02a6c5e72b961ba9ce414c\";a:7:{i:69;i:1;i:70;i:1;i: